/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.entity;

import com.google.common.base.Preconditions;
import jakarta.annotation.Nullable;
import org.apache.polaris.core.admin.model.Principal;
import org.apache.polaris.core.entity.PolarisBaseEntity;
import org.apache.polaris.core.entity.PolarisEntity;
import org.apache.polaris.core.entity.PolarisEntityConstants;
import org.apache.polaris.core.entity.PolarisEntitySubType;
import org.apache.polaris.core.entity.PolarisEntityType;

public class PrincipalEntity
extends PolarisEntity {
    public PrincipalEntity(PolarisBaseEntity sourceEntity) {
        super(sourceEntity);
        Preconditions.checkState((this.getType() == PolarisEntityType.PRINCIPAL ? 1 : 0) != 0, (String)"Invalid entity type: %s", (Object)((Object)this.getType()));
        Preconditions.checkState((this.getSubType() == PolarisEntitySubType.NULL_SUBTYPE ? 1 : 0) != 0, (String)"Invalid entity sub type: %s", (Object)((Object)this.getSubType()));
    }

    @Nullable
    public static PrincipalEntity of(@Nullable PolarisBaseEntity sourceEntity) {
        if (sourceEntity != null) {
            return new PrincipalEntity(sourceEntity);
        }
        return null;
    }

    public static PrincipalEntity fromPrincipal(Principal principal) {
        return ((Builder)((Builder)new Builder().setName(principal.getName())).setProperties(principal.getProperties())).setClientId(principal.getClientId()).build();
    }

    public Principal asPrincipal() {
        return new Principal(this.getName(), this.getClientId(), this.getPropertiesAsMap(), Long.valueOf(this.getCreateTimestamp()), Long.valueOf(this.getLastUpdateTimestamp()), Integer.valueOf(this.getEntityVersion()));
    }

    public String getClientId() {
        return this.getInternalPropertiesAsMap().get(PolarisEntityConstants.getClientIdPropertyName());
    }

    public static class Builder
    extends PolarisEntity.BaseBuilder<PrincipalEntity, Builder> {
        public Builder() {
            this.setType(PolarisEntityType.PRINCIPAL);
            this.setCatalogId(PolarisEntityConstants.getNullId());
            this.setParentId(PolarisEntityConstants.getRootEntityId());
        }

        public Builder(PrincipalEntity original) {
            super(original);
        }

        public Builder setClientId(String clientId) {
            this.internalProperties.put(PolarisEntityConstants.getClientIdPropertyName(), clientId);
            return this;
        }

        public Builder setCredentialRotationRequiredState() {
            this.internalProperties.put("CREDENTIAL_ROTATION_REQUIRED", "true");
            return this;
        }

        @Override
        public PrincipalEntity build() {
            return new PrincipalEntity(this.buildBase());
        }
    }
}

