/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.udf.builtin;

import java.io.IOException;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.udf.utils.UDFDataTypeTransformer;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.AccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.RowByRowAccessStrategy;
import org.apache.iotdb.udf.api.exception.UDFException;
import org.apache.iotdb.udf.api.exception.UDFInputSeriesDataTypeNotValidException;
import org.apache.iotdb.udf.api.type.Type;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.utils.Pair;

public abstract class UDTFSelectK
implements UDTF {
    protected int k;
    protected TSDataType dataType;
    protected PriorityQueue<Pair<Long, Integer>> intPQ;
    protected PriorityQueue<Pair<Long, Long>> longPQ;
    protected PriorityQueue<Pair<Long, Float>> floatPQ;
    protected PriorityQueue<Pair<Long, Double>> doublePQ;
    protected PriorityQueue<Pair<Long, String>> stringPQ;

    public void validate(UDFParameterValidator validator) throws UDFException {
        validator.validateInputSeriesNumber(1).validateInputSeriesDataType(0, new Type[]{Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE, Type.TEXT, Type.STRING, Type.DATE, Type.TIMESTAMP}).validateRequiredAttribute("k").validate(k -> 0 < (Integer)k && (Integer)k <= 1000, "k has to be greater than 0 and less than or equal to 1000.", (Object)validator.getParameters().getInt("k"));
    }

    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) throws MetadataException, UDFInputSeriesDataTypeNotValidException {
        this.k = parameters.getInt("k");
        this.dataType = UDFDataTypeTransformer.transformToTsDataType(parameters.getDataType(0));
        this.constructPQ();
        configurations.setAccessStrategy((AccessStrategy)new RowByRowAccessStrategy()).setOutputDataType(UDFDataTypeTransformer.transformToUDFDataType(this.dataType));
    }

    protected abstract void constructPQ() throws UDFInputSeriesDataTypeNotValidException;

    public void transform(Row row, PointCollector collector) throws UDFInputSeriesDataTypeNotValidException, IOException {
        switch (this.dataType) {
            case INT32: 
            case DATE: {
                this.transformInt(row.getTime(), row.getInt(0));
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                this.transformLong(row.getTime(), row.getLong(0));
                break;
            }
            case FLOAT: {
                this.transformFloat(row.getTime(), row.getFloat(0));
                break;
            }
            case DOUBLE: {
                this.transformDouble(row.getTime(), row.getDouble(0));
                break;
            }
            case TEXT: 
            case STRING: {
                this.transformString(row.getTime(), row.getString(0));
                break;
            }
            default: {
                throw new UDFInputSeriesDataTypeNotValidException(0, UDFDataTypeTransformer.transformToUDFDataType(this.dataType), new Type[]{Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE, Type.TEXT, Type.DATE, Type.TIMESTAMP, Type.STRING});
            }
        }
    }

    protected abstract void transformInt(long var1, int var3);

    protected abstract void transformLong(long var1, long var3);

    protected abstract void transformFloat(long var1, float var3);

    protected abstract void transformDouble(long var1, double var3);

    protected abstract void transformString(long var1, String var3);

    public void terminate(PointCollector collector) throws UDFInputSeriesDataTypeNotValidException, IOException {
        switch (this.dataType) {
            case INT32: 
            case DATE: {
                for (Pair pair : this.intPQ.stream().sorted(Comparator.comparing(p -> (Long)p.left)).collect(Collectors.toList())) {
                    collector.putInt(((Long)pair.left).longValue(), ((Integer)pair.right).intValue());
                }
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                for (Pair pair : this.longPQ.stream().sorted(Comparator.comparing(p -> (Long)p.left)).collect(Collectors.toList())) {
                    collector.putLong(((Long)pair.left).longValue(), ((Long)pair.right).longValue());
                }
                break;
            }
            case FLOAT: {
                for (Pair pair : this.floatPQ.stream().sorted(Comparator.comparing(p -> (Long)p.left)).collect(Collectors.toList())) {
                    collector.putFloat(((Long)pair.left).longValue(), ((Float)pair.right).floatValue());
                }
                break;
            }
            case DOUBLE: {
                for (Pair pair : this.doublePQ.stream().sorted(Comparator.comparing(p -> (Long)p.left)).collect(Collectors.toList())) {
                    collector.putDouble(((Long)pair.left).longValue(), ((Double)pair.right).doubleValue());
                }
                break;
            }
            case TEXT: 
            case STRING: {
                for (Pair pair : this.stringPQ.stream().sorted(Comparator.comparing(p -> (Long)p.left)).collect(Collectors.toList())) {
                    collector.putString(((Long)pair.left).longValue(), (String)pair.right);
                }
                break;
            }
            default: {
                throw new UDFInputSeriesDataTypeNotValidException(0, UDFDataTypeTransformer.transformToUDFDataType(this.dataType), new Type[]{Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE, Type.TEXT, Type.DATE, Type.TIMESTAMP, Type.STRING});
            }
        }
    }
}

