/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.trigger.api.enums;

public enum TriggerType {
    STATEFUL(0, "STATEFUL"),
    STATELESS(1, "STATELESS");

    private final byte id;
    private final String type;

    private TriggerType(byte id, String type) {
        this.id = id;
        this.type = type;
    }

    public byte getId() {
        return this.id;
    }

    public String toString() {
        return this.type;
    }

    public static TriggerType construct(byte id) {
        switch (id) {
            case 0: {
                return STATEFUL;
            }
            case 1: {
                return STATELESS;
            }
        }
        throw new IllegalArgumentException(String.format("No such trigger type (id: %d)", id));
    }
}

