/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.resource.tsfile;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.commons.utils.FileUtils;
import org.apache.iotdb.db.pipe.resource.tsfile.PipeTsFilePublicResource;
import org.apache.iotdb.db.pipe.resource.tsfile.PipeTsFileResource;
import org.apache.iotdb.db.pipe.resource.tsfile.PipeTsFileResourceSegmentLock;
import org.apache.iotdb.db.storageengine.dataregion.modification.ModificationFile;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeTsFileResourceManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeTsFileResourceManager.class);
    private final Map<String, PipeTsFilePublicResource> hardlinkOrCopiedFileToTsFilePublicResourceMap = new ConcurrentHashMap<String, PipeTsFilePublicResource>();
    private final Map<String, Map<String, PipeTsFileResource>> hardlinkOrCopiedFileToPipeTsFileResourceMap = new ConcurrentHashMap<String, Map<String, PipeTsFileResource>>();
    private final PipeTsFileResourceSegmentLock segmentLock = new PipeTsFileResourceSegmentLock();

    public File increaseFileReference(File file, boolean isTsFile, @Nullable String pipeName) throws IOException {
        return this.increaseFileReference(file, isTsFile, pipeName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File increaseFileReference(File file, boolean isTsFile, @Nullable String pipeName, @Nullable File sourceFile) throws IOException {
        File resultFile;
        File hardlinkOrCopiedFile;
        if (this.increaseReferenceIfExists(file, pipeName, isTsFile)) {
            return file;
        }
        File file2 = hardlinkOrCopiedFile = Objects.isNull(sourceFile) ? PipeTsFileResourceManager.getHardlinkOrCopiedFileInPipeDir(file, pipeName) : file;
        if (this.increaseReferenceIfExists(hardlinkOrCopiedFile, pipeName, isTsFile)) {
            return this.getResourceMap(pipeName).get(hardlinkOrCopiedFile.getPath()).getFile();
        }
        File source = Objects.isNull(sourceFile) ? file : sourceFile;
        this.segmentLock.lock(hardlinkOrCopiedFile);
        try {
            File file3 = resultFile = isTsFile ? FileUtils.createHardLink((File)source, (File)hardlinkOrCopiedFile) : FileUtils.copyFile((File)source, (File)hardlinkOrCopiedFile);
            if (Objects.nonNull(pipeName)) {
                this.hardlinkOrCopiedFileToPipeTsFileResourceMap.computeIfAbsent(pipeName, k -> new ConcurrentHashMap()).put(resultFile.getPath(), new PipeTsFileResource(resultFile));
            } else {
                this.hardlinkOrCopiedFileToTsFilePublicResourceMap.put(resultFile.getPath(), new PipeTsFilePublicResource(resultFile));
            }
        }
        finally {
            this.segmentLock.unlock(hardlinkOrCopiedFile);
        }
        this.increasePublicReference(resultFile, pipeName, isTsFile);
        return resultFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean increaseReferenceIfExists(File file, @Nullable String pipeName, boolean isTsFile) throws IOException {
        block4: {
            this.segmentLock.lock(file);
            try {
                String path = file.getPath();
                PipeTsFileResource resource = this.getResourceMap(pipeName).get(path);
                if (resource != null) {
                    resource.increaseReferenceCount();
                    break block4;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.segmentLock.unlock(file);
            }
        }
        this.increasePublicReference(file, pipeName, isTsFile);
        return true;
    }

    private void increasePublicReference(File file, String pipeName, boolean isTsFile) throws IOException {
        if (Objects.isNull(pipeName)) {
            return;
        }
        this.increaseFileReference(new File(this.getCommonFilePath(file)), isTsFile, null, file);
    }

    public static File getHardlinkOrCopiedFileInPipeDir(File file, @Nullable String pipeName) throws IOException {
        try {
            return new File(PipeTsFileResourceManager.getPipeTsFileDirPath(file, pipeName), PipeTsFileResourceManager.getRelativeFilePath(file));
        }
        catch (Exception e) {
            throw new IOException(String.format("failed to get hardlink or copied file in pipe dir for file %s, it is not a tsfile, mod file or resource file", file.getPath()), e);
        }
    }

    private static String getPipeTsFileDirPath(File file, @Nullable String pipeName) throws IOException {
        while (!(file.getName().equals("sequence") || file.getName().equals("unsequence") || file.getName().equals(PipeConfig.getInstance().getPipeHardlinkBaseDirName()))) {
            file = file.getParentFile();
        }
        return file.getParentFile().getCanonicalPath() + File.separator + PipeConfig.getInstance().getPipeHardlinkBaseDirName() + File.separator + PipeConfig.getInstance().getPipeHardlinkTsFileDirName() + (Objects.nonNull(pipeName) ? File.separator + pipeName : "");
    }

    private static String getRelativeFilePath(File file) {
        StringBuilder builder = new StringBuilder(file.getName());
        while (!(file.getName().equals("sequence") || file.getName().equals("unsequence") || file.getParentFile().getName().equals(PipeConfig.getInstance().getPipeHardlinkTsFileDirName()))) {
            file = file.getParentFile();
            builder = new StringBuilder(file.getName()).append("-").append((CharSequence)builder);
        }
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decreaseFileReference(File hardlinkOrCopiedFile, @Nullable String pipeName) {
        this.segmentLock.lock(hardlinkOrCopiedFile);
        try {
            String filePath = hardlinkOrCopiedFile.getPath();
            PipeTsFileResource resource = this.getResourceMap(pipeName).get(filePath);
            if (resource != null && resource.decreaseReferenceCount()) {
                this.getResourceMap(pipeName).remove(filePath);
            }
        }
        finally {
            this.segmentLock.unlock(hardlinkOrCopiedFile);
        }
        this.decreasePublicReferenceIfExists(hardlinkOrCopiedFile, pipeName);
    }

    private void decreasePublicReferenceIfExists(File file, @Nullable String pipeName) {
        if (Objects.isNull(pipeName)) {
            return;
        }
        this.decreaseFileReference(new File(this.getCommonFilePath(file)), null);
    }

    private String getCommonFilePath(@Nonnull File file) {
        return Objects.isNull(file.getParentFile()) || Objects.isNull(file.getParentFile().getParentFile()) ? file.getPath() : file.getParentFile().getParent() + File.separator + file.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFileReferenceCount(File hardlinkOrCopiedFile, @Nullable String pipeName) {
        this.segmentLock.lock(hardlinkOrCopiedFile);
        try {
            PipeTsFileResource resource = Objects.nonNull(pipeName) ? (PipeTsFileResource)this.hardlinkOrCopiedFileToPipeTsFileResourceMap.computeIfAbsent(pipeName, pipe -> new ConcurrentHashMap()).get(hardlinkOrCopiedFile.getPath()) : (PipeTsFileResource)this.hardlinkOrCopiedFileToTsFilePublicResourceMap.get(this.getCommonFilePath(hardlinkOrCopiedFile));
            int n = resource != null ? resource.getReferenceCount() : 0;
            return n;
        }
        finally {
            this.segmentLock.unlock(hardlinkOrCopiedFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cacheObjectsIfAbsent(File hardlinkOrCopiedTsFile) throws IOException {
        this.segmentLock.lock(hardlinkOrCopiedTsFile);
        try {
            if (hardlinkOrCopiedTsFile.getParentFile() == null || hardlinkOrCopiedTsFile.getParentFile().getParentFile() == null) {
                boolean bl = false;
                return bl;
            }
            PipeTsFilePublicResource resource = this.hardlinkOrCopiedFileToTsFilePublicResourceMap.get(this.getCommonFilePath(hardlinkOrCopiedTsFile));
            boolean bl = resource != null && resource.cacheObjectsIfAbsent(hardlinkOrCopiedTsFile);
            return bl;
        }
        finally {
            this.segmentLock.unlock(hardlinkOrCopiedTsFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<IDeviceID, List<String>> getDeviceMeasurementsMapFromCache(File hardlinkOrCopiedTsFile) throws IOException {
        this.segmentLock.lock(hardlinkOrCopiedTsFile);
        try {
            PipeTsFilePublicResource resource = this.hardlinkOrCopiedFileToTsFilePublicResourceMap.get(this.getCommonFilePath(hardlinkOrCopiedTsFile));
            Map<IDeviceID, List<String>> map = resource == null ? null : resource.tryGetDeviceMeasurementsMap(hardlinkOrCopiedTsFile);
            return map;
        }
        finally {
            this.segmentLock.unlock(hardlinkOrCopiedTsFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<IDeviceID, Boolean> getDeviceIsAlignedMapFromCache(File hardlinkOrCopiedTsFile, boolean cacheOtherMetadata) throws IOException {
        this.segmentLock.lock(hardlinkOrCopiedTsFile);
        try {
            PipeTsFilePublicResource resource = this.hardlinkOrCopiedFileToTsFilePublicResourceMap.get(this.getCommonFilePath(hardlinkOrCopiedTsFile));
            Map<IDeviceID, Boolean> map = resource == null ? null : resource.tryGetDeviceIsAlignedMap(cacheOtherMetadata, hardlinkOrCopiedTsFile);
            return map;
        }
        finally {
            this.segmentLock.unlock(hardlinkOrCopiedTsFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, TSDataType> getMeasurementDataTypeMapFromCache(File hardlinkOrCopiedTsFile) throws IOException {
        this.segmentLock.lock(hardlinkOrCopiedTsFile);
        try {
            PipeTsFilePublicResource resource = this.hardlinkOrCopiedFileToTsFilePublicResourceMap.get(this.getCommonFilePath(hardlinkOrCopiedTsFile));
            Map<String, TSDataType> map = resource == null ? null : resource.tryGetMeasurementDataTypeMap(hardlinkOrCopiedTsFile);
            return map;
        }
        finally {
            this.segmentLock.unlock(hardlinkOrCopiedTsFile);
        }
    }

    public Map<String, ? extends PipeTsFileResource> getResourceMap(@Nullable String pipeName) {
        return Objects.nonNull(pipeName) ? this.hardlinkOrCopiedFileToPipeTsFileResourceMap.computeIfAbsent(pipeName, k -> new ConcurrentHashMap()) : this.hardlinkOrCopiedFileToTsFilePublicResourceMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pinTsFileResource(TsFileResource resource, boolean withMods, @Nullable String pipeName) throws IOException {
        this.increaseFileReference(resource.getTsFile(), true, pipeName);
        if (withMods && resource.getModFile().exists()) {
            ModificationFile modificationFile = resource.getModFile();
            synchronized (modificationFile) {
                this.increaseFileReference(new File(resource.getModFile().getFilePath()), false, pipeName);
            }
        }
    }

    public void unpinTsFileResource(TsFileResource resource, @Nullable String pipeName) throws IOException {
        File pinnedFile = PipeTsFileResourceManager.getHardlinkOrCopiedFileInPipeDir(resource.getTsFile(), pipeName);
        this.decreaseFileReference(pinnedFile, pipeName);
        File modFile = new File(pinnedFile + ".mods");
        if (modFile.exists()) {
            this.decreaseFileReference(modFile, pipeName);
        }
    }

    public int getLinkedTsFileCount(@Nonnull String pipeName) {
        return this.hardlinkOrCopiedFileToPipeTsFileResourceMap.computeIfAbsent(pipeName, pipe -> new ConcurrentHashMap()).size();
    }

    public long getTotalLinkedTsFileSize(@Nonnull String pipeName) {
        return this.hardlinkOrCopiedFileToPipeTsFileResourceMap.computeIfAbsent(pipeName, pipe -> new ConcurrentHashMap()).values().stream().mapToLong(resource -> {
            try {
                return resource.getFileSize();
            }
            catch (Exception e) {
                LOGGER.warn("failed to get file size of linked TsFile {}: ", resource, (Object)e);
                return 0L;
            }
        }).sum();
    }
}

