/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.encoding.decoder;

import java.nio.ByteBuffer;
import org.apache.tsfile.encoding.decoder.GorillaDecoderV2;
import org.apache.tsfile.file.metadata.enums.TSEncoding;

public class IntChimpDecoder
extends GorillaDecoderV2 {
    private static final short[] LEADING_REPRESENTATION = new short[]{0, 8, 12, 16, 18, 20, 22, 24};
    private static final int PREVIOUS_VALUES = 64;
    private static final int PREVIOUS_VALUES_LOG2 = (int)(Math.log(64.0) / Math.log(2.0));
    private static final int CASE_ONE_METADATA_LENGTH = PREVIOUS_VALUES_LOG2 + 8;
    private int storedValue = 0;
    protected int[] storedValues = new int[64];
    protected int current = 0;

    public IntChimpDecoder() {
        this.setType(TSEncoding.CHIMP);
        this.hasNext = true;
        this.firstValueWasRead = false;
        this.storedLeadingZeros = Integer.MAX_VALUE;
        this.storedTrailingZeros = 0;
        this.current = 0;
        this.storedValue = 0;
        this.storedValues = new int[64];
    }

    @Override
    public void reset() {
        super.reset();
        this.current = 0;
        this.storedValue = 0;
        this.storedValues = new int[64];
    }

    @Override
    public final int readInt(ByteBuffer in) {
        int returnValue = this.storedValue;
        if (!this.firstValueWasRead) {
            this.flipByte(in);
            this.storedValues[this.current] = this.storedValue = (int)this.readLong(32, in);
            this.firstValueWasRead = true;
            returnValue = this.storedValue;
        }
        this.cacheNext(in);
        return returnValue;
    }

    protected int cacheNext(ByteBuffer in) {
        this.readNext(in);
        if (this.storedValues[this.current] == Integer.MIN_VALUE) {
            this.hasNext = false;
        }
        return this.storedValues[this.current];
    }

    protected int readNext(ByteBuffer in) {
        byte controlBits = this.readNextNBits(2, in);
        switch (controlBits) {
            case 3: {
                this.storedLeadingZeros = LEADING_REPRESENTATION[(int)this.readLong(3, in)];
                int value = (int)this.readLong(32 - this.storedLeadingZeros, in);
                this.storedValue ^= value;
                this.current = (this.current + 1) % 64;
                this.storedValues[this.current] = this.storedValue;
                return this.storedValue;
            }
            case 2: {
                int value = (int)this.readLong(32 - this.storedLeadingZeros, in);
                this.storedValue ^= value;
                this.current = (this.current + 1) % 64;
                this.storedValues[this.current] = this.storedValue;
                return this.storedValue;
            }
            case 1: {
                int fill = CASE_ONE_METADATA_LENGTH;
                int temp = (int)this.readLong(fill, in);
                int index = temp >>> (fill -= PREVIOUS_VALUES_LOG2) & (1 << PREVIOUS_VALUES_LOG2) - 1;
                this.storedLeadingZeros = LEADING_REPRESENTATION[temp >>> (fill -= 3) & 7];
                int significantBits = temp >>> (fill -= 5) & 0x1F;
                this.storedValue = this.storedValues[index];
                if (significantBits == 0) {
                    significantBits = 32;
                }
                this.storedTrailingZeros = 32 - significantBits - this.storedLeadingZeros;
                int value = (int)this.readLong(32 - this.storedLeadingZeros - this.storedTrailingZeros, in);
                this.storedValue ^= (value <<= this.storedTrailingZeros);
                this.current = (this.current + 1) % 64;
                this.storedValues[this.current] = this.storedValue;
                return this.storedValue;
            }
        }
        int previousIndex = (int)this.readLong(PREVIOUS_VALUES_LOG2, in);
        this.storedValue = this.storedValues[previousIndex];
        this.current = (this.current + 1) % 64;
        this.storedValues[this.current] = this.storedValue;
        return this.storedValue;
    }

    private byte readNextNBits(int n, ByteBuffer in) {
        byte value = 0;
        for (int i = 0; i < n; ++i) {
            value = (byte)(value << 1);
            if (!this.readBit(in)) continue;
            value = (byte)(value | 1);
        }
        return value;
    }
}

