/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.wal.utils;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.commons.exception.IoTDBRuntimeException;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.WALEntry;
import org.apache.iotdb.db.storageengine.rescon.memory.SystemInfo;
import org.apache.iotdb.rpc.TSStatusCode;

public class MemoryControlledWALEntryQueue {
    private final BlockingQueue<WALEntry> queue = new LinkedBlockingQueue<WALEntry>();
    private static final Object nonFullCondition = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WALEntry poll(long timeout, TimeUnit unit) throws InterruptedException {
        WALEntry e = this.queue.poll(timeout, unit);
        if (e != null) {
            SystemInfo.getInstance().updateWalQueueMemoryCost(-this.getElementSize(e));
            Object object = nonFullCondition;
            synchronized (object) {
                nonFullCondition.notifyAll();
            }
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(WALEntry e) throws InterruptedException {
        long elementSize = this.getElementSize(e);
        Object object = nonFullCondition;
        synchronized (object) {
            while (SystemInfo.getInstance().cannotReserveMemoryForWalEntry(elementSize)) {
                if (elementSize > SystemInfo.getInstance().getMemorySizeForWalBufferQueue()) {
                    throw new IoTDBRuntimeException("The element size of WALEntry " + elementSize + " is larger than the total memory size of wal buffer queue " + SystemInfo.getInstance().getMemorySizeForWalBufferQueue(), TSStatusCode.WAL_ENTRY_TOO_LARGE.getStatusCode());
                }
                nonFullCondition.wait();
            }
        }
        this.queue.put(e);
        SystemInfo.getInstance().updateWalQueueMemoryCost(elementSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WALEntry take() throws InterruptedException {
        WALEntry e = this.queue.take();
        SystemInfo.getInstance().updateWalQueueMemoryCost(-this.getElementSize(e));
        Object object = nonFullCondition;
        synchronized (object) {
            nonFullCondition.notifyAll();
        }
        return e;
    }

    public int size() {
        return this.queue.size();
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    private long getElementSize(WALEntry walEntry) {
        return walEntry.getMemorySize();
    }
}

