/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.ProcessOperator;
import org.apache.iotdb.db.utils.datastructure.MergeSortHeap;
import org.apache.iotdb.db.utils.datastructure.MergeSortKey;
import org.apache.iotdb.db.utils.datastructure.SortKey;
import org.apache.iotdb.db.utils.sort.DiskSpiller;
import org.apache.iotdb.db.utils.sort.MemoryReader;
import org.apache.iotdb.db.utils.sort.SortBufferManager;
import org.apache.iotdb.db.utils.sort.SortReader;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.read.common.block.column.TimeColumnBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSortOperator
implements ProcessOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSortOperator.class);
    protected final OperatorContext operatorContext;
    protected final Operator inputOperator;
    protected final TsBlockBuilder tsBlockBuilder;
    private int curRow = -1;
    private List<SortKey> cachedData;
    private final Comparator<SortKey> comparator;
    private long cachedBytes;
    private final DiskSpiller diskSpiller;
    private SortBufferManager sortBufferManager;
    private MergeSortHeap mergeSortHeap;
    private List<SortReader> sortReaders;
    protected boolean[] noMoreData;
    private final int maxReturnSize = TSFileDescriptor.getInstance().getConfig().getMaxTsBlockSizeInBytes();
    protected long prepareUntilReadyCost = 0L;
    protected long dataSize = 0L;
    private long sortCost = 0L;

    AbstractSortOperator(OperatorContext operatorContext, Operator inputOperator, List<TSDataType> dataTypes, DiskSpiller diskSpiller, Comparator<SortKey> comparator) {
        this.operatorContext = operatorContext;
        this.inputOperator = inputOperator;
        this.tsBlockBuilder = new TsBlockBuilder(dataTypes);
        this.cachedData = new ArrayList<SortKey>();
        this.comparator = comparator;
        this.cachedBytes = 0L;
        this.diskSpiller = diskSpiller;
        this.sortBufferManager = new SortBufferManager(TSFileDescriptor.getInstance().getConfig().getMaxTsBlockSizeInBytes(), IoTDBDescriptor.getInstance().getConfig().getSortBufferSize());
    }

    protected void buildResult() throws IoTDBException {
        if (this.diskSpiller.hasSpilledData()) {
            try {
                this.prepareSortReaders();
                this.mergeSort();
            }
            catch (Exception e) {
                this.clear();
                throw e;
            }
        } else {
            if (this.curRow == -1) {
                long startTime = System.nanoTime();
                this.cachedData.sort(this.comparator);
                this.sortCost += System.nanoTime() - startTime;
                this.curRow = 0;
            }
            this.buildTsBlockInMemory();
        }
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return this.inputOperator.isBlocked();
    }

    private void recordMetrics() {
        this.operatorContext.recordSpecifiedInfo("prepareCost/ns", Long.toString(this.prepareUntilReadyCost));
        this.operatorContext.recordSpecifiedInfo("sortedDataSize", Long.toString(this.dataSize));
        this.operatorContext.recordSpecifiedInfo("sortCost/ns", Long.toString(this.sortCost));
        int spilledFileSize = this.diskSpiller.getFileSize();
        if (spilledFileSize > 0) {
            this.operatorContext.recordSpecifiedInfo("merge sort branch", Integer.toString(this.diskSpiller.getFileSize() + 1));
        }
    }

    private void prepareSortReaders() throws IoTDBException {
        if (this.sortReaders != null) {
            return;
        }
        this.sortReaders = new ArrayList<SortReader>();
        if (this.cachedBytes != 0L) {
            this.cachedData.sort(this.comparator);
            if (this.sortBufferManager.allocate(this.cachedBytes)) {
                this.sortReaders.add(new MemoryReader(this.cachedData.stream().map(MergeSortKey::new).collect(Collectors.toList())));
            } else {
                this.sortBufferManager.allocateOneSortBranch();
                this.diskSpiller.spillSortedData(this.cachedData);
                this.cachedData = null;
            }
        }
        this.sortReaders.addAll(this.diskSpiller.getReaders(this.sortBufferManager));
        this.noMoreData = new boolean[this.sortReaders.size()];
    }

    protected void cacheTsBlock(TsBlock tsBlock) throws IoTDBException {
        long bytesSize = tsBlock.getSizeInBytes();
        if (bytesSize + this.cachedBytes < this.sortBufferManager.getSortBufferSize()) {
            this.cachedBytes += bytesSize;
            for (int i = 0; i < tsBlock.getPositionCount(); ++i) {
                this.cachedData.add(new MergeSortKey(tsBlock, i));
            }
        } else {
            this.cachedData.sort(this.comparator);
            this.spill();
            this.cachedData.clear();
            this.cachedBytes = bytesSize;
            for (int i = 0; i < tsBlock.getPositionCount(); ++i) {
                this.cachedData.add(new MergeSortKey(tsBlock, i));
            }
        }
    }

    private void spill() throws IoTDBException {
        this.sortBufferManager.allocateOneSortBranch();
        this.diskSpiller.spillSortedData(this.cachedData);
    }

    private void buildTsBlockInMemory() {
        TimeColumnBuilder timeColumnBuilder = this.tsBlockBuilder.getTimeColumnBuilder();
        ColumnBuilder[] valueColumnBuilders = this.tsBlockBuilder.getValueColumnBuilders();
        for (int i = this.curRow; i < this.cachedData.size(); ++i) {
            SortKey sortKey = this.cachedData.get(i);
            TsBlock tsBlock = sortKey.tsBlock;
            this.appendTime(timeColumnBuilder, tsBlock.getTimeByIndex(sortKey.rowIndex));
            for (int j = 0; j < valueColumnBuilders.length; ++j) {
                if (tsBlock.getColumn(j).isNull(sortKey.rowIndex)) {
                    valueColumnBuilders[j].appendNull();
                    continue;
                }
                valueColumnBuilders[j].write(tsBlock.getColumn(j), sortKey.rowIndex);
            }
            this.tsBlockBuilder.declarePosition();
            ++this.curRow;
            if (this.tsBlockBuilder.isFull()) break;
        }
    }

    private void mergeSort() throws IoTDBException {
        this.initMergeSortHeap();
        long startTime = System.nanoTime();
        long maxRuntime = this.operatorContext.getMaxRunTime().roundTo(TimeUnit.NANOSECONDS);
        TimeColumnBuilder timeBuilder = this.tsBlockBuilder.getTimeColumnBuilder();
        ColumnBuilder[] valueColumnBuilders = this.tsBlockBuilder.getValueColumnBuilders();
        while (!this.mergeSortHeap.isEmpty()) {
            MergeSortKey mergeSortKey = this.mergeSortHeap.poll();
            TsBlock targetBlock = mergeSortKey.tsBlock;
            this.appendTime(timeBuilder, targetBlock.getTimeByIndex(mergeSortKey.rowIndex));
            for (int i = 0; i < valueColumnBuilders.length; ++i) {
                if (targetBlock.getColumn(i).isNull(mergeSortKey.rowIndex)) {
                    valueColumnBuilders[i].appendNull();
                    continue;
                }
                valueColumnBuilders[i].write(targetBlock.getColumn(i), mergeSortKey.rowIndex);
            }
            this.tsBlockBuilder.declarePosition();
            int readerIndex = mergeSortKey.inputChannelIndex;
            mergeSortKey = this.readNextMergeSortKey(readerIndex);
            if (mergeSortKey != null) {
                this.mergeSortHeap.push(mergeSortKey);
            } else {
                this.noMoreData[readerIndex] = true;
                this.sortBufferManager.releaseOneSortBranch();
            }
            if (System.nanoTime() - startTime <= maxRuntime && !this.tsBlockBuilder.isFull()) continue;
            break;
        }
        this.sortCost += System.nanoTime() - startTime;
    }

    protected abstract void appendTime(TimeColumnBuilder var1, long var2);

    private void initMergeSortHeap() throws IoTDBException {
        if (this.mergeSortHeap == null) {
            this.mergeSortHeap = new MergeSortHeap(this.sortReaders.size(), this.comparator);
            for (int i = 0; i < this.sortReaders.size(); ++i) {
                SortReader sortReader = this.sortReaders.get(i);
                if (sortReader.hasNext()) {
                    MergeSortKey mergeSortKey = sortReader.next();
                    mergeSortKey.inputChannelIndex = i;
                    this.mergeSortHeap.push(mergeSortKey);
                    continue;
                }
                this.noMoreData[i] = true;
                this.sortBufferManager.releaseOneSortBranch();
            }
        }
    }

    private MergeSortKey readNextMergeSortKey(int readerIndex) throws IoTDBException {
        SortReader sortReader = this.sortReaders.get(readerIndex);
        if (sortReader.hasNext()) {
            MergeSortKey mergeSortKey = sortReader.next();
            mergeSortKey.inputChannelIndex = readerIndex;
            return mergeSortKey;
        }
        return null;
    }

    private boolean hasMoreData() {
        if (this.noMoreData == null) {
            return true;
        }
        for (boolean noMore : this.noMoreData) {
            if (noMore) continue;
            return true;
        }
        return false;
    }

    public void clear() {
        if (!this.diskSpiller.hasSpilledData()) {
            return;
        }
        try {
            if (this.sortReaders != null) {
                for (SortReader sortReader : this.sortReaders) {
                    sortReader.close();
                }
            }
            this.sortReaders = null;
            this.diskSpiller.reset();
        }
        catch (Exception e) {
            LOGGER.warn("Fail to close fileChannel", (Throwable)e);
        }
    }

    @Override
    public boolean hasNext() throws Exception {
        return this.inputOperator.hasNextWithTimer() || this.hasMoreSortedData();
    }

    protected boolean hasMoreSortedData() {
        return !this.diskSpiller.hasSpilledData() && (this.curRow == -1 && !this.cachedData.isEmpty() || this.curRow != -1 && this.curRow != this.cachedData.size()) || this.diskSpiller.hasSpilledData() && this.hasMoreData();
    }

    @Override
    public void close() throws Exception {
        this.recordMetrics();
        this.cachedData = null;
        this.clear();
        this.inputOperator.close();
    }

    @Override
    public boolean isFinished() throws Exception {
        return !this.hasNextWithTimer();
    }

    @Override
    public long calculateMaxPeekMemory() {
        return this.inputOperator.calculateMaxPeekMemoryWithCounter() + this.inputOperator.calculateRetainedSizeAfterCallingNext() + this.sortBufferManager.getSortBufferSize();
    }

    @Override
    public long calculateMaxReturnSize() {
        return this.maxReturnSize;
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return this.inputOperator.calculateRetainedSizeAfterCallingNext() + this.sortBufferManager.getSortBufferSize();
    }

    protected void resetSortRelatedResource() {
        this.curRow = -1;
        this.cachedData = new ArrayList<SortKey>();
        this.cachedBytes = 0L;
        this.clear();
        this.sortBufferManager = new SortBufferManager(this.sortBufferManager.getMaxTsBlockSizeInBytes(), this.sortBufferManager.getSortBufferSize());
        if (this.mergeSortHeap != null && !this.mergeSortHeap.isEmpty()) {
            throw new IllegalStateException("mergeSortHeap should be empty!");
        }
        this.mergeSortHeap = null;
        this.noMoreData = null;
    }
}

