/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.datastructure.row;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.queryengine.transformation.datastructure.SerializableList;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.column.TsBlockSerde;
import org.apache.tsfile.utils.PublicBAOS;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.apache.tsfile.write.UnSupportedDataTypeException;

public class SerializableRowList
implements SerializableList {
    private final SerializableList.SerializationRecorder serializationRecorder;
    private final TsBlockSerde serde;
    private final TSDataType[] dataTypes;
    private final int valueColumnCount;
    private List<Column[]> blocks;
    private final List<Integer> blockSizes;
    private int skipPrefixNullCount;
    private int prefixNullCount;

    public static SerializableRowList construct(String queryId, TSDataType[] dataTypes) {
        SerializableList.SerializationRecorder recorder = new SerializableList.SerializationRecorder(queryId);
        return new SerializableRowList(recorder, dataTypes);
    }

    private SerializableRowList(SerializableList.SerializationRecorder serializationRecorder, TSDataType[] dataTypes) {
        this.serializationRecorder = serializationRecorder;
        this.dataTypes = dataTypes;
        this.serde = new TsBlockSerde();
        this.blockSizes = new ArrayList<Integer>();
        this.valueColumnCount = dataTypes.length;
        this.prefixNullCount = 0;
        this.skipPrefixNullCount = 0;
        this.init();
    }

    protected static int calculateCapacity(TSDataType[] dataTypes, float memoryLimitInMB, int byteArrayLengthForMemoryControl) throws QueryProcessException {
        int rowLength = 8;
        block8: for (TSDataType dataType : dataTypes) {
            switch (dataType) {
                case INT32: 
                case DATE: {
                    rowLength += 4;
                    continue block8;
                }
                case INT64: 
                case TIMESTAMP: {
                    rowLength += 8;
                    continue block8;
                }
                case FLOAT: {
                    rowLength += 4;
                    continue block8;
                }
                case DOUBLE: {
                    rowLength += 8;
                    continue block8;
                }
                case BOOLEAN: {
                    ++rowLength;
                    continue block8;
                }
                case TEXT: 
                case BLOB: 
                case STRING: {
                    rowLength += 20 + byteArrayLengthForMemoryControl;
                    continue block8;
                }
                default: {
                    throw new UnSupportedDataTypeException(dataType.toString());
                }
            }
        }
        int capacity = (int)(memoryLimitInMB * 1048576.0f / 2.0f / (float)(rowLength = (int)((float)rowLength + 0.125f)));
        if (capacity <= 0) {
            throw new QueryProcessException("Memory is not enough for current query.");
        }
        return capacity;
    }

    public int size() {
        return this.prefixNullCount + this.skipPrefixNullCount;
    }

    public int getBlockCount() {
        int additional_null_block = this.prefixNullCount == 0 ? 0 : 1;
        return this.blockSizes.size() + additional_null_block;
    }

    public int getBlockSize(int index) {
        if (this.prefixNullCount != 0) {
            return index == 0 ? this.prefixNullCount : this.blockSizes.get(index - 1);
        }
        return this.blockSizes.get(index);
    }

    public long getTime(int index) {
        assert (index >= this.prefixNullCount);
        return this.getTimeSkipPrefixNulls(index - this.prefixNullCount);
    }

    private long getTimeSkipPrefixNulls(int index) {
        assert (index < this.skipPrefixNullCount);
        int total = 0;
        long time = -1L;
        for (Column[] block : this.blocks) {
            int length = block[0].getPositionCount();
            if (index < total + length) {
                int offset = index - total;
                time = block[this.valueColumnCount].getLong(offset);
                break;
            }
            total += length;
        }
        return time;
    }

    public Object[] getRow(int index) {
        if (index < this.prefixNullCount) {
            return null;
        }
        return this.getRowSkipPrefixNulls(index - this.prefixNullCount);
    }

    private Object[] getRowSkipPrefixNulls(int index) {
        assert (index < this.skipPrefixNullCount);
        Object[] row = new Object[this.valueColumnCount + 1];
        int total = 0;
        for (Column[] block : this.blocks) {
            int length = block[0].getPositionCount();
            if (index < total + length) {
                int offset = index - total;
                block9: for (int i = 0; i < block.length - 1; ++i) {
                    switch (this.dataTypes[i]) {
                        case INT32: 
                        case DATE: {
                            row[i] = block[i].getInt(offset);
                            continue block9;
                        }
                        case INT64: 
                        case TIMESTAMP: {
                            row[i] = block[i].getLong(offset);
                            continue block9;
                        }
                        case FLOAT: {
                            row[i] = Float.valueOf(block[i].getFloat(offset));
                            continue block9;
                        }
                        case DOUBLE: {
                            row[i] = block[i].getDouble(offset);
                            continue block9;
                        }
                        case BOOLEAN: {
                            row[i] = block[i].getBoolean(offset);
                            continue block9;
                        }
                        case TEXT: 
                        case BLOB: 
                        case STRING: {
                            row[i] = block[i].getBinary(offset);
                            continue block9;
                        }
                        default: {
                            throw new UnSupportedDataTypeException(this.dataTypes[i].toString());
                        }
                    }
                }
                row[block.length - 1] = block[block.length - 1].getLong(offset);
                break;
            }
            total += length;
        }
        return row;
    }

    public void putColumns(Column[] columns) {
        this.blocks.add(columns);
        int size = columns[0].getPositionCount();
        this.blockSizes.add(size);
        this.skipPrefixNullCount += size;
    }

    public void putNulls(int count) {
        this.prefixNullCount += count;
    }

    public Column[] getColumns(int index) {
        if (this.prefixNullCount != 0) {
            --index;
        }
        assert (index >= 0);
        return this.blocks.get(index);
    }

    public int getColumnIndex(int index) {
        if (index < this.prefixNullCount) {
            return 0;
        }
        int addition = this.prefixNullCount == 0 ? 0 : 1;
        return addition + this.getColumnIndexSkipPrefixNulls(index - this.prefixNullCount);
    }

    private int getColumnIndexSkipPrefixNulls(int index) {
        assert (index < this.skipPrefixNullCount);
        int ret = -1;
        int total = 0;
        for (int i = 0; i < this.blockSizes.size(); ++i) {
            int length = this.blockSizes.get(i);
            if (index < total + length) {
                ret = i;
                break;
            }
            total += length;
        }
        return ret;
    }

    public int getRowOffsetInColumns(int index) {
        assert (index >= this.prefixNullCount);
        return this.getRowOffsetInColumnsSkipPrefixNulls(index - this.prefixNullCount);
    }

    private int getRowOffsetInColumnsSkipPrefixNulls(int index) {
        assert (index < this.skipPrefixNullCount);
        int ret = -1;
        int total = 0;
        for (int length : this.blockSizes) {
            if (index < total + length) {
                ret = index - total;
                break;
            }
            total += length;
        }
        return ret;
    }

    public int getLastRowIndex(int blockIndex) {
        int total = this.prefixNullCount;
        for (int i = 0; i <= blockIndex; ++i) {
            total += this.blockSizes.get(i).intValue();
        }
        return total;
    }

    @Override
    public void release() {
        this.blocks = null;
    }

    @Override
    public void init() {
        this.blocks = new ArrayList<Column[]>();
    }

    @Override
    public void serialize(PublicBAOS outputStream) throws IOException {
        int bufferSize = 0;
        bufferSize += ReadWriteIOUtils.write((int)this.blocks.size(), (OutputStream)outputStream);
        for (Column[] block : this.blocks) {
            Column timeColumn = block[block.length - 1];
            Column[] valueColumns = new Column[block.length - 1];
            System.arraycopy(block, 0, valueColumns, 0, block.length - 1);
            TsBlock tsBlock = new TsBlock(timeColumn, valueColumns);
            ByteBuffer buffer = this.serde.serialize(tsBlock);
            byte[] byteArray = buffer.array();
            outputStream.write(byteArray);
            bufferSize += byteArray.length;
        }
        this.serializationRecorder.setSerializedByteLength(bufferSize);
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        int blockCount = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        this.blocks = new ArrayList<Column[]>(blockCount);
        for (int i = 0; i < blockCount; ++i) {
            TsBlock tsBlock = this.serde.deserialize(byteBuffer);
            this.blocks.add(tsBlock.getAllColumns());
        }
    }

    @Override
    public SerializableList.SerializationRecorder getSerializationRecorder() {
        return this.serializationRecorder;
    }
}

