/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.storage;

import java.io.IOException;
import java.io.InputStream;
import org.apache.james.mime4j.storage.Storage;

public class MultiReferenceStorage
implements Storage {
    private final Storage storage;
    private int referenceCounter;

    public MultiReferenceStorage(Storage storage) {
        if (storage == null) {
            throw new IllegalArgumentException();
        }
        this.storage = storage;
        this.referenceCounter = 1;
    }

    public void addReference() {
        this.incrementCounter();
    }

    @Override
    public void delete() {
        if (this.decrementCounter()) {
            this.storage.delete();
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.storage.getInputStream();
    }

    private synchronized void incrementCounter() {
        if (this.referenceCounter == 0) {
            throw new IllegalStateException("storage has been deleted");
        }
        ++this.referenceCounter;
    }

    private synchronized boolean decrementCounter() {
        if (this.referenceCounter == 0) {
            throw new IllegalStateException("storage has been deleted");
        }
        return --this.referenceCounter == 0;
    }
}

