/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mdn;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Properties;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.james.javax.MimeMultipartReport;
import org.apache.james.mdn.MDNReport;
import org.apache.james.mime4j.Charsets;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.mime4j.dom.Multipart;
import org.apache.james.mime4j.message.BasicBodyFactory;
import org.apache.james.mime4j.message.BodyPartBuilder;
import org.apache.james.mime4j.message.MultipartBuilder;
import org.apache.james.mime4j.stream.NameValuePair;

public class MDN {
    private static final NameValuePair UTF_8_CHARSET = new NameValuePair("charset", Charsets.UTF_8.name());
    public static final String DISPOSITION_CONTENT_TYPE = "message/disposition-notification";
    public static final String REPORT_SUB_TYPE = "report";
    public static final String DISPOSITION_NOTIFICATION_REPORT_TYPE = "disposition-notification";
    private final String humanReadableText;
    private final MDNReport report;

    public static Builder builder() {
        return new Builder();
    }

    private MDN(String humanReadableText, MDNReport report) {
        this.humanReadableText = humanReadableText;
        this.report = report;
    }

    public String getHumanReadableText() {
        return this.humanReadableText;
    }

    public MDNReport getReport() {
        return this.report;
    }

    public MimeMultipart asMultipart() throws MessagingException {
        MimeMultipartReport multipart = new MimeMultipartReport();
        multipart.setSubType(REPORT_SUB_TYPE);
        multipart.setReportType(DISPOSITION_NOTIFICATION_REPORT_TYPE);
        multipart.addBodyPart(this.computeHumanReadablePart());
        multipart.addBodyPart(this.computeReportPart());
        return multipart;
    }

    public MimeMessage asMimeMessage() throws MessagingException {
        MimeMessage mimeMessage = new MimeMessage(Session.getDefaultInstance(new Properties()));
        mimeMessage.setContent(this.asMultipart());
        return mimeMessage;
    }

    public BodyPart computeHumanReadablePart() throws MessagingException {
        MimeBodyPart textPart = new MimeBodyPart();
        textPart.setText(this.humanReadableText, StandardCharsets.UTF_8.displayName());
        textPart.setDisposition("inline");
        return textPart;
    }

    public BodyPart computeReportPart() throws MessagingException {
        MimeBodyPart mdnPart = new MimeBodyPart();
        mdnPart.setContent(this.report.formattedValue(), DISPOSITION_CONTENT_TYPE);
        return mdnPart;
    }

    public Message.Builder asMime4JMessageBuilder() throws IOException {
        Message.Builder messageBuilder = Message.Builder.of();
        messageBuilder.setBody(this.asMime4JMultipart());
        return messageBuilder;
    }

    private Multipart asMime4JMultipart() throws IOException {
        MultipartBuilder builder = MultipartBuilder.create(REPORT_SUB_TYPE);
        builder.addContentTypeParameter(new NameValuePair("report-type", DISPOSITION_NOTIFICATION_REPORT_TYPE));
        builder.addBodyPart(BodyPartBuilder.create().use(new BasicBodyFactory()).setBody(this.humanReadableText, Charsets.UTF_8).setContentType("text/plain", UTF_8_CHARSET));
        builder.addBodyPart(BodyPartBuilder.create().use(new BasicBodyFactory()).setBody(this.report.formattedValue(), Charsets.UTF_8).setContentType(DISPOSITION_CONTENT_TYPE, UTF_8_CHARSET));
        return builder.build();
    }

    public final boolean equals(Object o) {
        if (o instanceof MDN) {
            MDN mdn = (MDN)o;
            return Objects.equals(this.humanReadableText, mdn.humanReadableText) && Objects.equals(this.report, mdn.report);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.humanReadableText, this.report);
    }

    public static class Builder {
        private String humanReadableText;
        private MDNReport report;

        public Builder report(MDNReport report) {
            Preconditions.checkNotNull(report);
            this.report = report;
            return this;
        }

        public Builder humanReadableText(String humanReadableText) {
            Preconditions.checkNotNull(humanReadableText);
            this.humanReadableText = humanReadableText;
            return this;
        }

        public MDN build() {
            Preconditions.checkState(this.report != null);
            Preconditions.checkState(this.humanReadableText != null);
            Preconditions.checkState(!this.humanReadableText.trim().isEmpty());
            return new MDN(this.humanReadableText, this.report);
        }
    }
}

