/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.transform;

import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.parboiled.common.Preconditions;
import org.parboiled.common.StringUtils;
import org.parboiled.transform.ParserClassNode;
import org.parboiled.transform.RuleMethod;
import org.parboiled.transform.RuleMethodProcessor;
import org.parboiled.transform.Types;

class LabellingGenerator
implements RuleMethodProcessor {
    LabellingGenerator() {
    }

    @Override
    public boolean appliesTo(ParserClassNode parserClassNode, RuleMethod ruleMethod) {
        Preconditions.checkArgNotNull(parserClassNode, "classNode");
        Preconditions.checkArgNotNull(ruleMethod, "method");
        return !ruleMethod.hasDontLabelAnnotation();
    }

    @Override
    public void process(ParserClassNode parserClassNode, RuleMethod ruleMethod) throws Exception {
        Preconditions.checkArgNotNull(parserClassNode, "classNode");
        Preconditions.checkArgNotNull(ruleMethod, "method");
        Preconditions.checkState(!ruleMethod.isSuperMethod());
        InsnList insnList = ruleMethod.instructions;
        AbstractInsnNode abstractInsnNode = insnList.getLast();
        while (abstractInsnNode.getOpcode() != 176) {
            abstractInsnNode = abstractInsnNode.getPrevious();
        }
        LabelNode labelNode = new LabelNode();
        insnList.insertBefore(abstractInsnNode, new InsnNode(89));
        insnList.insertBefore(abstractInsnNode, new JumpInsnNode(198, labelNode));
        insnList.insertBefore(abstractInsnNode, new LdcInsnNode(this.getLabelText(ruleMethod)));
        insnList.insertBefore(abstractInsnNode, new MethodInsnNode(185, Types.RULE.getInternalName(), "label", "(Ljava/lang/String;)" + Types.RULE_DESC, true));
        insnList.insertBefore(abstractInsnNode, labelNode);
    }

    public String getLabelText(RuleMethod ruleMethod) {
        if (ruleMethod.visibleAnnotations != null) {
            for (Object e : ruleMethod.visibleAnnotations) {
                AnnotationNode annotationNode = (AnnotationNode)e;
                if (!annotationNode.desc.equals(Types.LABEL_DESC) || annotationNode.values == null) continue;
                Preconditions.checkState("value".equals(annotationNode.values.get(0)));
                String string = (String)annotationNode.values.get(1);
                return StringUtils.isEmpty(string) ? ruleMethod.name : string;
            }
        }
        return ruleMethod.name;
    }
}

