/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.demos;

import java.io.Closeable;
import java.io.FileOutputStream;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.jgroups.util.Util;

public final class KeyStoreGenerator {
    static String symAlg = "AES";
    static int keySize = 128;
    static String keyStoreName = "defaultStore.keystore";
    static String storePass = "changeit";
    static String alias = "myKey";

    private KeyStoreGenerator() {
        throw new InstantiationError("Must not instantiate this class");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        int i = 0;
        String arg = null;
        while (i < args.length && args[i].startsWith("-")) {
            arg = args[i++];
            System.out.println("Found arg of " + arg);
            if (arg.equalsIgnoreCase("--alg")) {
                if (i < args.length) {
                    symAlg = args[i++];
                    continue;
                }
                System.out.println("No Algorithm supplied using default of " + symAlg);
                continue;
            }
            if (arg.equalsIgnoreCase("--size")) {
                if (i < args.length) {
                    keySize = Integer.parseInt(args[i++]);
                    continue;
                }
                System.out.println("No Size supplied using default of " + keySize);
                continue;
            }
            if (arg.equalsIgnoreCase("--storeName")) {
                if (i < args.length) {
                    keyStoreName = args[i++];
                    continue;
                }
                System.out.println("No keystore supplied using default of " + keyStoreName);
                continue;
            }
            if (arg.equalsIgnoreCase("--storePass")) {
                if (i < args.length) {
                    storePass = args[i++];
                    continue;
                }
                System.out.println("No password supplied using default of " + storePass);
                continue;
            }
            if (!arg.equalsIgnoreCase("--alias")) continue;
            if (i < args.length) {
                alias = args[i++];
                continue;
            }
            System.out.println("No alias supplied using default of " + alias);
        }
        System.out.println("Creating file '" + keyStoreName + "' using Algorithm '" + symAlg + "' size '" + keySize + "'");
        FileOutputStream stream = null;
        try {
            stream = new FileOutputStream(keyStoreName);
            SecretKey key = KeyStoreGenerator.initSymKey();
            KeyStore store = KeyStore.getInstance("JCEKS");
            store.load(null, null);
            store.setKeyEntry(alias, key, storePass.toCharArray(), null);
            store.store(stream, storePass.toCharArray());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                Util.close((Closeable)stream);
            }
            catch (Exception e) {}
        }
        System.out.println("Finished keystore creation");
    }

    public static SecretKey initSymKey() throws Exception {
        KeyGenerator keyGen = KeyGenerator.getInstance(KeyStoreGenerator.getAlgorithm(symAlg));
        keyGen.init(keySize);
        return keyGen.generateKey();
    }

    public static SecretKey createSecretKey() throws Exception {
        return KeyStoreGenerator.createSecretKey(symAlg, keySize);
    }

    public static SecretKey createSecretKey(String sym_alg, int key_size) throws NoSuchAlgorithmException {
        KeyGenerator keyGen = KeyGenerator.getInstance(sym_alg);
        keyGen.init(key_size);
        return keyGen.generateKey();
    }

    private static String getAlgorithm(String s) {
        int index = s.indexOf("/");
        if (index == -1) {
            return s;
        }
        return s.substring(0, index);
    }
}

