/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.monitors;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.ReadOnlyEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.ActiveOperationsMonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.BackendMonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.ClientConnectionMonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.ConnectionHandlerMonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.DiskSpaceUsageMonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.EntryCacheMonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.FIFOEntryCacheMonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.GaugeMonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.GeneralMonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.GroupCacheMonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.HostSystemRecentCPUAndMemoryMonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.IndexMonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.IndicatorGaugeMonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.JEEnvironmentMonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.LDAPExternalServerMonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.LDAPStatisticsMonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.LoadBalancingAlgorithmMonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.MemoryUsageMonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorAttribute;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorMessages;
import com.unboundid.ldap.sdk.unboundidds.monitors.NumericGaugeMonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.PerApplicationProcessingTimeHistogramMonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.ProcessingTimeHistogramMonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.ReplicaMonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.ReplicationServerMonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.ReplicationSummaryMonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.ResultCodeMonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.StackTraceMonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.SystemInfoMonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.TraditionalWorkQueueMonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.UnboundIDWorkQueueMonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.VersionMonitorEntry;
import com.unboundid.util.Debug;
import com.unboundid.util.DebugType;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@NotExtensible
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public class MonitorEntry
implements Serializable {
    @NotNull
    static final String GENERIC_MONITOR_OC = "ds-monitor-entry";
    @NotNull
    static final String MONITOR_BASE_DN = "cn=monitor";
    @NotNull
    private static final String ATTR_MONITOR_NAME = "cn";
    private static final long serialVersionUID = -8889119758772055683L;
    @NotNull
    private final ReadOnlyEntry entry;
    @NotNull
    private final String monitorClass;
    @Nullable
    private final String monitorName;

    public MonitorEntry(@NotNull Entry entry) {
        Validator.ensureNotNull(entry);
        this.entry = new ReadOnlyEntry(entry);
        this.monitorClass = MonitorEntry.getMonitorClass(entry);
        this.monitorName = this.getString(ATTR_MONITOR_NAME);
    }

    @NotNull
    public final String getDN() {
        return this.entry.getDN();
    }

    @NotNull
    public final ReadOnlyEntry getEntry() {
        return this.entry;
    }

    @NotNull
    public final String getMonitorClass() {
        return this.monitorClass;
    }

    @Nullable
    public final String getMonitorName() {
        return this.monitorName;
    }

    @NotNull
    public String getMonitorDisplayName() {
        return MonitorMessages.INFO_GENERIC_MONITOR_DISPNAME.get();
    }

    @NotNull
    public String getMonitorDescription() {
        return MonitorMessages.INFO_GENERIC_MONITOR_DESC.get();
    }

    @NotNull
    public Map<String, MonitorAttribute> getMonitorAttributes() {
        LinkedHashMap<String, MonitorAttribute> attrs = new LinkedHashMap<String, MonitorAttribute>(StaticUtils.computeMapCapacity(20));
        for (Attribute a : this.entry.getAttributes()) {
            String lowerName = StaticUtils.toLowerCase(a.getName());
            if (lowerName.equals(ATTR_MONITOR_NAME) || lowerName.equals("objectclass")) continue;
            attrs.put(lowerName, new MonitorAttribute(lowerName, a.getName(), "", a.getValues()));
        }
        return Collections.unmodifiableMap(attrs);
    }

    @NotNull
    public static MonitorEntry decode(@NotNull Entry entry) {
        String monitorClass = MonitorEntry.getMonitorClass(entry);
        if (monitorClass.equalsIgnoreCase("ds-active-operations-monitor-entry")) {
            return new ActiveOperationsMonitorEntry(entry);
        }
        if (monitorClass.equalsIgnoreCase("ds-backend-monitor-entry")) {
            return new BackendMonitorEntry(entry);
        }
        if (monitorClass.equalsIgnoreCase("ds-client-connection-monitor-entry")) {
            return new ClientConnectionMonitorEntry(entry);
        }
        if (monitorClass.equalsIgnoreCase("ds-connectionhandler-monitor-entry")) {
            return new ConnectionHandlerMonitorEntry(entry);
        }
        if (monitorClass.equalsIgnoreCase("ds-disk-space-usage-monitor-entry")) {
            return new DiskSpaceUsageMonitorEntry(entry);
        }
        if (monitorClass.equalsIgnoreCase("ds-entry-cache-monitor-entry")) {
            return new EntryCacheMonitorEntry(entry);
        }
        if (monitorClass.equalsIgnoreCase("ds-fifo-entry-cache-monitor-entry")) {
            return new FIFOEntryCacheMonitorEntry(entry);
        }
        if (monitorClass.equalsIgnoreCase("ds-gauge-monitor-entry")) {
            return new GaugeMonitorEntry(entry);
        }
        if (monitorClass.equalsIgnoreCase("ds-general-monitor-entry")) {
            return new GeneralMonitorEntry(entry);
        }
        if (monitorClass.equalsIgnoreCase("ds-group-cache-monitor-entry")) {
            return new GroupCacheMonitorEntry(entry);
        }
        if (monitorClass.equalsIgnoreCase("ds-host-system-cpu-memory-monitor-entry")) {
            return new HostSystemRecentCPUAndMemoryMonitorEntry(entry);
        }
        if (monitorClass.equalsIgnoreCase("ds-index-monitor-entry")) {
            return new IndexMonitorEntry(entry);
        }
        if (monitorClass.equalsIgnoreCase("ds-indicator-gauge-monitor-entry")) {
            return new IndicatorGaugeMonitorEntry(entry);
        }
        if (monitorClass.equalsIgnoreCase("ds-je-environment-monitor-entry")) {
            return new JEEnvironmentMonitorEntry(entry);
        }
        if (monitorClass.equalsIgnoreCase("ds-ldap-external-server-monitor-entry")) {
            return new LDAPExternalServerMonitorEntry(entry);
        }
        if (monitorClass.equalsIgnoreCase("ds-ldap-statistics-monitor-entry")) {
            return new LDAPStatisticsMonitorEntry(entry);
        }
        if (monitorClass.equalsIgnoreCase("ds-load-balancing-algorithm-monitor-entry")) {
            return new LoadBalancingAlgorithmMonitorEntry(entry);
        }
        if (monitorClass.equalsIgnoreCase("ds-memory-usage-monitor-entry")) {
            return new MemoryUsageMonitorEntry(entry);
        }
        if (monitorClass.equalsIgnoreCase("ds-numeric-gauge-monitor-entry")) {
            return new NumericGaugeMonitorEntry(entry);
        }
        if (monitorClass.equalsIgnoreCase("ds-per-application-processing-time-histogram-monitor-entry")) {
            return new PerApplicationProcessingTimeHistogramMonitorEntry(entry);
        }
        if (monitorClass.equalsIgnoreCase("ds-processing-time-histogram-monitor-entry")) {
            return new ProcessingTimeHistogramMonitorEntry(entry);
        }
        if (monitorClass.equalsIgnoreCase("ds-replica-monitor-entry")) {
            return new ReplicaMonitorEntry(entry);
        }
        if (monitorClass.equalsIgnoreCase("ds-replication-server-monitor-entry")) {
            return new ReplicationServerMonitorEntry(entry);
        }
        if (monitorClass.equalsIgnoreCase("ds-replication-server-summary-monitor-entry")) {
            return new ReplicationSummaryMonitorEntry(entry);
        }
        if (monitorClass.equalsIgnoreCase("ds-ldap-result-codes-monitor-entry")) {
            return new ResultCodeMonitorEntry(entry);
        }
        if (monitorClass.equalsIgnoreCase("ds-stack-trace-monitor-entry")) {
            return new StackTraceMonitorEntry(entry);
        }
        if (monitorClass.equalsIgnoreCase("ds-system-info-monitor-entry")) {
            return new SystemInfoMonitorEntry(entry);
        }
        if (monitorClass.equalsIgnoreCase("ds-traditional-work-queue-monitor-entry")) {
            return new TraditionalWorkQueueMonitorEntry(entry);
        }
        if (monitorClass.equalsIgnoreCase("ds-unboundid-work-queue-monitor-entry")) {
            return new UnboundIDWorkQueueMonitorEntry(entry);
        }
        if (monitorClass.equalsIgnoreCase("ds-version-monitor-entry")) {
            return new VersionMonitorEntry(entry);
        }
        return new MonitorEntry(entry);
    }

    @NotNull
    private static String getMonitorClass(@NotNull Entry entry) {
        String[] ocNames;
        String monitorOC = null;
        for (String oc : ocNames = entry.getObjectClassValues()) {
            if (oc.equalsIgnoreCase("top") || oc.equalsIgnoreCase("extensibleObject") || oc.equalsIgnoreCase(GENERIC_MONITOR_OC)) continue;
            if (oc.equalsIgnoreCase("ds-numeric-gauge-monitor-entry") || oc.equalsIgnoreCase("ds-indicator-gauge-monitor-entry")) {
                monitorOC = oc;
                continue;
            }
            if (oc.equalsIgnoreCase("ds-gauge-monitor-entry")) {
                if (monitorOC != null) continue;
                monitorOC = oc;
                continue;
            }
            if (monitorOC != null && Debug.debugEnabled(DebugType.MONITOR)) {
                Debug.debugMonitor(entry, "Multiple monitor subclasses detected:  " + monitorOC + " and " + oc);
            }
            monitorOC = oc;
        }
        if (monitorOC == null) {
            if (entry.hasObjectClass(GENERIC_MONITOR_OC)) {
                Debug.debugMonitor(entry, "No appropriate monitor subclass");
            } else {
                Debug.debugMonitor(entry, "Missing the generic monitor class");
            }
            return GENERIC_MONITOR_OC;
        }
        return monitorOC;
    }

    @Nullable
    protected final Boolean getBoolean(@NotNull String attributeName) {
        String valueStr = this.entry.getAttributeValue(attributeName);
        if (valueStr == null) {
            if (Debug.debugEnabled(DebugType.MONITOR)) {
                Debug.debugMonitor(this.entry, "No value for Boolean attribute " + attributeName);
            }
            return null;
        }
        if (valueStr.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        if (valueStr.equalsIgnoreCase("false")) {
            return Boolean.FALSE;
        }
        if (Debug.debugEnabled(DebugType.MONITOR)) {
            Debug.debugMonitor(this.entry, "Invalid value '" + valueStr + "' for Boolean attribute " + attributeName);
        }
        return null;
    }

    @Nullable
    protected final Date getDate(@NotNull String attributeName) {
        String valueStr = this.entry.getAttributeValue(attributeName);
        if (valueStr == null) {
            if (Debug.debugEnabled(DebugType.MONITOR)) {
                Debug.debugMonitor(this.entry, "No value for Date attribute " + attributeName);
            }
            return null;
        }
        try {
            return StaticUtils.decodeGeneralizedTime(valueStr);
        }
        catch (Exception e) {
            Debug.debugException(e);
            if (Debug.debugEnabled(DebugType.MONITOR)) {
                Debug.debugMonitor(this.entry, "Invalid value '" + valueStr + "' for Date attribute " + attributeName);
            }
            return null;
        }
    }

    @Nullable
    protected final Double getDouble(@NotNull String attributeName) {
        String valueStr = this.entry.getAttributeValue(attributeName);
        if (valueStr == null) {
            if (Debug.debugEnabled(DebugType.MONITOR)) {
                Debug.debugMonitor(this.entry, "No value for Double attribute " + attributeName);
            }
            return null;
        }
        try {
            return Double.parseDouble(valueStr);
        }
        catch (Exception e) {
            Debug.debugException(e);
            if (Debug.debugEnabled(DebugType.MONITOR)) {
                Debug.debugMonitor(this.entry, "Invalid value '" + valueStr + "' for Double attribute " + attributeName);
            }
            return null;
        }
    }

    @Nullable
    protected final Integer getInteger(@NotNull String attributeName) {
        String valueStr = this.entry.getAttributeValue(attributeName);
        if (valueStr == null) {
            if (Debug.debugEnabled(DebugType.MONITOR)) {
                Debug.debugMonitor(this.entry, "No value for Integer attribute " + attributeName);
            }
            return null;
        }
        try {
            return Integer.parseInt(valueStr);
        }
        catch (Exception e) {
            Debug.debugException(e);
            if (Debug.debugEnabled(DebugType.MONITOR)) {
                Debug.debugMonitor(this.entry, "Invalid value '" + valueStr + "' for Integer attribute " + attributeName);
            }
            return null;
        }
    }

    @Nullable
    protected final Long getLong(@NotNull String attributeName) {
        String valueStr = this.entry.getAttributeValue(attributeName);
        if (valueStr == null) {
            if (Debug.debugEnabled(DebugType.MONITOR)) {
                Debug.debugMonitor(this.entry, "No value for Long attribute " + attributeName);
            }
            return null;
        }
        try {
            return Long.parseLong(valueStr);
        }
        catch (Exception e) {
            Debug.debugException(e);
            if (Debug.debugEnabled(DebugType.MONITOR)) {
                Debug.debugMonitor(this.entry, "Invalid value '" + valueStr + "' for Long attribute " + attributeName);
            }
            return null;
        }
    }

    @Nullable
    protected final String getString(@NotNull String attributeName) {
        String valueStr = this.entry.getAttributeValue(attributeName);
        if (valueStr == null && Debug.debugEnabled(DebugType.MONITOR)) {
            Debug.debugMonitor(this.entry, "No value for string attribute " + attributeName);
        }
        return valueStr;
    }

    @NotNull
    protected final List<String> getStrings(@NotNull String attributeName) {
        String[] valueStrs = this.entry.getAttributeValues(attributeName);
        if (valueStrs == null) {
            if (Debug.debugEnabled(DebugType.MONITOR)) {
                Debug.debugMonitor(this.entry, "No values for string attribute " + attributeName);
            }
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(Arrays.asList(valueStrs));
    }

    protected static void addMonitorAttribute(@NotNull Map<String, MonitorAttribute> attrs, @NotNull String name, @NotNull String displayName, @Nullable String description, @NotNull Boolean value) {
        String lowerName = StaticUtils.toLowerCase(name);
        MonitorAttribute a = new MonitorAttribute(lowerName, displayName, description, value);
        attrs.put(lowerName, a);
    }

    protected static void addMonitorAttribute(@NotNull Map<String, MonitorAttribute> attrs, @NotNull String name, @NotNull String displayName, @Nullable String description, @NotNull Date value) {
        String lowerName = StaticUtils.toLowerCase(name);
        MonitorAttribute a = new MonitorAttribute(lowerName, displayName, description, value);
        attrs.put(lowerName, a);
    }

    protected static void addMonitorAttribute(@NotNull Map<String, MonitorAttribute> attrs, @NotNull String name, @NotNull String displayName, @Nullable String description, @NotNull Double value) {
        String lowerName = StaticUtils.toLowerCase(name);
        MonitorAttribute a = new MonitorAttribute(lowerName, displayName, description, value);
        attrs.put(lowerName, a);
    }

    protected static void addMonitorAttribute(@NotNull Map<String, MonitorAttribute> attrs, @NotNull String name, @NotNull String displayName, @Nullable String description, @NotNull Integer value) {
        String lowerName = StaticUtils.toLowerCase(name);
        MonitorAttribute a = new MonitorAttribute(lowerName, displayName, description, value);
        attrs.put(lowerName, a);
    }

    protected static void addMonitorAttribute(@NotNull Map<String, MonitorAttribute> attrs, @NotNull String name, @NotNull String displayName, @Nullable String description, @NotNull Long value) {
        String lowerName = StaticUtils.toLowerCase(name);
        MonitorAttribute a = new MonitorAttribute(lowerName, displayName, description, value);
        attrs.put(lowerName, a);
    }

    protected static void addMonitorAttribute(@NotNull Map<String, MonitorAttribute> attrs, @NotNull String name, @NotNull String displayName, @Nullable String description, @NotNull String value) {
        String lowerName = StaticUtils.toLowerCase(name);
        MonitorAttribute a = new MonitorAttribute(lowerName, displayName, description, value);
        attrs.put(lowerName, a);
    }

    protected static void addMonitorAttribute(@NotNull Map<String, MonitorAttribute> attrs, @NotNull String name, @NotNull String displayName, @Nullable String description, @NotNull List<String> values) {
        String lowerName = StaticUtils.toLowerCase(name);
        MonitorAttribute a = new MonitorAttribute(lowerName, displayName, description, values.toArray(new String[values.size()]));
        attrs.put(lowerName, a);
    }

    @NotNull
    public final String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public final void toString(@NotNull StringBuilder buffer) {
        buffer.append("MonitorEntry(dn='");
        buffer.append(this.entry.getDN());
        buffer.append("', monitorClass='");
        buffer.append(this.monitorClass);
        buffer.append('\'');
        Iterator<MonitorAttribute> iterator = this.getMonitorAttributes().values().iterator();
        while (iterator.hasNext()) {
            buffer.append(iterator.next());
            if (!iterator.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append(')');
    }
}

