/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.task.eventsourcing.distributed;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.james.eventsourcing.Event;
import org.apache.james.eventsourcing.eventstore.cassandra.dto.EventDTO;
import org.apache.james.eventsourcing.eventstore.cassandra.dto.EventDTOModule;
import org.apache.james.json.DTOConverter;
import org.apache.james.server.task.json.JsonTaskSerializer;
import org.apache.james.server.task.json.dto.AdditionalInformationDTO;
import org.apache.james.server.task.json.dto.TaskDTO;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.eventsourcing.AdditionalInformationUpdated;
import org.apache.james.task.eventsourcing.CancelRequested;
import org.apache.james.task.eventsourcing.Cancelled;
import org.apache.james.task.eventsourcing.Completed;
import org.apache.james.task.eventsourcing.Created;
import org.apache.james.task.eventsourcing.Failed;
import org.apache.james.task.eventsourcing.Started;
import org.apache.james.task.eventsourcing.distributed.AdditionalInformationUpdatedDTO;
import org.apache.james.task.eventsourcing.distributed.CancelRequestedDTO;
import org.apache.james.task.eventsourcing.distributed.CancelledDTO;
import org.apache.james.task.eventsourcing.distributed.CompletedDTO;
import org.apache.james.task.eventsourcing.distributed.CreatedDTO;
import org.apache.james.task.eventsourcing.distributed.FailedDTO;
import org.apache.james.task.eventsourcing.distributed.StartedDTO;

public interface TasksSerializationModule {
    public static final TaskSerializationModuleFactory CREATED = (jsonTaskSerializer, additionalInformationConverter, dtoConverter) -> (EventDTOModule)EventDTOModule.forEvent(Created.class).convertToDTO(CreatedDTO.class).toDomainObjectConverter(dto -> dto.toDomainObject((DTOConverter<Task, TaskDTO>)dtoConverter)).toDTOConverter((event, typeName) -> CreatedDTO.fromDomainObject((DTOConverter<Task, TaskDTO>)dtoConverter, event, typeName)).typeName("task-manager-created").withFactory(EventDTOModule::new);
    public static final TaskSerializationModuleFactory STARTED = (jsonTaskSerializer, additionalInformationConverter, dtoConverter) -> (EventDTOModule)EventDTOModule.forEvent(Started.class).convertToDTO(StartedDTO.class).toDomainObjectConverter(StartedDTO::toDomainObject).toDTOConverter(StartedDTO::fromDomainObject).typeName("task-manager-started").withFactory(EventDTOModule::new);
    public static final TaskSerializationModuleFactory CANCEL_REQUESTED = (jsonTaskSerializer, additionalInformationConverter, dtoConverter) -> (EventDTOModule)EventDTOModule.forEvent(CancelRequested.class).convertToDTO(CancelRequestedDTO.class).toDomainObjectConverter(CancelRequestedDTO::toDomainObject).toDTOConverter(CancelRequestedDTO::fromDomainObject).typeName("task-manager-cancel-requested").withFactory(EventDTOModule::new);
    public static final TaskSerializationModuleFactory COMPLETED = (jsonTaskSerializer, additionalInformationConverter, dtoConverter) -> (EventDTOModule)EventDTOModule.forEvent(Completed.class).convertToDTO(CompletedDTO.class).toDomainObjectConverter(dto -> dto.toDomainObject((DTOConverter<TaskExecutionDetails.AdditionalInformation, AdditionalInformationDTO>)additionalInformationConverter)).toDTOConverter((event, typeName) -> CompletedDTO.fromDomainObject((DTOConverter<TaskExecutionDetails.AdditionalInformation, AdditionalInformationDTO>)additionalInformationConverter, event, typeName)).typeName("task-manager-completed").withFactory(EventDTOModule::new);
    public static final TaskSerializationModuleFactory FAILED = (jsonTaskSerializer, additionalInformationConverter, dtoConverter) -> (EventDTOModule)EventDTOModule.forEvent(Failed.class).convertToDTO(FailedDTO.class).toDomainObjectConverter(dto -> dto.toDomainObject((DTOConverter<TaskExecutionDetails.AdditionalInformation, AdditionalInformationDTO>)additionalInformationConverter)).toDTOConverter((event, typeName) -> FailedDTO.fromDomainObject((DTOConverter<TaskExecutionDetails.AdditionalInformation, AdditionalInformationDTO>)additionalInformationConverter, event, typeName)).typeName("task-manager-failed").withFactory(EventDTOModule::new);
    public static final TaskSerializationModuleFactory CANCELLED = (jsonTaskSerializer, additionalInformationConverter, dtoConverter) -> (EventDTOModule)EventDTOModule.forEvent(Cancelled.class).convertToDTO(CancelledDTO.class).toDomainObjectConverter(dto -> dto.toDomainObject((DTOConverter<TaskExecutionDetails.AdditionalInformation, AdditionalInformationDTO>)additionalInformationConverter)).toDTOConverter((event, typeName) -> CancelledDTO.fromDomainObject((DTOConverter<TaskExecutionDetails.AdditionalInformation, AdditionalInformationDTO>)additionalInformationConverter, event, typeName)).typeName("task-manager-cancelled").withFactory(EventDTOModule::new);
    public static final TaskSerializationModuleFactory UPDATED = (jsonTaskSerializer, additionalInformationConverter, dtoConverter) -> (EventDTOModule)EventDTOModule.forEvent(AdditionalInformationUpdated.class).convertToDTO(AdditionalInformationUpdatedDTO.class).toDomainObjectConverter(dto -> dto.toDomainObject((DTOConverter<TaskExecutionDetails.AdditionalInformation, AdditionalInformationDTO>)additionalInformationConverter)).toDTOConverter((event, typeName) -> AdditionalInformationUpdatedDTO.fromDomainObject((DTOConverter<TaskExecutionDetails.AdditionalInformation, AdditionalInformationDTO>)additionalInformationConverter, event, typeName)).typeName("task-manager-updated").withFactory(EventDTOModule::new);

    public static Set<EventDTOModule<? extends Event, ? extends EventDTO>> list(JsonTaskSerializer jsonTaskSerializer, DTOConverter<TaskExecutionDetails.AdditionalInformation, AdditionalInformationDTO> additionalInformationConverter, DTOConverter<Task, TaskDTO> dtoConverter) {
        return (Set)Stream.of(CREATED, STARTED, CANCEL_REQUESTED, CANCELLED, COMPLETED, FAILED, UPDATED).map(moduleFactory -> moduleFactory.create(jsonTaskSerializer, additionalInformationConverter, dtoConverter)).collect(ImmutableSet.toImmutableSet());
    }

    @FunctionalInterface
    public static interface TaskSerializationModuleFactory {
        public EventDTOModule<? extends Event, ? extends EventDTO> create(JsonTaskSerializer var1, DTOConverter<TaskExecutionDetails.AdditionalInformation, AdditionalInformationDTO> var2, DTOConverter<Task, TaskDTO> var3);
    }
}

