/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.model;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.james.core.MailAddress;
import org.apache.james.core.MaybeSender;
import org.apache.james.jmap.draft.model.Emailer;
import org.apache.james.jmap.draft.model.message.view.MessageFullView;
import org.apache.james.server.core.Envelope;
import org.apache.james.util.StreamUtils;

public class EnvelopeUtils {
    public static Envelope fromMessage(MessageFullView jmapMessage) {
        MaybeSender sender = MaybeSender.of((MailAddress)jmapMessage.getFrom().map(Emailer::toMailAddress).orElseThrow(() -> new RuntimeException("Sender is mandatory")));
        Stream<MailAddress> to = EnvelopeUtils.emailersToMailAddresses(jmapMessage.getTo());
        Stream<MailAddress> cc = EnvelopeUtils.emailersToMailAddresses(jmapMessage.getCc());
        Stream<MailAddress> bcc = EnvelopeUtils.emailersToMailAddresses(jmapMessage.getBcc());
        return new Envelope(sender, (Set)StreamUtils.flatten(Stream.of(to, cc, bcc)).collect(ImmutableSet.toImmutableSet()));
    }

    private static Stream<MailAddress> emailersToMailAddresses(List<Emailer> emailers) {
        return emailers.stream().map(Emailer::toMailAddress);
    }
}

