/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap;

import io.netty.handler.codec.http.HttpMethod;
import java.util.Objects;
import org.apache.james.jmap.UriPathTemplate;
import reactor.netty.http.server.HttpServerRequest;

public class Endpoint {
    private final HttpMethod method;
    private final String path;
    private final UriPathTemplate uriPathTemplate;

    public Endpoint(HttpMethod method, String path) {
        this.method = method;
        this.path = path;
        this.uriPathTemplate = new UriPathTemplate(path);
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public String getPath() {
        return this.path;
    }

    public boolean matches(HttpServerRequest request) {
        return this.method.equals((Object)request.method()) && this.uriPathTemplate.matches(request.uri());
    }

    UriPathTemplate getUriPathTemplate() {
        return this.uriPathTemplate;
    }

    public final boolean equals(Object o) {
        if (o instanceof Endpoint) {
            Endpoint endpoint = (Endpoint)o;
            return Objects.equals(this.method, endpoint.method) && Objects.equals(this.path, endpoint.path);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.method, this.path);
    }
}

