/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.time.Duration;
import java.util.Objects;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.lang3.StringUtils;
import org.apache.james.util.DurationParser;

public class PeriodicalHealthChecksConfiguration {
    private static final String HEALTH_CHECK_PERIOD = "healthcheck.period";
    private static final Duration DEFAULT_HEALTH_CHECK_PERIOD = Duration.ofSeconds(60L);
    private static final Duration MINIMAL_HEALTH_CHECK_PERIOD = Duration.ofSeconds(10L);
    public static final PeriodicalHealthChecksConfiguration DEFAULT_CONFIGURATION = PeriodicalHealthChecksConfiguration.builder().period(DEFAULT_HEALTH_CHECK_PERIOD).build();
    private final Duration period;

    public static Builder.RequiredPeriod builder() {
        return Builder.ReadyToBuild::new;
    }

    public static PeriodicalHealthChecksConfiguration from(Configuration configuration) {
        return PeriodicalHealthChecksConfiguration.builder().period(PeriodicalHealthChecksConfiguration.getDurationFromConfiguration(configuration)).build();
    }

    @VisibleForTesting
    PeriodicalHealthChecksConfiguration(Duration period) {
        this.period = period;
    }

    public Duration getPeriod() {
        return this.period;
    }

    public final boolean equals(Object o) {
        if (o instanceof PeriodicalHealthChecksConfiguration) {
            PeriodicalHealthChecksConfiguration that = (PeriodicalHealthChecksConfiguration)o;
            return Objects.equals(this.period, that.period);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.period);
    }

    private static Duration getDurationFromConfiguration(Configuration configuration) {
        if (StringUtils.isEmpty((CharSequence)configuration.getString(HEALTH_CHECK_PERIOD))) {
            return DEFAULT_HEALTH_CHECK_PERIOD;
        }
        return DurationParser.parse((String)configuration.getString(HEALTH_CHECK_PERIOD));
    }

    public static interface Builder {

        public static class ReadyToBuild {
            private final Duration period;

            ReadyToBuild(Duration period) {
                this.period = period;
            }

            PeriodicalHealthChecksConfiguration build() {
                Preconditions.checkArgument((this.period.compareTo(MINIMAL_HEALTH_CHECK_PERIOD) >= 0 ? 1 : 0) != 0, (String)"'period' must be equal or greater than %d ms", (long)MINIMAL_HEALTH_CHECK_PERIOD.toMillis());
                return new PeriodicalHealthChecksConfiguration(this.period);
            }
        }

        @FunctionalInterface
        public static interface RequiredPeriod {
            public ReadyToBuild period(Duration var1);
        }
    }
}

