/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.quota;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.BindMarker;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import java.util.function.Predicate;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.core.quota.QuotaCountUsage;
import org.apache.james.core.quota.QuotaSizeUsage;
import org.apache.james.mailbox.model.CurrentQuotas;
import org.apache.james.mailbox.model.QuotaOperation;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.quota.CurrentQuotaManager;
import reactor.core.publisher.Mono;

public class CassandraCurrentQuotaManager
implements CurrentQuotaManager {
    private final CassandraAsyncExecutor cassandraAsyncExecutor;
    private final PreparedStatement increaseStatement;
    private final PreparedStatement decreaseStatement;
    private final PreparedStatement getCurrentMessageCountStatement;
    private final PreparedStatement getCurrentStorageStatement;
    private final PreparedStatement getCurrentQuotasStatement;

    @Inject
    public CassandraCurrentQuotaManager(Session session) {
        this.cassandraAsyncExecutor = new CassandraAsyncExecutor(session);
        this.increaseStatement = session.prepare((RegularStatement)QueryBuilder.update((String)"currentQuota").with(QueryBuilder.incr((String)"messageCount", (BindMarker)QueryBuilder.bindMarker())).and(QueryBuilder.incr((String)"storage", (BindMarker)QueryBuilder.bindMarker())).where(QueryBuilder.eq((String)"quotaRoot", (Object)QueryBuilder.bindMarker())));
        this.decreaseStatement = session.prepare((RegularStatement)QueryBuilder.update((String)"currentQuota").with(QueryBuilder.decr((String)"messageCount", (BindMarker)QueryBuilder.bindMarker())).and(QueryBuilder.decr((String)"storage", (BindMarker)QueryBuilder.bindMarker())).where(QueryBuilder.eq((String)"quotaRoot", (Object)QueryBuilder.bindMarker())));
        this.getCurrentMessageCountStatement = session.prepare((RegularStatement)QueryBuilder.select((String[])new String[]{"messageCount"}).from("currentQuota").where(QueryBuilder.eq((String)"quotaRoot", (Object)QueryBuilder.bindMarker())));
        this.getCurrentStorageStatement = session.prepare((RegularStatement)QueryBuilder.select((String[])new String[]{"storage"}).from("currentQuota").where(QueryBuilder.eq((String)"quotaRoot", (Object)QueryBuilder.bindMarker())));
        this.getCurrentQuotasStatement = session.prepare((RegularStatement)QueryBuilder.select((String[])new String[]{"messageCount", "storage"}).from("currentQuota").where(QueryBuilder.eq((String)"quotaRoot", (Object)QueryBuilder.bindMarker())));
    }

    public Mono<Void> increase(QuotaOperation quotaOperation) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.increaseStatement.bind(new Object[]{quotaOperation.count().asLong(), quotaOperation.size().asLong(), quotaOperation.quotaRoot().getValue()}));
    }

    public Mono<Void> decrease(QuotaOperation quotaOperation) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.decreaseStatement.bind(new Object[]{quotaOperation.count().asLong(), quotaOperation.size().asLong(), quotaOperation.quotaRoot().getValue()}));
    }

    public Mono<QuotaCountUsage> getCurrentMessageCount(QuotaRoot quotaRoot) {
        return this.cassandraAsyncExecutor.executeSingleRow((Statement)this.getCurrentMessageCountStatement.bind(new Object[]{quotaRoot.getValue()})).map(row -> QuotaCountUsage.count((long)row.getLong("messageCount"))).defaultIfEmpty((Object)QuotaCountUsage.count((long)0L));
    }

    public Mono<QuotaSizeUsage> getCurrentStorage(QuotaRoot quotaRoot) {
        return this.cassandraAsyncExecutor.executeSingleRow((Statement)this.getCurrentStorageStatement.bind(new Object[]{quotaRoot.getValue()})).map(row -> QuotaSizeUsage.size((long)row.getLong("storage"))).defaultIfEmpty((Object)QuotaSizeUsage.size((long)0L));
    }

    public Mono<CurrentQuotas> getCurrentQuotas(QuotaRoot quotaRoot) {
        return this.cassandraAsyncExecutor.executeSingleRow((Statement)this.getCurrentQuotasStatement.bind(new Object[]{quotaRoot.getValue()})).map(row -> new CurrentQuotas(QuotaCountUsage.count((long)row.getLong("messageCount")), QuotaSizeUsage.size((long)row.getLong("storage")))).defaultIfEmpty((Object)CurrentQuotas.emptyQuotas());
    }

    public Mono<Void> setCurrentQuotas(QuotaOperation quotaOperation) {
        return this.getCurrentQuotas(quotaOperation.quotaRoot()).filter(Predicate.not(Predicate.isEqual(CurrentQuotas.from((QuotaOperation)quotaOperation)))).flatMap(storedQuotas -> this.decrease(new QuotaOperation(quotaOperation.quotaRoot(), storedQuotas.count(), storedQuotas.size())).then(this.increase(quotaOperation)));
    }
}

