/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.protocols;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.ProvidesIntoSet;
import org.apache.james.lmtpserver.netty.LMTPServerFactory;
import org.apache.james.lmtpserver.netty.OioLMTPServerFactory;
import org.apache.james.modules.protocols.LmtpGuiceProbe;
import org.apache.james.server.core.configuration.ConfigurationProvider;
import org.apache.james.util.LoggingLevel;
import org.apache.james.utils.GuiceProbe;
import org.apache.james.utils.InitializationOperation;
import org.apache.james.utils.InitilizationOperationBuilder;

public class LMTPServerModule
extends AbstractModule {
    protected void configure() {
        this.bind(LMTPServerFactory.class).in(Scopes.SINGLETON);
        this.bind(OioLMTPServerFactory.class).in(Scopes.SINGLETON);
        Multibinder.newSetBinder((Binder)this.binder(), GuiceProbe.class).addBinding().to(LmtpGuiceProbe.class);
    }

    @ProvidesIntoSet
    InitializationOperation configureLmtp(ConfigurationProvider configurationProvider, LMTPServerFactory lmtpServerFactory) {
        return InitilizationOperationBuilder.forClass(LMTPServerFactory.class).init(() -> {
            lmtpServerFactory.configure(configurationProvider.getConfiguration("lmtpserver", LoggingLevel.INFO));
            lmtpServerFactory.init();
        });
    }
}

