/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Frame;
import com.datastax.shaded.netty.buffer.ByteBuf;
import java.io.IOException;
import java.nio.ByteBuffer;

abstract class FrameCompressor {
    FrameCompressor() {
    }

    abstract Frame compress(Frame var1) throws IOException;

    abstract ByteBuf compress(ByteBuf var1) throws IOException;

    abstract Frame decompress(Frame var1) throws IOException;

    abstract ByteBuf decompress(ByteBuf var1, int var2) throws IOException;

    protected static ByteBuffer inputNioBuffer(ByteBuf buf) {
        int index = buf.readerIndex();
        int len = buf.readableBytes();
        return buf.nioBufferCount() == 1 ? buf.internalNioBuffer(index, len) : buf.nioBuffer(index, len);
    }

    protected static ByteBuffer outputNioBuffer(ByteBuf buf) {
        int index = buf.writerIndex();
        int len = buf.writableBytes();
        return buf.nioBufferCount() == 1 ? buf.internalNioBuffer(index, len) : buf.nioBuffer(index, len);
    }
}

