/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.method;

import eu.timepit.refined.api.RefType$;
import eu.timepit.refined.api.Refined;
import eu.timepit.refined.auto$;
import eu.timepit.refined.boolean;
import eu.timepit.refined.collection;
import java.io.Serializable;
import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.jmap.core.ClientId;
import org.apache.james.jmap.core.Id$;
import org.apache.james.jmap.core.Properties;
import org.apache.james.jmap.core.Properties$;
import org.apache.james.jmap.core.ServerId;
import org.apache.james.jmap.core.SetError;
import org.apache.james.jmap.core.SetError$;
import org.apache.james.jmap.json.MailboxSerializer;
import org.apache.james.jmap.mail.IsSubscribed;
import org.apache.james.jmap.mail.MailboxCreationId;
import org.apache.james.jmap.mail.MailboxCreationRequest;
import org.apache.james.jmap.mail.MailboxCreationRequest$;
import org.apache.james.jmap.mail.MailboxCreationResponse;
import org.apache.james.jmap.mail.MailboxRights;
import org.apache.james.jmap.mail.MailboxRights$;
import org.apache.james.jmap.mail.MailboxSetRequest;
import org.apache.james.jmap.mail.Quota;
import org.apache.james.jmap.mail.QuotaId;
import org.apache.james.jmap.mail.Quotas;
import org.apache.james.jmap.mail.SortOrder;
import org.apache.james.jmap.mail.SortOrder$;
import org.apache.james.jmap.mail.TotalEmails;
import org.apache.james.jmap.mail.TotalThreads;
import org.apache.james.jmap.mail.UnreadEmails;
import org.apache.james.jmap.mail.UnreadThreads;
import org.apache.james.jmap.method.MailboxCreationParseException;
import org.apache.james.jmap.routes.ProcessingContext;
import org.apache.james.jmap.routes.SessionSupplier;
import org.apache.james.jmap.utils.quotas.QuotaLoaderWithPreloadedDefaultFactory;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.Role;
import org.apache.james.mailbox.SubscriptionManager;
import org.apache.james.mailbox.exception.InsufficientRightsException;
import org.apache.james.mailbox.exception.MailboxExistsException;
import org.apache.james.mailbox.exception.MailboxNameException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.metrics.api.MetricFactory;
import play.api.libs.json.JsError;
import play.api.libs.json.JsObject;
import play.api.libs.json.JsPath;
import play.api.libs.json.JsResult;
import play.api.libs.json.JsSuccess;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.JsonValidationError;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scheduler.Schedulers;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.concurrent.duration.Duration;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0011ur!\u00021b\u0011\u0003ag!\u00028b\u0011\u0003y\u0007\"\u0002<\u0002\t\u00039ha\u0002=\u0002!\u0003\r\n#\u001f\u0005\u0006u\u000e1\ta\u001f\u0004\u0007\u0003\u000b\f\u0001)a2\t\u0011i,!Q3A\u0005\u0002mD\u0011\"!\f\u0006\u0005#\u0005\u000b\u0011\u0002?\t\u0015\u0005%WA!f\u0001\n\u0003\tY\r\u0003\u0006\u0002T\u0016\u0011\t\u0012)A\u0005\u0003\u001bDaA^\u0003\u0005\u0002\u0005U\u0007\"CA*\u000b\u0005\u0005I\u0011AAo\u0011%\tY&BI\u0001\n\u0003\ti\u0006C\u0005\u0002t\u0015\t\n\u0011\"\u0001\u0002d\"I\u0011\u0011P\u0003\u0002\u0002\u0013\u0005\u00131\u0010\u0005\n\u0003\u001b+\u0011\u0011!C\u0001\u0003\u001fC\u0011\"a&\u0006\u0003\u0003%\t!a:\t\u0013\u0005\u0015V!!A\u0005\u0002\u0005-\b\"CAY\u000b\u0005\u0005I\u0011IAx\u0011%\t9,BA\u0001\n\u0003\nI\fC\u0005\u0002<\u0016\t\t\u0011\"\u0011\u0002>\"I\u0011qX\u0003\u0002\u0002\u0013\u0005\u00131_\u0004\n\u0003o\f\u0011\u0011!E\u0001\u0003s4\u0011\"!2\u0002\u0003\u0003E\t!a?\t\rY<B\u0011\u0001B\n\u0011%\tYlFA\u0001\n\u000b\ni\fC\u0005\u0003\u0016]\t\t\u0011\"!\u0003\u0018!I!QD\f\u0002\u0002\u0013\u0005%q\u0004\u0005\n\u0005c9\u0012\u0011!C\u0005\u0005g1a!a\u0002\u0002\u0001\u0006%\u0001\u0002\u0003>\u001e\u0005+\u0007I\u0011A>\t\u0013\u00055RD!E!\u0002\u0013a\bBCA\u0018;\tU\r\u0011\"\u0001\u00022!Q\u0011\u0011H\u000f\u0003\u0012\u0003\u0006I!a\r\t\rYlB\u0011AA\u001e\u0011\u001d\t\u0019%\bC\u0001\u0003\u000bB\u0011\"a\u0015\u001e\u0003\u0003%\t!!\u0016\t\u0013\u0005mS$%A\u0005\u0002\u0005u\u0003\"CA:;E\u0005I\u0011AA;\u0011%\tI(HA\u0001\n\u0003\nY\bC\u0005\u0002\u000ev\t\t\u0011\"\u0001\u0002\u0010\"I\u0011qS\u000f\u0002\u0002\u0013\u0005\u0011\u0011\u0014\u0005\n\u0003Kk\u0012\u0011!C\u0001\u0003OC\u0011\"!-\u001e\u0003\u0003%\t%a-\t\u0013\u0005]V$!A\u0005B\u0005e\u0006\"CA^;\u0005\u0005I\u0011IA_\u0011%\ty,HA\u0001\n\u0003\n\tmB\u0005\u0003<\u0005\t\t\u0011#\u0001\u0003>\u0019I\u0011qA\u0001\u0002\u0002#\u0005!q\b\u0005\u0007mB\"\tAa\u0011\t\u0013\u0005m\u0006'!A\u0005F\u0005u\u0006\"\u0003B\u000ba\u0005\u0005I\u0011\u0011B#\u0011%\u0011i\u0002MA\u0001\n\u0003\u0013Y\u0005C\u0005\u00032A\n\t\u0011\"\u0003\u00034\u00191!1K\u0001A\u0005+B!Ba\u00167\u0005+\u0007I\u0011\u0001B-\u0011)\u0011\tG\u000eB\tB\u0003%!1\f\u0005\u0007mZ\"\tAa\u0019\t\u000f\t%d\u0007\"\u0001\u0003l!9!Q\u0010\u001c\u0005\u0002\t}\u0004\"CA*m\u0005\u0005I\u0011\u0001BB\u0011%\tYFNI\u0001\n\u0003\u00119\tC\u0005\u0002zY\n\t\u0011\"\u0011\u0002|!I\u0011Q\u0012\u001c\u0002\u0002\u0013\u0005\u0011q\u0012\u0005\n\u0003/3\u0014\u0011!C\u0001\u0005\u0017C\u0011\"!*7\u0003\u0003%\tAa$\t\u0013\u0005Ef'!A\u0005B\tM\u0005\"CA\\m\u0005\u0005I\u0011IA]\u0011%\tYLNA\u0001\n\u0003\ni\fC\u0005\u0002@Z\n\t\u0011\"\u0011\u0003\u0018\u001eI!1T\u0001\u0002\u0002#\u0005!Q\u0014\u0004\n\u0005'\n\u0011\u0011!E\u0001\u0005?CaA^$\u0005\u0002\t\u001d\u0006\"CA^\u000f\u0006\u0005IQIA_\u0011%\u0011)bRA\u0001\n\u0003\u0013I\u000bC\u0005\u0003\u001e\u001d\u000b\t\u0011\"!\u0003.\"I!\u0011G$\u0002\u0002\u0013%!1\u0007\u0004\u0006]\u0006\u0004!1\u0017\u0005\u000b\u0005kk%\u0011!Q\u0001\n\t]\u0006B\u0003Bb\u001b\n\u0005\t\u0015!\u0003\u0003F\"Q!\u0011['\u0003\u0002\u0003\u0006IAa5\t\u0015\teWJ!A!\u0002\u0013\u0011Y\u000e\u0003\u0006\u0003p6\u0013\t\u0011)A\u0005\u0005cD!b!\u0001N\u0005\u000b\u0007I\u0011AB\u0002\u0011)\u0019)\"\u0014B\u0001B\u0003%1Q\u0001\u0005\u000b\u0007/i%Q1A\u0005\u0002\re\u0001BCB\u0014\u001b\n\u0005\t\u0015!\u0003\u0004\u001c!1a/\u0014C\u0001\u0007SAqa!\u0014N\t\u0003\u0019y\u0005C\u0004\u0004\u001e6#Iaa(\t\u000f\r\rW\n\"\u0003\u0004F\"911\\'\u0005\n\ru\u0007bBBw\u001b\u0012%1q\u001e\u0005\b\u0007{lE\u0011BB\u0000\u0011\u001d!y!\u0014C\u0005\t#Aqa!(N\t\u0013!\t$A\rNC&d'm\u001c=TKR\u001c%/Z1uKB+'OZ8s[\u0016\u0014(B\u00012d\u0003\u0019iW\r\u001e5pI*\u0011A-Z\u0001\u0005U6\f\u0007O\u0003\u0002gO\u0006)!.Y7fg*\u0011\u0001.[\u0001\u0007CB\f7\r[3\u000b\u0003)\f1a\u001c:h\u0007\u0001\u0001\"!\\\u0001\u000e\u0003\u0005\u0014\u0011$T1jY\n|\u0007pU3u\u0007J,\u0017\r^3QKJ4wN]7feN\u0011\u0011\u0001\u001d\t\u0003cRl\u0011A\u001d\u0006\u0002g\u0006)1oY1mC&\u0011QO\u001d\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005a'!F'bS2\u0014w\u000e_\"sK\u0006$\u0018n\u001c8SKN,H\u000e^\n\u0003\u0007A\f\u0011#\\1jY\n|\u0007p\u0011:fCRLwN\\%e+\u0005a\bcA?\u0002\u00025\taP\u0003\u0002\u0000G\u0006!Q.Y5m\u0013\r\t\u0019A \u0002\u0012\u001b\u0006LGNY8y\u0007J,\u0017\r^5p]&#\u0017fA\u0002\u001e\u000b\t1R*Y5mE>D8I]3bi&|gNR1jYV\u0014Xm\u0005\u0005\u001ea\u0006-\u0011qBA\u000b!\r\tiaA\u0007\u0002\u0003A\u0019\u0011/!\u0005\n\u0007\u0005M!OA\u0004Qe>$Wo\u0019;\u0011\t\u0005]\u0011q\u0005\b\u0005\u00033\t\u0019C\u0004\u0003\u0002\u001c\u0005\u0005RBAA\u000f\u0015\r\tyb[\u0001\u0007yI|w\u000e\u001e \n\u0003ML1!!\ns\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u000b\u0002,\ta1+\u001a:jC2L'0\u00192mK*\u0019\u0011Q\u0005:\u0002%5\f\u0017\u000e\u001c2pq\u000e\u0013X-\u0019;j_:LE\rI\u0001\nKb\u001cW\r\u001d;j_:,\"!a\r\u0011\t\u0005]\u0011QG\u0005\u0005\u0003o\tYCA\u0005Fq\u000e,\u0007\u000f^5p]\u0006QQ\r_2faRLwN\u001c\u0011\u0015\r\u0005u\u0012qHA!!\r\ti!\b\u0005\u0006u\n\u0002\r\u0001 \u0005\b\u0003_\u0011\u0003\u0019AA\u001a\u0003E\t7/T1jY\n|\u0007pU3u\u000bJ\u0014xN]\u000b\u0003\u0003\u000f\u0002B!!\u0013\u0002P5\u0011\u00111\n\u0006\u0004\u0003\u001b\u001a\u0017\u0001B2pe\u0016LA!!\u0015\u0002L\tA1+\u001a;FeJ|'/\u0001\u0003d_BLHCBA\u001f\u0003/\nI\u0006C\u0004{IA\u0005\t\u0019\u0001?\t\u0013\u0005=B\u0005%AA\u0002\u0005M\u0012AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003?R3\u0001`A1W\t\t\u0019\u0007\u0005\u0003\u0002f\u0005=TBAA4\u0015\u0011\tI'a\u001b\u0002\u0013Ut7\r[3dW\u0016$'bAA7e\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005E\u0014q\r\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003oRC!a\r\u0002b\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!! \u0011\t\u0005}\u0014\u0011R\u0007\u0003\u0003\u0003SA!a!\u0002\u0006\u0006!A.\u00198h\u0015\t\t9)\u0001\u0003kCZ\f\u0017\u0002BAF\u0003\u0003\u0013aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRLXCAAI!\r\t\u00181S\u0005\u0004\u0003+\u0013(aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BAN\u0003C\u00032!]AO\u0013\r\tyJ\u001d\u0002\u0004\u0003:L\b\"CARS\u0005\u0005\t\u0019AAI\u0003\rAH%M\u0001\tG\u0006tW)];bYR!\u0011\u0011VAX!\r\t\u00181V\u0005\u0004\u0003[\u0013(a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003GS\u0013\u0011!a\u0001\u00037\u000b!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u0011QPA[\u0011%\t\u0019kKA\u0001\u0002\u0004\t\t*\u0001\u0005iCND7i\u001c3f)\t\t\t*\u0001\u0005u_N#(/\u001b8h)\t\ti(\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003S\u000b\u0019\rC\u0005\u0002$:\n\t\u00111\u0001\u0002\u001c\n1R*Y5mE>D8I]3bi&|gnU;dG\u0016\u001c8o\u0005\u0005\u0006a\u0006-\u0011qBA\u000b\u0003]i\u0017-\u001b7c_b\u001c%/Z1uS>t'+Z:q_:\u001cX-\u0006\u0002\u0002NB\u0019Q0a4\n\u0007\u0005EgPA\fNC&d'm\u001c=De\u0016\fG/[8o%\u0016\u001c\bo\u001c8tK\u0006AR.Y5mE>D8I]3bi&|gNU3ta>t7/\u001a\u0011\u0015\r\u0005]\u0017\u0011\\An!\r\ti!\u0002\u0005\u0006u*\u0001\r\u0001 \u0005\b\u0003\u0013T\u0001\u0019AAg)\u0019\t9.a8\u0002b\"9!p\u0003I\u0001\u0002\u0004a\b\"CAe\u0017A\u0005\t\u0019AAg+\t\t)O\u000b\u0003\u0002N\u0006\u0005D\u0003BAN\u0003SD\u0011\"a)\u0011\u0003\u0003\u0005\r!!%\u0015\t\u0005%\u0016Q\u001e\u0005\n\u0003G\u000b\u0012\u0011!a\u0001\u00037#B!! \u0002r\"I\u00111\u0015\n\u0002\u0002\u0003\u0007\u0011\u0011\u0013\u000b\u0005\u0003S\u000b)\u0010C\u0005\u0002$V\t\t\u00111\u0001\u0002\u001c\u00061R*Y5mE>D8I]3bi&|gnU;dG\u0016\u001c8\u000fE\u0002\u0002\u000e]\u0019RaFA\u007f\u0005\u0013\u0001\u0012\"a@\u0003\u0006q\fi-a6\u000e\u0005\t\u0005!b\u0001B\u0002e\u00069!/\u001e8uS6,\u0017\u0002\u0002B\u0004\u0005\u0003\u0011\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83!\u0011\u0011YA!\u0005\u000e\u0005\t5!\u0002\u0002B\b\u0003\u000b\u000b!![8\n\t\u0005%\"Q\u0002\u000b\u0003\u0003s\fQ!\u00199qYf$b!a6\u0003\u001a\tm\u0001\"\u0002>\u001b\u0001\u0004a\bbBAe5\u0001\u0007\u0011QZ\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011\tC!\f\u0011\u000bE\u0014\u0019Ca\n\n\u0007\t\u0015\"O\u0001\u0004PaRLwN\u001c\t\u0007c\n%B0!4\n\u0007\t-\"O\u0001\u0004UkBdWM\r\u0005\n\u0005_Y\u0012\u0011!a\u0001\u0003/\f1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0011)\u0004\u0005\u0003\u0002\u0000\t]\u0012\u0002\u0002B\u001d\u0003\u0003\u0013aa\u00142kK\u000e$\u0018AF'bS2\u0014w\u000e_\"sK\u0006$\u0018n\u001c8GC&dWO]3\u0011\u0007\u00055\u0001gE\u00031\u0005\u0003\u0012I\u0001E\u0005\u0002\u0000\n\u0015A0a\r\u0002>Q\u0011!Q\b\u000b\u0007\u0003{\u00119E!\u0013\t\u000bi\u001c\u0004\u0019\u0001?\t\u000f\u0005=2\u00071\u0001\u00024Q!!Q\nB)!\u0015\t(1\u0005B(!\u0019\t(\u0011\u0006?\u00024!I!q\u0006\u001b\u0002\u0002\u0003\u0007\u0011Q\b\u0002\u0017\u001b\u0006LGNY8y\u0007J,\u0017\r^5p]J+7/\u001e7ugN1a\u0007]A\b\u0003+\tqa\u0019:fCR,G-\u0006\u0002\u0003\\A1\u0011q\u0003B/\u0003\u0017IAAa\u0018\u0002,\t\u00191+Z9\u0002\u0011\r\u0014X-\u0019;fI\u0002\"BA!\u001a\u0003hA\u0019\u0011Q\u0002\u001c\t\u000f\t]\u0013\b1\u0001\u0003\\\u0005y!/\u001a;sS\u00164Xm\u0011:fCR,G-\u0006\u0002\u0003nA9!q\u000eB<y\u00065g\u0002\u0002B9\u0005g\u00022!a\u0007s\u0013\r\u0011)H]\u0001\u0007!J,G-\u001a4\n\t\te$1\u0010\u0002\u0004\u001b\u0006\u0004(b\u0001B;e\u0006q!/\u001a;sS\u00164X-\u0012:s_J\u001cXC\u0001BA!\u001d\u0011yGa\u001e}\u0003\u000f\"BA!\u001a\u0003\u0006\"I!q\u000b\u001f\u0011\u0002\u0003\u0007!1L\u000b\u0003\u0005\u0013SCAa\u0017\u0002bQ!\u00111\u0014BG\u0011%\t\u0019\u000bQA\u0001\u0002\u0004\t\t\n\u0006\u0003\u0002*\nE\u0005\"CAR\u0003\u0006\u0005\t\u0019AAN)\u0011\tiH!&\t\u0013\u0005\r&)!AA\u0002\u0005EE\u0003BAU\u00053C\u0011\"a)F\u0003\u0003\u0005\r!a'\u0002-5\u000b\u0017\u000e\u001c2pq\u000e\u0013X-\u0019;j_:\u0014Vm];miN\u00042!!\u0004H'\u00159%\u0011\u0015B\u0005!!\tyPa)\u0003\\\t\u0015\u0014\u0002\u0002BS\u0005\u0003\u0011\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c82)\t\u0011i\n\u0006\u0003\u0003f\t-\u0006b\u0002B,\u0015\u0002\u0007!1\f\u000b\u0005\u0005_\u0013\t\fE\u0003r\u0005G\u0011Y\u0006C\u0005\u00030-\u000b\t\u00111\u0001\u0003fM\u0011Q\n]\u0001\u000bg\u0016\u0014\u0018.\u00197ju\u0016\u0014\b\u0003\u0002B]\u0005\u007fk!Aa/\u000b\u0007\tu6-\u0001\u0003kg>t\u0017\u0002\u0002Ba\u0005w\u0013\u0011#T1jY\n|\u0007pU3sS\u0006d\u0017N_3s\u00039i\u0017-\u001b7c_bl\u0015M\\1hKJ\u0004BAa2\u0003N6\u0011!\u0011\u001a\u0006\u0004\u0005\u0017,\u0017aB7bS2\u0014w\u000e_\u0005\u0005\u0005\u001f\u0014IM\u0001\bNC&d'm\u001c=NC:\fw-\u001a:\u0002'M,(m]2sSB$\u0018n\u001c8NC:\fw-\u001a:\u0011\t\t\u001d'Q[\u0005\u0005\u0005/\u0014IMA\nTk\n\u001c8M]5qi&|g.T1oC\u001e,'/\u0001\tnC&d'm\u001c=JI\u001a\u000b7\r^8ssB!!Q\u001cBu\u001d\u0011\u0011yN!:\u000e\u0005\t\u0005(\u0002\u0002Br\u0005\u0013\fQ!\\8eK2LAAa:\u0003b\u0006IQ*Y5mE>D\u0018\nZ\u0005\u0005\u0005W\u0014iOA\u0004GC\u000e$xN]=\u000b\t\t\u001d(\u0011]\u0001\rcV|G/\u0019$bGR|'/\u001f\t\u0005\u0005g\u0014i0\u0004\u0002\u0003v*!!q\u001fB}\u0003\u0019\tXo\u001c;bg*\u0019!1`2\u0002\u000bU$\u0018\u000e\\:\n\t\t}(Q\u001f\u0002'#V|G/\u0019'pC\u0012,'oV5uQB\u0013X\r\\8bI\u0016$G)\u001a4bk2$h)Y2u_JL\u0018!D7fiJL7MR1di>\u0014\u00180\u0006\u0002\u0004\u0006A!1qAB\t\u001b\t\u0019IA\u0003\u0003\u0004\f\r5\u0011aA1qS*\u00191qB3\u0002\u000f5,GO]5dg&!11CB\u0005\u00055iU\r\u001e:jG\u001a\u000b7\r^8ss\u0006qQ.\u001a;sS\u000e4\u0015m\u0019;pef\u0004\u0013aD:fgNLwN\\*vaBd\u0017.\u001a:\u0016\u0005\rm\u0001\u0003BB\u000f\u0007Gi!aa\b\u000b\u0007\r\u00052-\u0001\u0004s_V$Xm]\u0005\u0005\u0007K\u0019yBA\bTKN\u001c\u0018n\u001c8TkB\u0004H.[3s\u0003A\u0019Xm]:j_:\u001cV\u000f\u001d9mS\u0016\u0014\b\u0005\u0006\t\u0004,\r52qFB\u0019\u0007g\u0019)da\u000e\u0004:A\u0011Q.\u0014\u0005\b\u0005k;\u0006\u0019\u0001B\\\u0011\u001d\u0011\u0019m\u0016a\u0001\u0005\u000bDqA!5X\u0001\u0004\u0011\u0019\u000eC\u0004\u0003Z^\u0003\rAa7\t\u000f\t=x\u000b1\u0001\u0003r\"91\u0011A,A\u0002\r\u0015\u0001bBB\f/\u0002\u000711\u0004\u0015\u0004/\u000eu\u0002\u0003BB \u0007\u0013j!a!\u0011\u000b\t\r\r3QI\u0001\u0007S:TWm\u0019;\u000b\u0005\r\u001d\u0013!\u00026bm\u0006D\u0018\u0002BB&\u0007\u0003\u0012a!\u00138kK\u000e$\u0018aD2sK\u0006$X-T1jY\n|\u00070Z:\u0015\u0011\rE3QQBH\u00073\u0003baa\u0015\u0004b\r\u0015TBAB+\u0015\u0011\u00199f!\u0017\u0002\u0013A,(\r\\5tQ\u0016\u0014(bA:\u0004\\)!\u0011QJB/\u0015\t\u0019y&A\u0004sK\u0006\u001cGo\u001c:\n\t\r\r4Q\u000b\u0002\u0006'6{gn\u001c\t\bc\n%2qMB@!\r\u0019IG\u000e\b\u0004\u0007W\u0002a\u0002BB7\u0007{rAaa\u001c\u0004|9!1\u0011OB=\u001d\u0011\u0019\u0019ha\u001e\u000f\t\u0005m1QO\u0005\u0002U&\u0011\u0001.[\u0005\u0003M\u001eL!\u0001Z3\n\u0005\t\u001c\u0007\u0003BB\u000f\u0007\u0003KAaa!\u0004 \t\t\u0002K]8dKN\u001c\u0018N\\4D_:$X\r\u001f;\t\u000f\r\u001d\u0005\f1\u0001\u0004\n\u0006qQ.Y5mE>D8+Z:tS>t\u0007\u0003\u0002Bd\u0007\u0017KAa!$\u0003J\nqQ*Y5mE>D8+Z:tS>t\u0007bBBI1\u0002\u000711S\u0001\u0012[\u0006LGNY8y'\u0016$(+Z9vKN$\bcA?\u0004\u0016&\u00191q\u0013@\u0003#5\u000b\u0017\u000e\u001c2pqN+GOU3rk\u0016\u001cH\u000fC\u0004\u0004\u001cb\u0003\raa \u0002#A\u0014xnY3tg&twmQ8oi\u0016DH/A\u0007de\u0016\fG/Z'bS2\u0014w\u000e\u001f\u000b\u000b\u0007C\u001b)ka*\u0004*\u000e\u0005\u0007cB9\u0003*\r\r6q\u0010\t\u0004\u0007S\u001a\u0001bBBD3\u0002\u00071\u0011\u0012\u0005\u0006uf\u0003\r\u0001 \u0005\b\u0007WK\u0006\u0019ABW\u0003!Q7o\u00142kK\u000e$\b\u0003BBX\u0007{k!a!-\u000b\t\tu61\u0017\u0006\u0005\u0007k\u001b9,\u0001\u0003mS\n\u001c(\u0002BB\u0006\u0007sS!aa/\u0002\tAd\u0017-_\u0005\u0005\u0007\u007f\u001b\tL\u0001\u0005Kg>\u0013'.Z2u\u0011\u001d\u0019Y*\u0017a\u0001\u0007\u007f\n1\u0002]1sg\u0016\u001c%/Z1uKR!1qYBm!!\t9b!3\u0004N\u000eM\u0017\u0002BBf\u0003W\u0011a!R5uQ\u0016\u0014\bcA7\u0004P&\u00191\u0011[1\u0003;5\u000b\u0017\u000e\u001c2pq\u000e\u0013X-\u0019;j_:\u0004\u0016M]:f\u000bb\u001cW\r\u001d;j_:\u00042!`Bk\u0013\r\u00199N \u0002\u0017\u001b\u0006LGNY8y\u0007J,\u0017\r^5p]J+\u0017/^3ti\"911\u0016.A\u0002\r5\u0016a\u0003:fg>dg/\u001a)bi\"$baa8\u0004h\u000e%\b\u0003CA\f\u0007\u0013\f\u0019d!9\u0011\t\t}71]\u0005\u0005\u0007K\u0014\tOA\u0006NC&d'm\u001c=QCRD\u0007bBBD7\u0002\u00071\u0011\u0012\u0005\b\u0007W\\\u0006\u0019ABj\u0003Yi\u0017-\u001b7c_b\u001c%/Z1uS>t'+Z9vKN$\u0018\u0001\u0004:fiJLWM^3QCRDGCBBp\u0007c\u001cY\u0010C\u0004\u0004tr\u0003\ra!>\u0002\u00135\f\u0017\u000e\u001c2pq&#\u0007\u0003\u0002Bp\u0007oLAa!?\u0003b\nIQ*Y5mE>D\u0018\n\u001a\u0005\b\u0007\u000fc\u0006\u0019ABE\u0003\r\u0012XmY8sI\u000e\u0013X-\u0019;j_:LE-\u00138Qe>\u001cWm]:j]\u001e\u001cuN\u001c;fqR$\u0002\u0002\"\u0001\u0005\n\u0011-AQ\u0002\t\t\u0003/\u0019I\rb\u0001\u0004\u0000A!\u0011q\u0003C\u0003\u0013\u0011!9!a\u000b\u00031%cG.Z4bY\u0006\u0013x-^7f]R,\u0005pY3qi&|g\u000eC\u0003{;\u0002\u0007A\u0010C\u0004\u0004\u001cv\u0003\raa \t\u000f\rMX\f1\u0001\u0004v\u0006yQ.Y5mE>D8+\u001a;FeJ|'\u000f\u0006\u0003\u0002H\u0011M\u0001b\u0002C\u000b=\u0002\u0007AqC\u0001\u0007KJ\u0014xN]:\u0011\r\u0011eAq\u0004C\u0011\u001b\t!YBC\u0002\u0005\u001eI\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011y\u0006b\u0007\u0011\u000fE\u0014I\u0003b\t\u0005*A!1q\u0016C\u0013\u0013\u0011!9c!-\u0003\r)\u001b\b+\u0019;i!\u0019!I\u0002b\b\u0005,A!1q\u0016C\u0017\u0013\u0011!yc!-\u0003')\u001bxN\u001c,bY&$\u0017\r^5p]\u0016\u0013(o\u001c:\u0015\u0011\u0011MBQ\u0007C\u001c\tw\u0001\u0002\"a\u0006\u0004J\u0006M\u0012Q\u001a\u0005\b\u0007\u000f{\u0006\u0019ABE\u0011\u001d!Id\u0018a\u0001\u0007C\fA\u0001]1uQ\"911^0A\u0002\rM\u0007")
public class MailboxSetCreatePerformer {
    private final MailboxSerializer serializer;
    private final MailboxManager mailboxManager;
    private final SubscriptionManager subscriptionManager;
    private final MailboxId.Factory mailboxIdFactory;
    private final QuotaLoaderWithPreloadedDefaultFactory quotaFactory;
    private final MetricFactory metricFactory;
    private final SessionSupplier sessionSupplier;

    public MetricFactory metricFactory() {
        return this.metricFactory;
    }

    public SessionSupplier sessionSupplier() {
        return this.sessionSupplier;
    }

    public SMono<Tuple2<MailboxCreationResults, ProcessingContext>> createMailboxes(MailboxSession mailboxSession, MailboxSetRequest mailboxSetRequest, ProcessingContext processingContext) {
        return SFlux$.MODULE$.fromIterable((Iterable)((MapOps)mailboxSetRequest.create().getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Map().empty())).view()).fold((Object)new Tuple2((Object)new MailboxCreationResults((scala.collection.immutable.Seq<MailboxCreationResult>)Nil$.MODULE$), (Object)processingContext), (Function2 & Serializable)(acc, elem) -> {
            Tuple2 tuple2 = elem;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            MailboxCreationId mailboxCreationId = (MailboxCreationId)tuple2._1();
            JsObject jsObject = (JsObject)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)mailboxCreationId, (Object)jsObject);
            MailboxCreationId mailboxCreationId2 = (MailboxCreationId)tuple22._1();
            JsObject jsObject2 = (JsObject)tuple22._2();
            Tuple2<MailboxCreationResult, ProcessingContext> tuple23 = this.createMailbox(mailboxSession, mailboxCreationId2, jsObject2, (ProcessingContext)acc._2());
            if (tuple23 == null) {
                throw new MatchError(tuple23);
            }
            MailboxCreationResult creationResult = (MailboxCreationResult)tuple23._1();
            ProcessingContext updatedProcessingContext = (ProcessingContext)tuple23._2();
            Tuple2 tuple24 = new Tuple2((Object)creationResult, (Object)updatedProcessingContext);
            MailboxCreationResult creationResult2 = (MailboxCreationResult)tuple24._1();
            ProcessingContext updatedProcessingContext2 = (ProcessingContext)tuple24._2();
            return new Tuple2((Object)new MailboxCreationResults((scala.collection.immutable.Seq<MailboxCreationResult>)((scala.collection.immutable.Seq)((MailboxCreationResults)acc._1()).created().$colon$plus((Object)creationResult2))), (Object)updatedProcessingContext2);
        }).subscribeOn(Schedulers.elastic());
    }

    private Tuple2<MailboxCreationResult, ProcessingContext> createMailbox(MailboxSession mailboxSession, MailboxCreationId mailboxCreationId, JsObject jsObject, ProcessingContext processingContext) {
        return (Tuple2)this.parseCreate(jsObject).flatMap((Function1 & Serializable)mailboxCreationRequest -> this.resolvePath(mailboxSession, (MailboxCreationRequest)mailboxCreationRequest).flatMap((Function1 & Serializable)path -> this.createMailbox(mailboxSession, (MailboxPath)path, (MailboxCreationRequest)mailboxCreationRequest))).flatMap((Function1 & Serializable)creationResponse -> this.recordCreationIdInProcessingContext(mailboxCreationId, processingContext, creationResponse.id()).map((Function1 & Serializable)context -> new Tuple2(creationResponse, context))).fold((Function1 & Serializable)e -> new Tuple2((Object)new MailboxCreationFailure(mailboxCreationId, (Exception)e), (Object)processingContext), (Function1 & Serializable)creationResponseWithUpdatedContext -> new Tuple2((Object)new MailboxCreationSuccess(mailboxCreationId, (MailboxCreationResponse)creationResponseWithUpdatedContext._1()), creationResponseWithUpdatedContext._2()));
    }

    private Either<MailboxCreationParseException, MailboxCreationRequest> parseCreate(JsObject jsObject) {
        return MailboxCreationRequest$.MODULE$.validateProperties(jsObject).flatMap((Function1 & Serializable)validJsObject -> {
            JsResult jsResult = Json$.MODULE$.fromJson((JsValue)validJsObject, $this.serializer.mailboxCreationRequest());
            if (jsResult instanceof JsSuccess) {
                JsSuccess jsSuccess = (JsSuccess)jsResult;
                MailboxCreationRequest creationRequest = (MailboxCreationRequest)jsSuccess.value();
                return package$.MODULE$.Right().apply((Object)creationRequest);
            }
            if (jsResult instanceof JsError) {
                JsError jsError = (JsError)jsResult;
                Seq errors = jsError.errors();
                return package$.MODULE$.Left().apply((Object)new MailboxCreationParseException(this.mailboxSetError((Seq<Tuple2<JsPath, Seq<JsonValidationError>>>)errors)));
            }
            throw new MatchError((Object)jsResult);
        });
    }

    private Either<Exception, MailboxPath> resolvePath(MailboxSession mailboxSession, MailboxCreationRequest mailboxCreationRequest) {
        if (StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(mailboxCreationRequest.name()), mailboxSession.getPathDelimiter())) {
            return package$.MODULE$.Left().apply((Object)new MailboxNameException(new StringBuilder(48).append("The mailbox '").append(mailboxCreationRequest.name()).append("' contains an illegal character: '").append(mailboxSession.getPathDelimiter()).append("'").toString()));
        }
        return (Either)mailboxCreationRequest.parentId().map((Function1 & Serializable)maybeParentId -> Try$.MODULE$.apply((Function0 & Serializable)() -> $this.mailboxIdFactory.fromString((String)auto$.MODULE$.autoUnwrap((Object)new Refined((Object)maybeParentId.id()), RefType$.MODULE$.refinedRefType()))).toEither().left().map((Function1 & Serializable)e -> new IllegalArgumentException(e.getMessage(), (Throwable)e)).flatMap((Function1 & Serializable)parentId -> this.retrievePath((MailboxId)parentId, mailboxSession).map((Function1 & Serializable)parentPath -> parentPath.child((String)auto$.MODULE$.autoUnwrap((Object)new Refined((Object)mailboxCreationRequest.name()), RefType$.MODULE$.refinedRefType()), mailboxSession.getPathDelimiter())))).getOrElse((Function0 & Serializable)() -> package$.MODULE$.Right().apply((Object)MailboxPath.forUser((Username)mailboxSession.getUser(), (String)((String)auto$.MODULE$.autoUnwrap((Object)new Refined((Object)mailboxCreationRequest.name()), RefType$.MODULE$.refinedRefType())))));
    }

    private Either<Exception, MailboxPath> retrievePath(MailboxId mailboxId, MailboxSession mailboxSession) {
        Left left;
        try {
            left = package$.MODULE$.Right().apply((Object)this.mailboxManager.getMailbox(mailboxId, mailboxSession).getMailboxPath());
        }
        catch (Exception e) {
            left = package$.MODULE$.Left().apply((Object)e);
        }
        return left;
    }

    private Either<IllegalArgumentException, ProcessingContext> recordCreationIdInProcessingContext(MailboxCreationId mailboxCreationId, ProcessingContext processingContext, MailboxId mailboxId) {
        return Id$.MODULE$.validate(mailboxId.serialize()).map((Function1 & Serializable)serverAssignedId -> processingContext.recordCreatedId(new ClientId(mailboxCreationId.id()), new ServerId((String)((Refined)serverAssignedId).value())));
    }

    private SetError mailboxSetError(Seq<Tuple2<JsPath, Seq<JsonValidationError>>> errors) {
        Tuple2 tuple2 = (Tuple2)errors.head();
        if (tuple2 != null) {
            JsPath path = (JsPath)tuple2._1();
            Seq seq = (Seq)tuple2._2();
            if (seq instanceof scala.collection.immutable.Seq) {
                scala.collection.immutable.Seq seq2 = (scala.collection.immutable.Seq)seq;
                SeqOps seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)seq2);
                if (!SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0) == 0) {
                    return SetError$.MODULE$.invalidArguments(new StringBuilder(42).append("'").append(path).append("' property in mailbox object is not valid").toString(), SetError$.MODULE$.invalidArguments$default$2());
                }
            }
        }
        if (tuple2 != null) {
            JsPath path = (JsPath)tuple2._1();
            Seq seq = (Seq)tuple2._2();
            if (seq instanceof scala.collection.immutable.Seq) {
                String string2;
                SeqOps seqOps;
                scala.collection.immutable.Seq seq3;
                JsonValidationError jsonValidationError;
                scala.collection.immutable.Seq seq4 = (scala.collection.immutable.Seq)seq;
                SeqOps seqOps2 = package$.MODULE$.Seq().unapplySeq((SeqOps)seq4);
                if (!SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps2) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 1) == 0 && (jsonValidationError = (JsonValidationError)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 0)) != null && jsonValidationError.args() != null && jsonValidationError.args().lengthCompare(0) == 0 && (seq3 = jsonValidationError.messages()) != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)seq3)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && "error.path.missing".equals(string2 = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0))) {
                    return SetError$.MODULE$.invalidArguments(new StringBuilder(37).append("Missing '").append(path).append("' property in mailbox object").toString(), SetError$.MODULE$.invalidArguments$default$2());
                }
            }
        }
        if (tuple2 != null) {
            JsPath path = (JsPath)tuple2._1();
            Seq seq = (Seq)tuple2._2();
            if (seq instanceof scala.collection.immutable.Seq) {
                SeqOps seqOps;
                scala.collection.immutable.Seq seq5;
                JsonValidationError jsonValidationError;
                scala.collection.immutable.Seq seq6 = (scala.collection.immutable.Seq)seq;
                SeqOps seqOps3 = package$.MODULE$.Seq().unapplySeq((SeqOps)seq6);
                if (!SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps3) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3), 1) == 0 && (jsonValidationError = (JsonValidationError)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3), 0)) != null && jsonValidationError.args() != null && jsonValidationError.args().lengthCompare(0) == 0 && (seq5 = jsonValidationError.messages()) != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)seq5)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0) {
                    String message = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                    return SetError$.MODULE$.invalidArguments(new StringBuilder(44).append("'").append(path).append("' property in mailbox object is not valid: ").append(message).toString(), SetError$.MODULE$.invalidArguments$default$2());
                }
            }
        }
        if (tuple2 != null) {
            JsPath path = (JsPath)tuple2._1();
            return SetError$.MODULE$.invalidArguments(new StringBuilder(28).append("Unknown error on property '").append(path).append("'").toString(), SetError$.MODULE$.invalidArguments$default$2());
        }
        throw new MatchError((Object)tuple2);
    }

    private Either<Exception, MailboxCreationResponse> createMailbox(MailboxSession mailboxSession, MailboxPath path, MailboxCreationRequest mailboxCreationRequest) {
        Left left;
        try {
            MailboxId mailboxId = (MailboxId)this.mailboxManager.createMailbox(path, mailboxSession).get();
            boolean defaultSubscribed = true;
            if (((IsSubscribed)mailboxCreationRequest.isSubscribed().getOrElse((Function0 & Serializable)() -> new IsSubscribed(defaultSubscribed))).value()) {
                this.subscriptionManager.subscribe(mailboxSession, path.getName());
            }
            mailboxCreationRequest.rights().foreach((Function1 & Serializable)rights -> {
                this.mailboxManager.setRights(mailboxId, rights.toMailboxAcl().asJava(), mailboxSession);
                return BoxedUnit.UNIT;
            });
            SMono qual$1 = this.quotaFactory.loadFor(mailboxSession).flatMap((Function1 & Serializable)quotaLoader -> quotaLoader.getQuotas(path));
            Duration x$1 = qual$1.block$default$1();
            Map<QuotaId, Quota> quotas = ((Quotas)qual$1.block(x$1)).quotas();
            MailboxId x$2 = mailboxId;
            SortOrder x$3 = SortOrder$.MODULE$.defaultSortOrder();
            None$ x$4 = None$.MODULE$;
            TotalEmails x$5 = new TotalEmails((Long)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)BoxesRunTime.boxToLong((long)0L))).value());
            UnreadEmails x$6 = new UnreadEmails((Long)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)BoxesRunTime.boxToLong((long)0L))).value());
            TotalThreads x$7 = new TotalThreads((Long)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)BoxesRunTime.boxToLong((long)0L))).value());
            UnreadThreads x$8 = new UnreadThreads((Long)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)BoxesRunTime.boxToLong((long)0L))).value());
            MailboxRights x$9 = MailboxRights$.MODULE$.FULL();
            Some x$10 = new Some((Object)new Quotas(quotas));
            None$ x$11 = mailboxCreationRequest.isSubscribed().isEmpty() ? new Some((Object)new IsSubscribed(defaultSubscribed)) : None$.MODULE$;
            left = package$.MODULE$.Right().apply((Object)new MailboxCreationResponse(x$2, (Option<Role>)x$4, x$3, x$5, x$6, x$7, x$8, x$9, (Option<Quotas>)x$10, (Option<IsSubscribed>)x$11));
        }
        catch (Exception error) {
            left = package$.MODULE$.Left().apply((Object)error);
        }
        return left;
    }

    @Inject
    public MailboxSetCreatePerformer(MailboxSerializer serializer, MailboxManager mailboxManager, SubscriptionManager subscriptionManager, MailboxId.Factory mailboxIdFactory, QuotaLoaderWithPreloadedDefaultFactory quotaFactory, MetricFactory metricFactory, SessionSupplier sessionSupplier) {
        this.serializer = serializer;
        this.mailboxManager = mailboxManager;
        this.subscriptionManager = subscriptionManager;
        this.mailboxIdFactory = mailboxIdFactory;
        this.quotaFactory = quotaFactory;
        this.metricFactory = metricFactory;
        this.sessionSupplier = sessionSupplier;
    }

    public static class MailboxCreationFailure
    implements MailboxCreationResult,
    Product,
    Serializable {
        private final MailboxCreationId mailboxCreationId;
        private final Exception exception;

        public Iterator<Object> productIterator() {
            return Product.productIterator$((Product)this);
        }

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        @Override
        public MailboxCreationId mailboxCreationId() {
            return this.mailboxCreationId;
        }

        public Exception exception() {
            return this.exception;
        }

        public SetError asMailboxSetError() {
            Exception exception = this.exception();
            if (exception instanceof MailboxNotFoundException) {
                MailboxNotFoundException mailboxNotFoundException = (MailboxNotFoundException)exception;
                return SetError$.MODULE$.invalidArguments(mailboxNotFoundException.getMessage(), (Option<Properties>)new Some((Object)Properties$.MODULE$.apply((scala.collection.immutable.Seq<Refined<String, boolean.Not<collection.Empty>>>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"parentId")).value()))}))));
            }
            if (exception instanceof MailboxExistsException) {
                MailboxExistsException mailboxExistsException = (MailboxExistsException)((Object)exception);
                return SetError$.MODULE$.invalidArguments(mailboxExistsException.getMessage(), (Option<Properties>)new Some((Object)Properties$.MODULE$.apply((scala.collection.immutable.Seq<Refined<String, boolean.Not<collection.Empty>>>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"name")).value()))}))));
            }
            if (exception instanceof MailboxNameException) {
                MailboxNameException mailboxNameException = (MailboxNameException)exception;
                return SetError$.MODULE$.invalidArguments(mailboxNameException.getMessage(), (Option<Properties>)new Some((Object)Properties$.MODULE$.apply((scala.collection.immutable.Seq<Refined<String, boolean.Not<collection.Empty>>>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"name")).value()))}))));
            }
            if (exception instanceof MailboxCreationParseException) {
                MailboxCreationParseException mailboxCreationParseException = (MailboxCreationParseException)exception;
                return mailboxCreationParseException.setError();
            }
            if (exception instanceof InsufficientRightsException) {
                return SetError$.MODULE$.forbidden("Insufficient rights", (Option<Properties>)new Some((Object)Properties$.MODULE$.apply((scala.collection.immutable.Seq<Refined<String, boolean.Not<collection.Empty>>>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"parentId")).value()))}))));
            }
            return SetError$.MODULE$.serverFail(this.exception().getMessage());
        }

        public MailboxCreationFailure copy(MailboxCreationId mailboxCreationId, Exception exception) {
            return new MailboxCreationFailure(mailboxCreationId, exception);
        }

        public MailboxCreationId copy$default$1() {
            return this.mailboxCreationId();
        }

        public Exception copy$default$2() {
            return this.exception();
        }

        public String productPrefix() {
            return "MailboxCreationFailure";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.mailboxCreationId();
                }
                case 1: {
                    return this.exception();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MailboxCreationFailure;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "mailboxCreationId";
                }
                case 1: {
                    return "exception";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof MailboxCreationFailure)) return false;
            boolean bl = true;
            if (!bl) return false;
            MailboxCreationFailure mailboxCreationFailure = (MailboxCreationFailure)x$1;
            MailboxCreationId mailboxCreationId = this.mailboxCreationId();
            MailboxCreationId mailboxCreationId2 = mailboxCreationFailure.mailboxCreationId();
            if (mailboxCreationId == null) {
                if (mailboxCreationId2 != null) {
                    return false;
                }
            } else if (!((Object)mailboxCreationId).equals(mailboxCreationId2)) return false;
            Exception exception = this.exception();
            Exception exception2 = mailboxCreationFailure.exception();
            if (exception == null) {
                if (exception2 != null) {
                    return false;
                }
            } else if (!exception.equals(exception2)) return false;
            if (!mailboxCreationFailure.canEqual(this)) return false;
            return true;
        }

        public MailboxCreationFailure(MailboxCreationId mailboxCreationId, Exception exception) {
            this.mailboxCreationId = mailboxCreationId;
            this.exception = exception;
            Product.$init$((Product)this);
        }
    }

    public static interface MailboxCreationResult {
        public MailboxCreationId mailboxCreationId();
    }

    public static class MailboxCreationResults
    implements Product,
    Serializable {
        private final scala.collection.immutable.Seq<MailboxCreationResult> created;

        public Iterator<Object> productIterator() {
            return Product.productIterator$((Product)this);
        }

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public scala.collection.immutable.Seq<MailboxCreationResult> created() {
            return this.created;
        }

        public Map<MailboxCreationId, MailboxCreationResponse> retrieveCreated() {
            return (Map)((IterableOnceOps)this.created().flatMap((Function1 & Serializable)result -> {
                MailboxCreationResult mailboxCreationResult = result;
                if (mailboxCreationResult instanceof MailboxCreationSuccess) {
                    MailboxCreationSuccess mailboxCreationSuccess = (MailboxCreationSuccess)mailboxCreationResult;
                    return new Some((Object)new Tuple2((Object)mailboxCreationSuccess.mailboxCreationId(), (Object)mailboxCreationSuccess.mailboxCreationResponse()));
                }
                return None$.MODULE$;
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).map((Function1 & Serializable)creation -> new Tuple2(creation._1(), creation._2()));
        }

        public Map<MailboxCreationId, SetError> retrieveErrors() {
            return ((IterableOnceOps)this.created().flatMap((Function1 & Serializable)result -> {
                MailboxCreationResult mailboxCreationResult = result;
                if (mailboxCreationResult instanceof MailboxCreationFailure) {
                    MailboxCreationFailure mailboxCreationFailure = (MailboxCreationFailure)mailboxCreationResult;
                    return new Some((Object)new Tuple2((Object)mailboxCreationFailure.mailboxCreationId(), (Object)mailboxCreationFailure.asMailboxSetError()));
                }
                return None$.MODULE$;
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }

        public MailboxCreationResults copy(scala.collection.immutable.Seq<MailboxCreationResult> created) {
            return new MailboxCreationResults(created);
        }

        public scala.collection.immutable.Seq<MailboxCreationResult> copy$default$1() {
            return this.created();
        }

        public String productPrefix() {
            return "MailboxCreationResults";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.created();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MailboxCreationResults;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "created";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof MailboxCreationResults)) return false;
            boolean bl = true;
            if (!bl) return false;
            MailboxCreationResults mailboxCreationResults = (MailboxCreationResults)x$1;
            scala.collection.immutable.Seq<MailboxCreationResult> seq = this.created();
            scala.collection.immutable.Seq<MailboxCreationResult> seq2 = mailboxCreationResults.created();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            if (!mailboxCreationResults.canEqual(this)) return false;
            return true;
        }

        public MailboxCreationResults(scala.collection.immutable.Seq<MailboxCreationResult> created) {
            this.created = created;
            Product.$init$((Product)this);
        }
    }

    public static class MailboxCreationSuccess
    implements MailboxCreationResult,
    Product,
    Serializable {
        private final MailboxCreationId mailboxCreationId;
        private final MailboxCreationResponse mailboxCreationResponse;

        public Iterator<Object> productIterator() {
            return Product.productIterator$((Product)this);
        }

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        @Override
        public MailboxCreationId mailboxCreationId() {
            return this.mailboxCreationId;
        }

        public MailboxCreationResponse mailboxCreationResponse() {
            return this.mailboxCreationResponse;
        }

        public MailboxCreationSuccess copy(MailboxCreationId mailboxCreationId, MailboxCreationResponse mailboxCreationResponse) {
            return new MailboxCreationSuccess(mailboxCreationId, mailboxCreationResponse);
        }

        public MailboxCreationId copy$default$1() {
            return this.mailboxCreationId();
        }

        public MailboxCreationResponse copy$default$2() {
            return this.mailboxCreationResponse();
        }

        public String productPrefix() {
            return "MailboxCreationSuccess";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.mailboxCreationId();
                }
                case 1: {
                    return this.mailboxCreationResponse();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MailboxCreationSuccess;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "mailboxCreationId";
                }
                case 1: {
                    return "mailboxCreationResponse";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof MailboxCreationSuccess)) return false;
            boolean bl = true;
            if (!bl) return false;
            MailboxCreationSuccess mailboxCreationSuccess = (MailboxCreationSuccess)x$1;
            MailboxCreationId mailboxCreationId = this.mailboxCreationId();
            MailboxCreationId mailboxCreationId2 = mailboxCreationSuccess.mailboxCreationId();
            if (mailboxCreationId == null) {
                if (mailboxCreationId2 != null) {
                    return false;
                }
            } else if (!((Object)mailboxCreationId).equals(mailboxCreationId2)) return false;
            MailboxCreationResponse mailboxCreationResponse = this.mailboxCreationResponse();
            MailboxCreationResponse mailboxCreationResponse2 = mailboxCreationSuccess.mailboxCreationResponse();
            if (mailboxCreationResponse == null) {
                if (mailboxCreationResponse2 != null) {
                    return false;
                }
            } else if (!((Object)mailboxCreationResponse).equals(mailboxCreationResponse2)) return false;
            if (!mailboxCreationSuccess.canEqual(this)) return false;
            return true;
        }

        public MailboxCreationSuccess(MailboxCreationId mailboxCreationId, MailboxCreationResponse mailboxCreationResponse) {
            this.mailboxCreationId = mailboxCreationId;
            this.mailboxCreationResponse = mailboxCreationResponse;
            Product.$init$((Product)this);
        }
    }
}

