/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.function.Consumer;
import java.util.function.Supplier;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.awscore.endpoint.DefaultServiceEndpointBuilder;
import software.amazon.awssdk.awscore.endpoint.DualstackEnabledProvider;
import software.amazon.awssdk.awscore.endpoint.FipsEnabledProvider;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.profiles.ProfileFile;
import software.amazon.awssdk.protocols.core.OperationInfo;
import software.amazon.awssdk.protocols.core.PathMarshaller;
import software.amazon.awssdk.protocols.core.ProtocolUtils;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Configuration;
import software.amazon.awssdk.services.s3.internal.endpoints.S3EndpointResolverContext;
import software.amazon.awssdk.services.s3.internal.endpoints.S3EndpointResolverFactory;
import software.amazon.awssdk.services.s3.internal.endpoints.S3EndpointResolverFactoryContext;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetUrlRequest;
import software.amazon.awssdk.utils.Lazy;
import software.amazon.awssdk.utils.Validate;

@Immutable
@SdkPublicApi
public final class S3Utilities {
    private final Region region;
    private final URI endpoint;
    private final S3Configuration s3Configuration;
    private final Supplier<ProfileFile> profileFile;
    private final String profileName;
    private final boolean fipsEnabled;

    private S3Utilities(Builder builder) {
        this.region = (Region)Validate.paramNotNull((Object)builder.region, (String)"Region");
        this.endpoint = builder.endpoint;
        this.profileFile = builder.profileFile != null ? () -> builder.profileFile : () -> ((Lazy)new Lazy(ProfileFile::defaultProfileFile)).getValue();
        this.profileName = builder.profileName;
        this.s3Configuration = builder.s3Configuration == null ? (S3Configuration)S3Configuration.builder().dualstackEnabled(builder.dualstackEnabled).build() : (S3Configuration)((S3Configuration.Builder)builder.s3Configuration.toBuilder().applyMutation(b -> this.resolveDualstackSetting((S3Configuration.Builder)b, builder))).build();
        this.fipsEnabled = builder.fipsEnabled != null ? builder.fipsEnabled.booleanValue() : FipsEnabledProvider.builder().profileFile(this.profileFile).profileName(this.profileName).build().isFipsEnabled().orElse(false).booleanValue();
    }

    private void resolveDualstackSetting(S3Configuration.Builder s3ConfigBuilder, Builder s3UtiltiesBuilder) {
        Validate.validState((s3ConfigBuilder.dualstackEnabled() == null || s3UtiltiesBuilder.dualstackEnabled == null ? 1 : 0) != 0, (String)"Only one of S3Configuration.Builder's dualstackEnabled or S3Utilities.Builder's dualstackEnabled should be set.", (Object[])new Object[0]);
        if (s3ConfigBuilder.dualstackEnabled() != null) {
            return;
        }
        if (s3UtiltiesBuilder.dualstackEnabled != null) {
            s3ConfigBuilder.dualstackEnabled(s3UtiltiesBuilder.dualstackEnabled);
            return;
        }
        s3ConfigBuilder.dualstackEnabled(DualstackEnabledProvider.builder().profileFile(this.profileFile).profileName(this.profileName).build().isDualstackEnabled().orElse(false));
    }

    public static Builder builder() {
        return new Builder();
    }

    @SdkInternalApi
    static S3Utilities create(SdkClientConfiguration clientConfiguration) {
        return S3Utilities.builder().region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpoint((URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).s3Configuration((S3Configuration)clientConfiguration.option((ClientOption)SdkClientOption.SERVICE_CONFIGURATION)).profileFile((ProfileFile)clientConfiguration.option((ClientOption)SdkClientOption.PROFILE_FILE)).profileName((String)clientConfiguration.option((ClientOption)SdkClientOption.PROFILE_NAME)).build();
    }

    public URL getUrl(Consumer<GetUrlRequest.Builder> getUrlRequest) {
        return this.getUrl((GetUrlRequest)((GetUrlRequest.Builder)GetUrlRequest.builder().applyMutation(getUrlRequest)).build());
    }

    public URL getUrl(GetUrlRequest getUrlRequest) {
        Region resolvedRegion = this.resolveRegionForGetUrl(getUrlRequest);
        URI resolvedEndpoint = this.resolveEndpoint(getUrlRequest.endpoint(), resolvedRegion);
        SdkHttpFullRequest marshalledRequest = this.createMarshalledRequest(getUrlRequest, resolvedEndpoint);
        GetObjectRequest getObjectRequest = (GetObjectRequest)((Object)GetObjectRequest.builder().bucket(getUrlRequest.bucket()).key(getUrlRequest.key()).versionId(getUrlRequest.versionId()).build());
        S3EndpointResolverContext resolverContext = S3EndpointResolverContext.builder().request((SdkHttpRequest)marshalledRequest).originalRequest((SdkRequest)getObjectRequest).region(resolvedRegion).endpointOverride(getUrlRequest.endpoint()).serviceConfiguration(this.s3Configuration).fipsEnabled(this.fipsEnabled).build();
        S3EndpointResolverFactoryContext resolverFactoryContext = S3EndpointResolverFactoryContext.builder().bucketName(getObjectRequest.bucket()).originalRequest(getObjectRequest).build();
        SdkHttpRequest httpRequest = S3EndpointResolverFactory.getEndpointResolver(resolverFactoryContext).applyEndpointConfiguration(resolverContext).sdkHttpRequest();
        try {
            return httpRequest.getUri().toURL();
        }
        catch (MalformedURLException exception) {
            throw SdkException.create((String)("Generated URI is malformed: " + httpRequest.getUri()), (Throwable)exception);
        }
    }

    private Region resolveRegionForGetUrl(GetUrlRequest getUrlRequest) {
        if (getUrlRequest.region() == null && this.region == null) {
            throw new IllegalArgumentException("Region should be provided either in GetUrlRequest object or S3Utilities object");
        }
        return getUrlRequest.region() != null ? getUrlRequest.region() : this.region;
    }

    private URI resolveEndpoint(URI requestOverrideEndpoint, Region region) {
        URI overrideEndpoint = requestOverrideEndpoint != null ? requestOverrideEndpoint : this.endpoint;
        return overrideEndpoint != null ? overrideEndpoint : new DefaultServiceEndpointBuilder("s3", "https").withRegion(region).withProfileFile(this.profileFile).withProfileName(this.profileName).withDualstackEnabled(Boolean.valueOf(this.s3Configuration.dualstackEnabled())).withFipsEnabled(Boolean.valueOf(this.fipsEnabled)).getServiceEndpoint();
    }

    private SdkHttpFullRequest createMarshalledRequest(GetUrlRequest getUrlRequest, URI endpoint) {
        OperationInfo operationInfo = OperationInfo.builder().requestUri("/{Bucket}/{Key+}").httpMethod(SdkHttpMethod.HEAD).build();
        SdkHttpFullRequest.Builder builder = ProtocolUtils.createSdkHttpRequest((OperationInfo)operationInfo, (URI)endpoint);
        builder.encodedPath(PathMarshaller.NON_GREEDY.marshall(builder.encodedPath(), "Bucket", getUrlRequest.bucket()));
        builder.encodedPath(PathMarshaller.GREEDY.marshall(builder.encodedPath(), "Key", getUrlRequest.key()));
        if (getUrlRequest.versionId() != null) {
            builder.appendRawQueryParameter("versionId", getUrlRequest.versionId());
        }
        return builder.build();
    }

    public static final class Builder {
        private Region region;
        private URI endpoint;
        private S3Configuration s3Configuration;
        private ProfileFile profileFile;
        private String profileName;
        private Boolean dualstackEnabled;
        private Boolean fipsEnabled;

        private Builder() {
        }

        public Builder region(Region region) {
            this.region = region;
            return this;
        }

        public Builder endpoint(URI endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder dualstackEnabled(Boolean dualstackEnabled) {
            this.dualstackEnabled = dualstackEnabled;
            return this;
        }

        public Builder fipsEnabled(Boolean fipsEnabled) {
            this.fipsEnabled = fipsEnabled;
            return this;
        }

        public Builder s3Configuration(S3Configuration s3Configuration) {
            this.s3Configuration = s3Configuration;
            return this;
        }

        private Builder profileFile(ProfileFile profileFile) {
            this.profileFile = profileFile;
            return this;
        }

        private Builder profileName(String profileName) {
            this.profileName = profileName;
            return this;
        }

        public S3Utilities build() {
            return new S3Utilities(this);
        }
    }
}

