/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.LastHttpContent;
import java.time.Duration;
import java.util.function.Function;
import reactor.netty.channel.ChannelOperations;
import reactor.netty.http.server.HttpServerMetricsRecorder;
import reactor.netty.http.server.HttpServerOperations;
import reactor.util.annotation.Nullable;

abstract class AbstractHttpServerMetricsHandler
extends ChannelDuplexHandler {
    long dataReceived;
    long dataSent;
    long dataReceivedTime;
    long dataSentTime;
    final Function<String, String> uriTagValue;

    protected AbstractHttpServerMetricsHandler(@Nullable Function<String, String> uriTagValue) {
        this.uriTagValue = uriTagValue;
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        if (msg instanceof HttpResponse) {
            if (((HttpResponse)msg).status().equals((Object)HttpResponseStatus.CONTINUE)) {
                ctx.write(msg, promise);
                return;
            }
            this.dataSentTime = System.nanoTime();
        }
        if (msg instanceof ByteBufHolder) {
            this.dataSent += (long)((ByteBufHolder)msg).content().readableBytes();
        } else if (msg instanceof ByteBuf) {
            this.dataSent += (long)((ByteBuf)msg).readableBytes();
        }
        if (msg instanceof LastHttpContent) {
            promise.addListener(future -> {
                ChannelOperations channelOps = ChannelOperations.get((Channel)ctx.channel());
                if (channelOps instanceof HttpServerOperations) {
                    HttpServerOperations ops = (HttpServerOperations)channelOps;
                    this.recordWrite(ops, this.uriTagValue == null ? ops.path : this.uriTagValue.apply(ops.path), ops.method().name(), ops.status().codeAsText().toString());
                }
                this.dataSent = 0L;
            });
        }
        ctx.write(msg, promise);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof HttpRequest) {
            this.dataReceivedTime = System.nanoTime();
        }
        if (msg instanceof ByteBufHolder) {
            this.dataReceived += (long)((ByteBufHolder)msg).content().readableBytes();
        } else if (msg instanceof ByteBuf) {
            this.dataReceived += (long)((ByteBuf)msg).readableBytes();
        }
        if (msg instanceof LastHttpContent) {
            ChannelOperations channelOps = ChannelOperations.get((Channel)ctx.channel());
            if (channelOps instanceof HttpServerOperations) {
                HttpServerOperations ops = (HttpServerOperations)channelOps;
                this.recordRead(ops, this.uriTagValue == null ? ops.path : this.uriTagValue.apply(ops.path), ops.method().name());
            }
            this.dataReceived = 0L;
        }
        ctx.fireChannelRead(msg);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        ChannelOperations channelOps = ChannelOperations.get((Channel)ctx.channel());
        if (channelOps instanceof HttpServerOperations) {
            HttpServerOperations ops = (HttpServerOperations)channelOps;
            this.recordException(ops, this.uriTagValue == null ? ops.path : this.uriTagValue.apply(ops.path));
        }
        ctx.fireExceptionCaught(cause);
    }

    protected abstract HttpServerMetricsRecorder recorder();

    protected void recordException(HttpServerOperations ops, String path) {
        this.recorder().incrementErrorsCount(ops.remoteAddress(), path);
    }

    protected void recordRead(HttpServerOperations ops, String path, String method) {
        this.recorder().recordDataReceivedTime(path, method, Duration.ofNanos(System.nanoTime() - this.dataReceivedTime));
        this.recorder().recordDataReceived(ops.remoteAddress(), path, this.dataReceived);
    }

    protected void recordWrite(HttpServerOperations ops, String path, String method, String status) {
        Duration dataSentTimeDuration = Duration.ofNanos(System.nanoTime() - this.dataSentTime);
        this.recorder().recordDataSentTime(path, method, status, dataSentTimeDuration);
        if (this.dataReceivedTime != 0L) {
            this.recorder().recordResponseTime(path, method, status, Duration.ofNanos(System.nanoTime() - this.dataReceivedTime));
        } else {
            this.recorder().recordResponseTime(path, method, status, dataSentTimeDuration);
        }
        this.recorder().recordDataSent(ops.remoteAddress(), path, this.dataSent);
    }
}

