/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.events;

import com.github.fge.lambdas.Throwing;
import java.util.Objects;
import org.apache.james.events.Event;
import org.apache.james.events.Group;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public interface EventListener {
    public static ReactiveEventListener wrapReactive(EventListener listener) {
        return new ReactiveWrapper<EventListener>(listener);
    }

    public static ReactiveGroupEventListener wrapReactive(GroupEventListener groupEventListener) {
        return new ReactiveGroupWrapper(groupEventListener);
    }

    default public ExecutionMode getExecutionMode() {
        return ExecutionMode.SYNCHRONOUS;
    }

    default public boolean isHandling(Event event) {
        return true;
    }

    public void event(Event var1) throws Exception;

    public static enum ExecutionMode {
        SYNCHRONOUS,
        ASYNCHRONOUS;

    }

    public static class ReactiveGroupWrapper
    extends ReactiveWrapper<GroupEventListener>
    implements GroupEventListener,
    ReactiveGroupEventListener {
        private ReactiveGroupWrapper(GroupEventListener delegate) {
            super(delegate);
        }

        @Override
        public Group getDefaultGroup() {
            return ((GroupEventListener)this.delegate).getDefaultGroup();
        }
    }

    public static class ReactiveWrapper<T extends EventListener>
    implements ReactiveEventListener {
        protected final T delegate;

        private ReactiveWrapper(T delegate) {
            this.delegate = delegate;
        }

        @Override
        public Publisher<Void> reactiveEvent(Event event) {
            return Mono.fromRunnable(Throwing.runnable(() -> this.delegate.event(event))).subscribeOn(ReactorUtils.BLOCKING_CALL_WRAPPER).then();
        }

        @Override
        public void event(Event event) throws Exception {
            this.delegate.event(event);
        }

        @Override
        public ExecutionMode getExecutionMode() {
            return this.delegate.getExecutionMode();
        }

        @Override
        public boolean isHandling(Event event) {
            return this.delegate.isHandling(event);
        }

        public final boolean equals(Object o) {
            if (o instanceof ReactiveWrapper) {
                ReactiveWrapper that = (ReactiveWrapper)o;
                return Objects.equals(this.delegate, that.delegate);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.delegate);
        }
    }

    public static interface ReactiveGroupEventListener
    extends ReactiveEventListener,
    GroupEventListener {
        @Override
        default public void event(Event event) throws Exception {
            Mono.from(this.reactiveEvent(event)).block();
        }
    }

    public static interface GroupEventListener
    extends EventListener {
        public Group getDefaultGroup();
    }

    public static interface ReactiveEventListener
    extends EventListener {
        public Publisher<Void> reactiveEvent(Event var1);

        @Override
        default public void event(Event event) throws Exception {
            Mono.from(this.reactiveEvent(event)).block();
        }
    }
}

