/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import javax.mail.Flags;
import org.apache.james.mailbox.model.ComposedMessageId;
import org.apache.james.mailbox.model.MessageId;

public class ComposedMessageIdWithMetaData {
    private final ComposedMessageId composedMessageId;
    private final Flags flags;
    private final long modSeq;

    public static Builder builder() {
        return new Builder();
    }

    public ComposedMessageIdWithMetaData(ComposedMessageId composedMessageId, Flags flags, long modSeq) {
        this.composedMessageId = composedMessageId;
        this.flags = flags;
        this.modSeq = modSeq;
    }

    public ComposedMessageId getComposedMessageId() {
        return this.composedMessageId;
    }

    public Flags getFlags() {
        return this.flags;
    }

    public long getModSeq() {
        return this.modSeq;
    }

    public boolean isMatching(MessageId messageId) {
        return this.getComposedMessageId().getMessageId().equals(messageId);
    }

    public final boolean equals(Object o) {
        if (o instanceof ComposedMessageIdWithMetaData) {
            ComposedMessageIdWithMetaData other = (ComposedMessageIdWithMetaData)o;
            return Objects.equal(this.composedMessageId, other.composedMessageId) && Objects.equal(this.flags, other.flags) && Objects.equal(this.modSeq, other.modSeq);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hashCode(this.composedMessageId, this.flags, this.modSeq);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("composedMessageId", this.composedMessageId).add("flags", this.flags).add("modSeq", this.modSeq).toString();
    }

    public static class Builder {
        private ComposedMessageId composedMessageId;
        private Flags flags;
        private Long modSeq;

        private Builder() {
        }

        public Builder composedMessageId(ComposedMessageId composedMessageId) {
            this.composedMessageId = composedMessageId;
            return this;
        }

        public Builder flags(Flags flags) {
            this.flags = flags;
            return this;
        }

        public Builder modSeq(long modSeq) {
            this.modSeq = modSeq;
            return this;
        }

        public ComposedMessageIdWithMetaData build() {
            Preconditions.checkNotNull(this.composedMessageId, "'composedMessageId' is mandatory");
            Preconditions.checkNotNull(this.flags, "'flags' is mandatory");
            Preconditions.checkNotNull(this.modSeq, "'modSeq' is mandatory");
            return new ComposedMessageIdWithMetaData(this.composedMessageId, this.flags, this.modSeq);
        }
    }
}

