/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.parserunners;

import org.parboiled.Context;
import org.parboiled.MatchHandler;
import org.parboiled.MatcherContext;
import org.parboiled.Rule;
import org.parboiled.buffers.InputBuffer;
import org.parboiled.common.ConsoleSink;
import org.parboiled.common.Preconditions;
import org.parboiled.common.Predicate;
import org.parboiled.common.Predicates;
import org.parboiled.common.Sink;
import org.parboiled.common.Tuple2;
import org.parboiled.matchers.Matcher;
import org.parboiled.parserunners.ReportingParseRunner;
import org.parboiled.support.MatcherPath;
import org.parboiled.support.ParsingResult;
import org.parboiled.support.Position;

public class TracingParseRunner<V>
extends ReportingParseRunner<V>
implements MatchHandler {
    private Predicate<Tuple2<Context<?>, Boolean>> filter;
    private Sink<String> log;
    private MatcherPath lastPath;
    private int line;

    public TracingParseRunner(Rule rule) {
        super(rule);
    }

    public TracingParseRunner<V> withFilter(Predicate<?> predicate) {
        this.filter = Preconditions.checkArgNotNull(predicate, "filter");
        return this;
    }

    public Predicate<Tuple2<Context<?>, Boolean>> getFilter() {
        if (this.filter == null) {
            this.withFilter(Predicates.alwaysTrue());
        }
        return this.filter;
    }

    public TracingParseRunner<V> withLog(Sink<String> sink) {
        this.log = sink;
        return this;
    }

    public Sink<String> getLog() {
        if (this.log == null) {
            this.withLog(new ConsoleSink());
        }
        return this.log;
    }

    @Override
    protected ParsingResult<V> runBasicMatch(InputBuffer inputBuffer) {
        this.getLog().receive("Starting new parsing run\n");
        this.lastPath = null;
        MatcherContext matcherContext = this.createRootContext(inputBuffer, this, true);
        boolean bl = matcherContext.runMatcher();
        return this.createParsingResult(bl, matcherContext);
    }

    @Override
    public boolean match(MatcherContext<?> matcherContext) {
        Matcher matcher = matcherContext.getMatcher();
        boolean bl = matcher.match(matcherContext);
        if (this.getFilter().apply(new Tuple2(matcherContext, bl))) {
            ++this.line;
            this.print(matcherContext, bl);
        }
        return bl;
    }

    private void print(MatcherContext<?> matcherContext, boolean bl) {
        MatcherPath matcherPath;
        Position position = matcherContext.getInputBuffer().getPosition(matcherContext.getCurrentIndex());
        MatcherPath matcherPath2 = matcherContext.getPath();
        MatcherPath matcherPath3 = matcherPath = this.lastPath != null ? matcherPath2.commonPrefix(this.lastPath) : null;
        if (matcherPath != null && matcherPath.length() > 1) {
            this.getLog().receive("..(" + (matcherPath.length() - 1) + ")../");
        }
        this.getLog().receive(matcherPath2.toString(matcherPath != null ? matcherPath.parent : null));
        String string = matcherContext.getInputBuffer().extractLine(position.line);
        this.getLog().receive(", " + (bl ? "matched" : "failed") + ", cursor at " + position.line + ':' + position.column + " after \"" + string.substring(0, Math.min(string.length(), position.column - 1)) + "\"\n");
        this.lastPath = matcherPath2;
    }
}

