/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.repository.file;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.apache.james.repository.api.ObjectRepository;
import org.apache.james.repository.file.AbstractFileRepository;
import org.apache.james.repository.file.ClassLoaderObjectInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilePersistentObjectRepository
extends AbstractFileRepository
implements ObjectRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(FilePersistentObjectRepository.class);

    @Override
    protected String getExtensionDecorator() {
        return ".FileObjectStore";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Object get(String key) {
        Object object;
        InputStream inputStream = this.getInputStream(key);
        if (inputStream == null) {
            throw new NullPointerException("Null input stream returned for key: " + key);
        }
        try {
            Object object2;
            ObjectInputStream stream = new ObjectInputStream(inputStream);
            object = object2 = stream.readObject();
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
                throw throwable;
            }
            catch (Throwable e) {
                throw new RuntimeException("Exception caught while retrieving an object", e);
            }
        }
        inputStream.close();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Object get(String key, ClassLoader classLoader) {
        Object object;
        InputStream inputStream = this.getInputStream(key);
        if (inputStream == null) {
            throw new NullPointerException("Null input stream returned for key: " + key);
        }
        ClassLoaderObjectInputStream stream = new ClassLoaderObjectInputStream(classLoader, inputStream);
        try {
            Object object2;
            object = object2 = stream.readObject();
        }
        catch (Throwable throwable) {
            try {
                stream.close();
                inputStream.close();
                throw throwable;
            }
            catch (Throwable e) {
                throw new RuntimeException("Exception caught while retrieving an object", e);
            }
        }
        stream.close();
        inputStream.close();
        return object;
    }

    @Override
    public synchronized void put(String key, Object value) {
        try (OutputStream outputStream = this.getOutputStream(key);){
            ObjectOutputStream stream = new ObjectOutputStream(outputStream);
            stream.writeObject(value);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception caught while storing an object", e);
        }
    }
}

