/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.util.NotNull;
import com.unboundid.util.UtilityMessages;
import com.unboundid.util.ValuePatternComponent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Random;

final class HTTPValuePatternComponent
extends ValuePatternComponent {
    private static final long serialVersionUID = 8879412445617836376L;
    @NotNull
    private final String[] lines;
    @NotNull
    private final Random seedRandom;
    @NotNull
    private final ThreadLocal<Random> random;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HTTPValuePatternComponent(@NotNull String url, long seed) throws IOException {
        this.seedRandom = new Random(seed);
        this.random = new ThreadLocal();
        ArrayList<String> lineList = new ArrayList<String>(100);
        URL parsedURL = new URL(url);
        HttpURLConnection urlConnection = (HttpURLConnection)parsedURL.openConnection();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                lineList.add(line);
            }
        }
        if (lineList.isEmpty()) {
            throw new IOException(UtilityMessages.ERR_VALUE_PATTERN_COMPONENT_EMPTY_FILE.get());
        }
        this.lines = new String[lineList.size()];
        lineList.toArray(this.lines);
    }

    @Override
    void append(@NotNull StringBuilder buffer) {
        Random r = this.random.get();
        if (r == null) {
            r = new Random(this.seedRandom.nextLong());
            this.random.set(r);
        }
        buffer.append(this.lines[r.nextInt(this.lines.length)]);
    }

    @Override
    boolean supportsBackReference() {
        return true;
    }
}

