/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.linshare.client;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import java.util.Objects;
import org.apache.james.linshare.client.Document;
import org.apache.james.linshare.client.User;

public class ReceivedShare {
    private final User sender;
    private final Document document;
    private final int downloaded;

    @VisibleForTesting
    ReceivedShare(@JsonProperty(value="sender") User sender, @JsonProperty(value="downloaded") int downloaded, @JsonProperty(value="uuid") String uuid, @JsonProperty(value="name") String name, @JsonProperty(value="description") String description, @JsonProperty(value="creationDate") long creationDate, @JsonProperty(value="modificationDate") long modificationDate, @JsonProperty(value="expirationDate") long expirationDate, @JsonProperty(value="ciphered") boolean ciphered, @JsonProperty(value="type") String type, @JsonProperty(value="size") long size, @JsonProperty(value="metaData") String metaData, @JsonProperty(value="sha256sum") String sha256sum, @JsonProperty(value="hasThumbnail") boolean hasThumbnail, @JsonProperty(value="shared") int shared) {
        this.sender = sender;
        this.downloaded = downloaded;
        this.document = new Document(uuid, name, description, creationDate, modificationDate, expirationDate, ciphered, type, size, metaData, sha256sum, hasThumbnail, shared);
    }

    public User getSender() {
        return this.sender;
    }

    public Document getDocument() {
        return this.document;
    }

    public int getDownloaded() {
        return this.downloaded;
    }

    public final boolean equals(Object o) {
        if (o instanceof ReceivedShare) {
            ReceivedShare that = (ReceivedShare)o;
            return Objects.equals(this.sender, that.sender) && Objects.equals(this.document, that.document) && Objects.equals(this.downloaded, that.downloaded);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.sender, this.document, this.downloaded);
    }
}

