/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs.v2.syntax;

import com.unboundid.ldap.sdk.unboundidds.logs.v2.syntax.LogFieldSyntax;
import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.NotNull;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class CommaDelimitedStringListLogFieldSyntax
extends LogFieldSyntax<Collection<? extends CharSequence>> {
    @NotNull
    public static final String SYNTAX_NAME = "comma-delimited-string-list";

    public CommaDelimitedStringListLogFieldSyntax(int maxStringLengthCharacters) {
        super(maxStringLengthCharacters);
    }

    @Override
    @NotNull
    public String getSyntaxName() {
        return SYNTAX_NAME;
    }

    @Override
    public void valueToSanitizedString(@NotNull Collection<? extends CharSequence> value, @NotNull ByteStringBuffer buffer) {
        Iterator<? extends CharSequence> iterator = value.iterator();
        while (iterator.hasNext()) {
            this.sanitize(iterator.next().toString(), buffer);
            if (!iterator.hasNext()) continue;
            buffer.append(',');
        }
    }

    @Override
    public void logSanitizedFieldToTextFormattedLog(@NotNull String fieldName, @NotNull Collection<? extends CharSequence> fieldValue, @NotNull ByteStringBuffer buffer) {
        buffer.append(' ');
        buffer.append(fieldName);
        buffer.append("=\"");
        this.valueToSanitizedString(fieldValue, buffer);
        buffer.append('\"');
    }

    @Override
    public void logSanitizedFieldToJSONFormattedLog(@NotNull String fieldName, @NotNull Collection<? extends CharSequence> fieldValue, @NotNull JSONBuffer buffer) {
        buffer.appendString(fieldName, this.valueToSanitizedString(fieldValue));
    }

    @Override
    public void logSanitizedValueToJSONFormattedLog(@NotNull Collection<? extends CharSequence> value, @NotNull JSONBuffer buffer) {
        buffer.appendString(this.valueToSanitizedString(value));
    }

    @Override
    @NotNull
    public List<String> parseValue(@NotNull String valueString) {
        String item;
        ArrayList<String> list = new ArrayList<String>();
        int lastCommaPos = -1;
        int commaPos = valueString.indexOf(44);
        while (commaPos >= 0) {
            item = valueString.substring(lastCommaPos + 1, commaPos).trim();
            list.add(item);
            lastCommaPos = commaPos;
            commaPos = valueString.indexOf(44, lastCommaPos + 1);
        }
        item = valueString.substring(lastCommaPos + 1).trim();
        if (!item.isEmpty() || !list.isEmpty()) {
            list.add(item);
        }
        return Collections.unmodifiableList(list);
    }

    @Override
    public boolean completelyRedactedValueConformsToSyntax() {
        return true;
    }

    @Override
    public void logCompletelyRedactedFieldToTextFormattedLog(@NotNull String fieldName, @NotNull ByteStringBuffer buffer) {
        buffer.append(' ');
        buffer.append(fieldName);
        buffer.append("=\"{REDACTED}\"");
    }

    @Override
    public void logCompletelyRedactedFieldToJSONFormattedLog(@NotNull String fieldName, @NotNull JSONBuffer buffer) {
        buffer.appendString(fieldName, "{REDACTED}");
    }

    @Override
    public void logCompletelyRedactedValueToJSONFormattedLog(@NotNull JSONBuffer buffer) {
        buffer.appendString("{REDACTED}");
    }

    @Override
    public boolean supportsRedactedComponents() {
        return true;
    }

    @Override
    public boolean valueWithRedactedComponentsConformsToSyntax() {
        return true;
    }

    @Override
    public void redactComponents(@NotNull Collection<? extends CharSequence> value, @NotNull ByteStringBuffer buffer) {
        Iterator<? extends CharSequence> iterator = value.iterator();
        while (iterator.hasNext()) {
            buffer.append("{REDACTED}");
            iterator.next();
            if (!iterator.hasNext()) continue;
            buffer.append(',');
        }
    }

    @Override
    public void logRedactedComponentsFieldToTextFormattedLog(@NotNull String fieldName, @NotNull Collection<? extends CharSequence> fieldValue, @NotNull ByteStringBuffer buffer) {
        buffer.append(' ');
        buffer.append(fieldName);
        buffer.append("=\"");
        this.redactComponents(fieldValue, buffer);
        buffer.append('\"');
    }

    @Override
    public void logRedactedComponentsFieldToJSONFormattedLog(@NotNull String fieldName, @NotNull Collection<? extends CharSequence> fieldValue, @NotNull JSONBuffer buffer) {
        buffer.appendString(fieldName, this.redactComponents(fieldValue));
    }

    @Override
    public void logRedactedComponentsValueToJSONFormattedLog(@NotNull Collection<? extends CharSequence> value, @NotNull JSONBuffer buffer) {
        buffer.appendString(this.redactComponents(value));
    }

    @Override
    public boolean completelyTokenizedValueConformsToSyntax() {
        return true;
    }

    @Override
    public void tokenizeEntireValue(@NotNull Collection<? extends CharSequence> value, @NotNull byte[] pepper, @NotNull ByteStringBuffer buffer) {
        this.tokenize(this.valueToSanitizedString(value), pepper, buffer);
    }

    @Override
    public void logCompletelyTokenizedFieldToTextFormattedLog(@NotNull String fieldName, @NotNull Collection<? extends CharSequence> fieldValue, @NotNull byte[] pepper, @NotNull ByteStringBuffer buffer) {
        buffer.append(' ');
        buffer.append(fieldName);
        buffer.append("=\"");
        this.tokenizeEntireValue(fieldValue, pepper, buffer);
        buffer.append('\"');
    }

    @Override
    public void logCompletelyTokenizedFieldToJSONFormattedLog(@NotNull String fieldName, @NotNull Collection<? extends CharSequence> fieldValue, @NotNull byte[] pepper, @NotNull JSONBuffer buffer) {
        buffer.appendString(fieldName, this.tokenizeEntireValue(fieldValue, pepper));
    }

    @Override
    public void logCompletelyTokenizedValueToJSONFormattedLog(@NotNull Collection<? extends CharSequence> value, @NotNull byte[] pepper, @NotNull JSONBuffer buffer) {
        buffer.appendString(this.tokenizeEntireValue(value, pepper));
    }

    @Override
    public boolean supportsTokenizedComponents() {
        return true;
    }

    @Override
    public boolean valueWithTokenizedComponentsConformsToSyntax() {
        return true;
    }

    @Override
    public void tokenizeComponents(@NotNull Collection<? extends CharSequence> value, @NotNull byte[] pepper, @NotNull ByteStringBuffer buffer) {
        Iterator<? extends CharSequence> iterator = value.iterator();
        while (iterator.hasNext()) {
            buffer.append(this.tokenize(iterator.next().toString(), pepper));
            if (!iterator.hasNext()) continue;
            buffer.append(',');
        }
    }

    @Override
    public void logTokenizedComponentsFieldToTextFormattedLog(@NotNull String fieldName, @NotNull Collection<? extends CharSequence> fieldValue, @NotNull byte[] pepper, @NotNull ByteStringBuffer buffer) {
        buffer.append(' ');
        buffer.append(fieldName);
        buffer.append("=\"");
        this.tokenizeComponents(fieldValue, pepper, buffer);
        buffer.append('\"');
    }

    @Override
    public void logTokenizedComponentsFieldToJSONFormattedLog(@NotNull String fieldName, @NotNull Collection<? extends CharSequence> fieldValue, @NotNull byte[] pepper, @NotNull JSONBuffer buffer) {
        buffer.appendString(fieldName, this.tokenizeComponents(fieldValue, pepper));
    }

    @Override
    public void logTokenizedComponentsValueToJSONFormattedLog(@NotNull Collection<? extends CharSequence> value, @NotNull byte[] pepper, @NotNull JSONBuffer buffer) {
        buffer.appendString(this.tokenizeComponents(value, pepper));
    }
}

