/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.analysis;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.analysis.TokenFilterBase;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinition;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinitionVariant;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class LowercaseTokenFilter
extends TokenFilterBase
implements TokenFilterDefinitionVariant {
    @Nullable
    private final String language;
    public static final JsonpDeserializer<LowercaseTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, LowercaseTokenFilter::setupLowercaseTokenFilterDeserializer);

    private LowercaseTokenFilter(Builder builder) {
        super(builder);
        this.language = builder.language;
    }

    public static LowercaseTokenFilter of(Function<Builder, ObjectBuilder<LowercaseTokenFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenFilterDefinition.Kind _tokenFilterDefinitionKind() {
        return TokenFilterDefinition.Kind.Lowercase;
    }

    @Nullable
    public final String language() {
        return this.language;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "lowercase");
        super.serializeInternal(generator, mapper);
        if (this.language != null) {
            generator.writeKey("language");
            generator.write(this.language);
        }
    }

    protected static void setupLowercaseTokenFilterDeserializer(ObjectDeserializer<Builder> op) {
        LowercaseTokenFilter.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::language, JsonpDeserializer.stringDeserializer(), "language");
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<LowercaseTokenFilter> {
        @Nullable
        private String language;

        public final Builder language(@Nullable String value) {
            this.language = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public LowercaseTokenFilter build() {
            this._checkSingleUse();
            return new LowercaseTokenFilter(this);
        }
    }
}

