/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.controls;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DecodeableControl;
import com.unboundid.ldap.sdk.JSONControlDecodeHelper;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.controls.ControlMessages;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import com.unboundid.util.json.JSONField;
import com.unboundid.util.json.JSONObject;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class AuthorizationIdentityResponseControl
extends Control
implements DecodeableControl {
    @NotNull
    public static final String AUTHORIZATION_IDENTITY_RESPONSE_OID = "2.16.840.1.113730.3.4.15";
    @NotNull
    private static final String JSON_FIELD_AUTHORIZATION_ID = "authorization-id";
    private static final long serialVersionUID = -6315724175438820336L;
    @NotNull
    private final String authorizationID;

    AuthorizationIdentityResponseControl() {
        this.authorizationID = null;
    }

    public AuthorizationIdentityResponseControl(@NotNull String authorizationID) {
        super(AUTHORIZATION_IDENTITY_RESPONSE_OID, false, new ASN1OctetString(authorizationID));
        Validator.ensureNotNull(authorizationID);
        this.authorizationID = authorizationID;
    }

    public AuthorizationIdentityResponseControl(@NotNull String oid, boolean isCritical, @Nullable ASN1OctetString value) throws LDAPException {
        super(oid, isCritical, value);
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_AUTHZID_RESPONSE_NO_VALUE.get());
        }
        this.authorizationID = value.stringValue();
    }

    @Override
    @NotNull
    public AuthorizationIdentityResponseControl decodeControl(@NotNull String oid, boolean isCritical, @Nullable ASN1OctetString value) throws LDAPException {
        return new AuthorizationIdentityResponseControl(oid, isCritical, value);
    }

    @Nullable
    public static AuthorizationIdentityResponseControl get(@NotNull BindResult result) throws LDAPException {
        Control c = result.getResponseControl(AUTHORIZATION_IDENTITY_RESPONSE_OID);
        if (c == null) {
            return null;
        }
        if (c instanceof AuthorizationIdentityResponseControl) {
            return (AuthorizationIdentityResponseControl)c;
        }
        return new AuthorizationIdentityResponseControl(c.getOID(), c.isCritical(), c.getValue());
    }

    @NotNull
    public String getAuthorizationID() {
        return this.authorizationID;
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_AUTHZID_RESPONSE.get();
    }

    @Override
    @NotNull
    public JSONObject toJSONControl() {
        return new JSONObject(new JSONField("oid", AUTHORIZATION_IDENTITY_RESPONSE_OID), new JSONField("control-name", ControlMessages.INFO_CONTROL_NAME_AUTHZID_RESPONSE.get()), new JSONField("criticality", this.isCritical()), new JSONField("value-json", new JSONObject(new JSONField(JSON_FIELD_AUTHORIZATION_ID, this.authorizationID))));
    }

    @NotNull
    public static AuthorizationIdentityResponseControl decodeJSONControl(@NotNull JSONObject controlObject, boolean strict) throws LDAPException {
        List<String> unrecognizedFields;
        JSONControlDecodeHelper jsonControl = new JSONControlDecodeHelper(controlObject, strict, true, true);
        ASN1OctetString rawValue = jsonControl.getRawValue();
        if (rawValue != null) {
            return new AuthorizationIdentityResponseControl(jsonControl.getOID(), jsonControl.getCriticality(), rawValue);
        }
        JSONObject valueObject = jsonControl.getValueObject();
        String authzID = valueObject.getFieldAsString(JSON_FIELD_AUTHORIZATION_ID);
        if (authzID == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_AUTHZID_RESPONSE_JSON_MISSING_AUTHZ_ID.get(valueObject.toSingleLineString(), JSON_FIELD_AUTHORIZATION_ID));
        }
        if (strict && !(unrecognizedFields = JSONControlDecodeHelper.getControlObjectUnexpectedFields(valueObject, JSON_FIELD_AUTHORIZATION_ID)).isEmpty()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_AUTHZID_RESPONSE_JSON_CONTROL_UNRECOGNIZED_FIELD.get(controlObject.toSingleLineString(), unrecognizedFields.get(0)));
        }
        return new AuthorizationIdentityResponseControl(authzID);
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("AuthorizationIdentityResponseControl(authorizationID='");
        buffer.append(this.authorizationID);
        buffer.append("', isCritical=");
        buffer.append(this.isCritical());
        buffer.append(')');
    }
}

