/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec.extras.time;

import com.datastax.oss.driver.api.core.data.TupleValue;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.TupleType;
import com.datastax.oss.driver.api.core.type.codec.ExtraTypeCodecs;
import com.datastax.oss.driver.api.core.type.codec.MappingCodec;
import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public class PersistentZonedTimestampCodec
extends MappingCodec<TupleValue, ZonedDateTime> {
    private static final TupleType CQL_TYPE = DataTypes.tupleOf(DataTypes.TIMESTAMP, DataTypes.TEXT);

    public PersistentZonedTimestampCodec() {
        super(TypeCodecs.tupleOf(CQL_TYPE), GenericType.ZONED_DATE_TIME);
    }

    @Override
    public boolean accepts(@NonNull Object value) {
        Objects.requireNonNull(value);
        return value instanceof ZonedDateTime;
    }

    @Override
    @NonNull
    public TupleType getCqlType() {
        return CQL_TYPE;
    }

    @Override
    @NonNull
    public String format(@Nullable ZonedDateTime value) {
        if (value == null) {
            return "NULL";
        }
        return "(" + ExtraTypeCodecs.TIMESTAMP_UTC.format(value.toInstant()) + "," + TypeCodecs.TEXT.format(value.getZone().toString()) + ")";
    }

    @Override
    @Nullable
    protected ZonedDateTime innerToOuter(@Nullable TupleValue value) {
        if (value == null) {
            return null;
        }
        Instant instant = Objects.requireNonNull(value.getInstant(0));
        ZoneId zoneId = ZoneId.of(Objects.requireNonNull(value.getString(1)));
        return ZonedDateTime.ofInstant(instant, zoneId);
    }

    @Override
    @Nullable
    protected TupleValue outerToInner(@Nullable ZonedDateTime value) {
        if (value == null) {
            return null;
        }
        Instant instant = value.toInstant();
        String zoneId = value.getZone().toString();
        return this.getCqlType().newValue(instant, zoneId);
    }
}

