/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.resultset;

import java.util.HashSet;
import java.util.Set;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.LangBuilder;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.resultset.ResultSetReaderRegistry;
import org.apache.jena.riot.resultset.ResultSetWriterRegistry;
import org.apache.jena.riot.rowset.RowSetReaderRegistry;
import org.apache.jena.riot.rowset.RowSetWriterRegistry;

public class ResultSetLang {
    public static final Lang RS_XML = LangBuilder.create("SPARQL-Results-XML", "application/sparql-results+xml").addAltNames("SRX").addFileExtensions("srx").build();
    public static final Lang RS_JSON = LangBuilder.create("SPARQL-Results-JSON", "application/sparql-results+json").addAltNames("SRJ").addFileExtensions("srj").build();
    public static final Lang RS_CSV = Lang.CSV;
    public static final Lang RS_TSV = Lang.TSV;
    public static final Lang RS_Thrift = LangBuilder.create("SPARQL-Results-Thrift", "application/sparql-results+thrift").addAltNames("SRT").addFileExtensions("srt").build();
    public static final Lang RS_Protobuf = LangBuilder.create("SPARQL-Results-Protobuf", "application/sparql-results+protobuf").addAltNames("SRP").addFileExtensions("srp").build();
    public static final Lang RS_Text = LangBuilder.create("SPARQL-Results-Text", "text/plain").addFileExtensions("txt").build();
    public static final Lang RS_None = LangBuilder.create("SPARQL-Results-None", "application/sparql-results+none").build();
    private static boolean initialized = false;
    private static Set<Lang> registered = new HashSet<Lang>();

    private ResultSetLang() {
    }

    public static void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        ResultSetLang.registerResultSetLang(RS_XML);
        ResultSetLang.registerResultSetLang(RS_JSON);
        ResultSetLang.registerResultSetLang(RS_CSV);
        ResultSetLang.registerResultSetLang(RS_TSV);
        ResultSetLang.registerResultSetLang(RS_Thrift);
        ResultSetLang.registerResultSetLang(RS_Protobuf);
        ResultSetLang.registerResultSetLang(RS_None);
        RowSetReaderRegistry.init();
        RowSetWriterRegistry.init();
        ResultSetReaderRegistry.init();
        ResultSetWriterRegistry.init();
        registered = Set.copyOf(registered);
    }

    public static boolean isRegistered(Lang lang) {
        return registered.contains(lang);
    }

    private static void registerResultSetLang(Lang rsLang) {
        registered.add(rsLang);
        RDFLanguages.register(rsLang);
    }
}

