/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Matches;
import org.apache.lucene.search.MatchesIterator;
import org.apache.lucene.search.MatchesUtils;
import org.apache.lucene.search.PhraseMatcher;
import org.apache.lucene.search.PhraseScorer;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.similarities.Similarity;

public abstract class PhraseWeight
extends Weight {
    final ScoreMode scoreMode;
    final Similarity.SimScorer stats;
    final Similarity similarity;
    final String field;

    protected PhraseWeight(Query query2, String field, IndexSearcher searcher, ScoreMode scoreMode) throws IOException {
        super(query2);
        this.scoreMode = scoreMode;
        this.field = field;
        this.similarity = searcher.getSimilarity();
        Similarity.SimScorer stats = this.getStats(searcher);
        if (stats == null) {
            stats = new Similarity.SimScorer(this){

                @Override
                public float score(float freq, long norm) {
                    return 1.0f;
                }
            };
        }
        this.stats = stats;
    }

    protected abstract Similarity.SimScorer getStats(IndexSearcher var1) throws IOException;

    protected abstract PhraseMatcher getPhraseMatcher(LeafReaderContext var1, Similarity.SimScorer var2, boolean var3) throws IOException;

    @Override
    public ScorerSupplier scorerSupplier(LeafReaderContext context2) throws IOException {
        PhraseMatcher matcher = this.getPhraseMatcher(context2, this.stats, false);
        if (matcher == null) {
            return null;
        }
        NumericDocValues norms = this.scoreMode.needsScores() ? context2.reader().getNormValues(this.field) : null;
        PhraseScorer scorer = new PhraseScorer(matcher, this.scoreMode, this.stats, norms);
        return new Weight.DefaultScorerSupplier(scorer);
    }

    @Override
    public Explanation explain(LeafReaderContext context2, int doc) throws IOException {
        PhraseMatcher matcher = this.getPhraseMatcher(context2, this.stats, false);
        if (matcher == null || matcher.approximation().advance(doc) != doc) {
            return Explanation.noMatch("no matching terms", new Explanation[0]);
        }
        matcher.reset();
        if (!matcher.nextMatch()) {
            return Explanation.noMatch("no matching phrase", new Explanation[0]);
        }
        float freq = matcher.sloppyWeight();
        while (matcher.nextMatch()) {
            freq += matcher.sloppyWeight();
        }
        Explanation freqExplanation = Explanation.match((Number)Float.valueOf(freq), "phraseFreq=" + freq, new Explanation[0]);
        NumericDocValues norms = this.scoreMode.needsScores() ? context2.reader().getNormValues(this.field) : null;
        long norm = 1L;
        if (norms != null && norms.advanceExact(doc)) {
            norm = norms.longValue();
        }
        Explanation scoreExplanation = this.stats.explain(freqExplanation, norm);
        return Explanation.match(scoreExplanation.getValue(), "weight(" + String.valueOf(this.getQuery()) + " in " + doc + ") [" + this.similarity.getClass().getSimpleName() + "], result of:", scoreExplanation);
    }

    @Override
    public Matches matches(LeafReaderContext context2, int doc) throws IOException {
        return MatchesUtils.forField(this.field, () -> {
            final PhraseMatcher matcher = this.getPhraseMatcher(context2, this.stats, true);
            if (matcher == null || matcher.approximation().advance(doc) != doc) {
                return null;
            }
            matcher.reset();
            if (!matcher.nextMatch()) {
                return null;
            }
            return new MatchesIterator(){
                boolean started = false;

                @Override
                public boolean next() throws IOException {
                    if (!this.started) {
                        this.started = true;
                        return true;
                    }
                    return matcher.nextMatch();
                }

                @Override
                public int startPosition() {
                    return matcher.startPosition();
                }

                @Override
                public int endPosition() {
                    return matcher.endPosition();
                }

                @Override
                public int startOffset() throws IOException {
                    return matcher.startOffset();
                }

                @Override
                public int endOffset() throws IOException {
                    return matcher.endOffset();
                }

                @Override
                public MatchesIterator getSubMatches() throws IOException {
                    return null;
                }

                @Override
                public Query getQuery() {
                    return PhraseWeight.this.getQuery();
                }
            };
        });
    }

    @Override
    public boolean isCacheable(LeafReaderContext ctx) {
        return true;
    }
}

