/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.geom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleSegment;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.observable.collections.list.ObservableList;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.algorithms.AdaptiveResampler;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.commons.values.Colors;
import org.jetbrains.letsPlot.core.commons.data.SeriesUtil;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.Aesthetics;
import org.jetbrains.letsPlot.core.plot.base.CoordinateSystem;
import org.jetbrains.letsPlot.core.plot.base.DataPointAesthetics;
import org.jetbrains.letsPlot.core.plot.base.GeomContext;
import org.jetbrains.letsPlot.core.plot.base.PlotContext;
import org.jetbrains.letsPlot.core.plot.base.PositionAdjustment;
import org.jetbrains.letsPlot.core.plot.base.aes.AesScaling;
import org.jetbrains.letsPlot.core.plot.base.aes.AestheticsUtil;
import org.jetbrains.letsPlot.core.plot.base.annotations.Annotations;
import org.jetbrains.letsPlot.core.plot.base.geom.GeomBase;
import org.jetbrains.letsPlot.core.plot.base.geom.WithHeight;
import org.jetbrains.letsPlot.core.plot.base.geom.WithWidth;
import org.jetbrains.letsPlot.core.plot.base.geom.util.AnnotationsUtil;
import org.jetbrains.letsPlot.core.plot.base.geom.util.GeomHelper;
import org.jetbrains.letsPlot.core.plot.base.geom.util.GeomUtil;
import org.jetbrains.letsPlot.core.plot.base.geom.util.HintColorUtil;
import org.jetbrains.letsPlot.core.plot.base.render.LegendKeyElementFactory;
import org.jetbrains.letsPlot.core.plot.base.render.SvgRoot;
import org.jetbrains.letsPlot.core.plot.base.render.svg.LinePath;
import org.jetbrains.letsPlot.core.plot.base.tooltip.GeomTargetCollector;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgCircleElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgGElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgLineElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgNode;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgPathDataBuilder;
import org.jetbrains.letsPlot.datamodel.svg.style.TextStyle;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00c8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \\2\u00020\u00012\u00020\u00022\u00020\u0003:\u0004\\]^_B\u0005\u00a2\u0006\u0002\u0010\u0004J*\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0010\u0010(\u001a\f\u0012\b\u0012\u00060*R\u00020\u00000)2\u0006\u0010+\u001a\u00020,H\u0002J\u001c\u0010-\u001a\u00020%2\n\u0010.\u001a\u00060*R\u00020\u00002\u0006\u0010/\u001a\u000200H\u0002J0\u00101\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u0002072\u0006\u0010+\u001a\u00020,H\u0014J\u0014\u00108\u001a\u0002092\n\u0010.\u001a\u00060*R\u00020\u0000H\u0002J\u0014\u0010:\u001a\u0002092\n\u0010.\u001a\u00060*R\u00020\u0000H\u0002J0\u0010;\u001a\b\u0012\u0004\u0012\u0002090)2\u0010\u0010<\u001a\f\u0012\b\u0012\u00060*R\u00020\u00000)2\u0006\u0010=\u001a\u00020\u00062\u0006\u0010>\u001a\u00020\u0016H\u0002J>\u0010?\u001a\f\u0012\b\u0012\u00060*R\u00020\u00000)2\f\u0010@\u001a\b\u0012\u0004\u0012\u00020A0)2\u0014\u0010B\u001a\u0010\u0012\u0004\u0012\u00020A\u0012\u0006\u0012\u0004\u0018\u00010D0C2\u0006\u0010E\u001a\u00020\u0006H\u0002J \u0010F\u001a\u0004\u0018\u00010G2\u0006\u0010H\u001a\u00020A2\f\u0010I\u001a\b\u0012\u0004\u0012\u00020\u00060JH\u0002JH\u0010K\u001a\u00020L2\n\u0010.\u001a\u00060*R\u00020\u00002\u0006\u0010M\u001a\u00020N2\u0018\u0010O\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020A\u0012\u0004\u0012\u00020D0P2\u0006\u0010Q\u001a\u00020\u00062\b\u0010R\u001a\u0004\u0018\u00010SH\u0002J0\u0010T\u001a\u0004\u0018\u00010G2\u0006\u0010H\u001a\u00020A2\f\u0010I\u001a\b\u0012\u0004\u0012\u00020\u00060J2\u0006\u0010U\u001a\u00020\u00062\u0006\u0010V\u001a\u00020WH\u0016J0\u0010X\u001a\u0004\u0018\u00010G2\u0006\u0010H\u001a\u00020A2\f\u0010I\u001a\b\u0012\u0004\u0012\u00020\u00060J2\u0006\u0010U\u001a\u00020\u00062\u0006\u0010V\u001a\u00020WH\u0016J\u0018\u0010Y\u001a\u00020%*\u00020Z2\n\u0010.\u001a\u00060*R\u00020\u0000H\u0002J\u0018\u0010[\u001a\u00020%*\u00020Z2\n\u0010.\u001a\u00060*R\u00020\u0000H\u0002R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\b\"\u0004\b\u001d\u0010\nR\u001a\u0010\u001e\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#\u00a8\u0006`"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/PieGeom;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/GeomBase;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/WithWidth;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/WithHeight;", "()V", "holeSize", "", "getHoleSize", "()D", "setHoleSize", "(D)V", "legendKeyElementFactory", "Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "getLegendKeyElementFactory", "()Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "sizeUnit", "", "getSizeUnit", "()Ljava/lang/String;", "setSizeUnit", "(Ljava/lang/String;)V", "spacerColor", "Lorg/jetbrains/letsPlot/commons/values/Color;", "getSpacerColor", "()Lorg/jetbrains/letsPlot/commons/values/Color;", "setSpacerColor", "(Lorg/jetbrains/letsPlot/commons/values/Color;)V", "spacerWidth", "getSpacerWidth", "setSpacerWidth", "strokeSide", "Lorg/jetbrains/letsPlot/core/plot/base/geom/PieGeom$StrokeSide;", "getStrokeSide", "()Lorg/jetbrains/letsPlot/core/plot/base/geom/PieGeom$StrokeSide;", "setStrokeSide", "(Lorg/jetbrains/letsPlot/core/plot/base/geom/PieGeom$StrokeSide;)V", "buildAnnotations", "", "root", "Lorg/jetbrains/letsPlot/core/plot/base/render/SvgRoot;", "sectors", "", "Lorg/jetbrains/letsPlot/core/plot/base/geom/PieGeom$Sector;", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;", "buildHint", "sector", "targetCollector", "Lorg/jetbrains/letsPlot/core/plot/base/tooltip/GeomTargetCollector;", "buildIntern", "aesthetics", "Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;", "pos", "Lorg/jetbrains/letsPlot/core/plot/base/PositionAdjustment;", "coord", "Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "buildSvgArcs", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/LinePath;", "buildSvgSector", "buildSvgSpacerLines", "pieSectors", "width", "color", "computeSectors", "dataPoints", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "toLocation", "Lkotlin/Function1;", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "sizeUnitRatio", "dimensionSpan", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "p", "coordAes", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "getAnnotationLabel", "Lorg/jetbrains/letsPlot/core/plot/base/geom/PieGeom$Companion$AnnotationLabel;", "annotations", "Lorg/jetbrains/letsPlot/core/plot/base/annotations/Annotations;", "textSizeGetter", "Lkotlin/Function2;", "offsetForPointer", "plotContext", "Lorg/jetbrains/letsPlot/core/plot/base/PlotContext;", "heightSpan", "resolution", "isDiscrete", "", "widthSpan", "svgInnerArc", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgPathDataBuilder;", "svgOuterArc", "Companion", "PieLegendKeyElementFactory", "Sector", "StrokeSide", "plot-base"})
@SourceDebugExtension(value={"SMAP\nPieGeom.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PieGeom.kt\norg/jetbrains/letsPlot/core/plot/base/geom/PieGeom\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,641:1\n1477#2:642\n1502#2,3:643\n1505#2,3:653\n1549#2:657\n1620#2,3:658\n1549#2:661\n1620#2,3:662\n1855#2,2:665\n1569#2,11:669\n1864#2,2:680\n1866#2:683\n1580#2:684\n1559#2:685\n1590#2,4:686\n1603#2,9:690\n1855#2:699\n1856#2:701\n1612#2:702\n1549#2:703\n1620#2,3:704\n766#2:707\n857#2,2:708\n766#2:710\n857#2,2:711\n1940#2,14:713\n1940#2,14:727\n1549#2:741\n1620#2,3:742\n1855#2,2:745\n1360#2:747\n1446#2,5:748\n1726#2,3:753\n372#3,7:646\n215#4:656\n216#4:668\n1#5:667\n1#5:682\n1#5:700\n*S KotlinDebug\n*F\n+ 1 PieGeom.kt\norg/jetbrains/letsPlot/core/plot/base/geom/PieGeom\n*L\n60#1:642\n60#1:643,3\n60#1:653,3\n69#1:657\n69#1:658,3\n70#1:661\n70#1:662,3\n77#1:665,2\n164#1:669,11\n164#1:680,2\n164#1:683\n164#1:684\n180#1:685\n180#1:686,4\n244#1:690,9\n244#1:699\n244#1:701\n244#1:702\n348#1:703\n348#1:704,3\n352#1:707\n352#1:708,2\n355#1:710\n355#1:711,2\n364#1:713,14\n366#1:727,14\n367#1:741\n367#1:742,3\n386#1:745,2\n416#1:747\n416#1:748,5\n416#1:753,3\n60#1:646,7\n61#1:656\n61#1:668\n164#1:682\n244#1:700\n*E\n"})
public final class PieGeom
extends GeomBase
implements WithWidth,
WithHeight {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private double holeSize;
    private double spacerWidth = 0.75;
    @NotNull
    private Color spacerColor = Color.Companion.getWHITE();
    @NotNull
    private StrokeSide strokeSide = StrokeSide.BOTH;
    @Nullable
    private String sizeUnit;
    public static final boolean HANDLES_GROUPS = false;
    private static final double INTERVAL_BETWEEN_ANNOTATIONS = 4.0;

    public final double getHoleSize() {
        return this.holeSize;
    }

    public final void setHoleSize(double d) {
        this.holeSize = d;
    }

    public final double getSpacerWidth() {
        return this.spacerWidth;
    }

    public final void setSpacerWidth(double d) {
        this.spacerWidth = d;
    }

    @NotNull
    public final Color getSpacerColor() {
        return this.spacerColor;
    }

    public final void setSpacerColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"<set-?>");
        this.spacerColor = color;
    }

    @NotNull
    public final StrokeSide getStrokeSide() {
        return this.strokeSide;
    }

    public final void setStrokeSide(@NotNull StrokeSide strokeSide) {
        Intrinsics.checkNotNullParameter((Object)((Object)strokeSide), (String)"<set-?>");
        this.strokeSide = strokeSide;
    }

    @Nullable
    public final String getSizeUnit() {
        return this.sizeUnit;
    }

    public final void setSizeUnit(@Nullable String string) {
        this.sizeUnit = string;
    }

    @Override
    @NotNull
    public LegendKeyElementFactory getLegendKeyElementFactory() {
        return new PieLegendKeyElementFactory();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void buildIntern(@NotNull SvgRoot root, @NotNull Aesthetics aesthetics2, @NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx) {
        void $this$forEach$iv;
        Object value$iv$iv$iv;
        void $this$groupByTo$iv$iv;
        Map $this$groupBy$iv;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)aesthetics2, (String)"aesthetics");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        GeomHelper geomHelper = new GeomHelper(pos, coord, ctx);
        Iterable<DataPointAesthetics> iterable = GeomUtil.INSTANCE.withDefined(aesthetics2.dataPoints(), Aes.Companion.getX(), Aes.Companion.getY(), Aes.Companion.getSLICE());
        boolean $i$f$groupBy = false;
        Iterator iterator = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            DataPointAesthetics p = (DataPointAesthetics)element$iv$iv;
            boolean bl = false;
            Double d = p.x();
            Intrinsics.checkNotNull((Object)d);
            double d2 = d;
            Double d3 = p.y();
            Intrinsics.checkNotNull((Object)d3);
            DoubleVector key$iv$iv = new DoubleVector(d2, d3.doubleValue());
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Sector p0;
            Collection<LinePath> collection;
            Object item$iv$iv;
            Object $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            double d;
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            DoubleVector point = (DoubleVector)entry.getKey();
            List dataPoints2 = (List)entry.getValue();
            if (this.sizeUnit == null) {
                d = 1.0;
            } else {
                String string = this.sizeUnit;
                Intrinsics.checkNotNull((Object)string);
                d = PieGeom.Companion.getSizeUnitRatio(point, coord, string);
            }
            double sizeUnitRatio = d;
            Function1 toLocation2 = (Function1)new Function1<DataPointAesthetics, DoubleVector>(geomHelper, point){
                final /* synthetic */ GeomHelper $geomHelper;
                final /* synthetic */ DoubleVector $point;
                {
                    this.$geomHelper = $geomHelper;
                    this.$point = $point;
                    super(1);
                }

                @Nullable
                public final DoubleVector invoke(@NotNull DataPointAesthetics p) {
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    return this.$geomHelper.toClient(this.$point, p);
                }
            };
            List<Sector> pieSectors = this.computeSectors(dataPoints2, (Function1<? super DataPointAesthetics, DoubleVector>)toLocation2, sizeUnitRatio);
            value$iv$iv$iv = pieSectors;
            SvgRoot svgRoot = root;
            GeomBase.Companion companion = GeomBase.Companion;
            boolean $i$f$map = false;
            void var23_28 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                item$iv$iv = iterator2.next();
                Sector sector = (Sector)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl3 = false;
                collection.add(this.buildSvgSector(p0));
            }
            collection = (List)destination$iv$iv2;
            companion.appendNodes(svgRoot, (List<LinePath>)collection);
            $this$map$iv = pieSectors;
            svgRoot = root;
            companion = GeomBase.Companion;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                item$iv$iv = iterator2.next();
                p0 = (Sector)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl4 = false;
                collection.add(this.buildSvgArcs(p0));
            }
            collection = (List)destination$iv$iv2;
            companion.appendNodes(svgRoot, (List<LinePath>)collection);
            if (this.spacerWidth > 0.0) {
                GeomBase.Companion.appendNodes(root, this.buildSvgSpacerLines(pieSectors, this.spacerWidth, this.spacerColor));
            }
            Iterable $this$forEach$iv2 = pieSectors;
            boolean $i$f$forEach2 = false;
            $this$mapTo$iv$iv = $this$forEach$iv2.iterator();
            while ($this$mapTo$iv$iv.hasNext()) {
                Object element$iv2 = $this$mapTo$iv$iv.next();
                Sector it = (Sector)element$iv2;
                boolean bl5 = false;
                this.buildHint(it, ctx.getTargetCollector());
            }
            if (ctx.getAnnotations() == null) continue;
            boolean bl6 = false;
            this.buildAnnotations(root, pieSectors, ctx);
        }
    }

    private final void svgOuterArc(SvgPathDataBuilder $this$svgOuterArc, Sector sector) {
        Sector $this$svgOuterArc_u24lambda_u245 = sector;
        boolean bl = false;
        $this$svgOuterArc.ellipticalArc($this$svgOuterArc_u24lambda_u245.getRadius(), $this$svgOuterArc_u24lambda_u245.getRadius(), 0.0, $this$svgOuterArc_u24lambda_u245.getAngle() > Math.PI, true, $this$svgOuterArc_u24lambda_u245.getOuterArcEnd());
    }

    private final void svgInnerArc(SvgPathDataBuilder $this$svgInnerArc, Sector sector) {
        Sector $this$svgInnerArc_u24lambda_u246 = sector;
        boolean bl = false;
        $this$svgInnerArc.ellipticalArc($this$svgInnerArc_u24lambda_u246.getHoleRadius(), $this$svgInnerArc_u24lambda_u246.getHoleRadius(), 0.0, $this$svgInnerArc_u24lambda_u246.getAngle() > Math.PI, false, $this$svgInnerArc_u24lambda_u246.getInnerArcStart());
    }

    private final LinePath buildSvgSector(Sector sector) {
        Object object = new SvgPathDataBuilder(false, 1, null);
        SvgPathDataBuilder $this$buildSvgSector_u24lambda_u247 = object;
        boolean bl = false;
        $this$buildSvgSector_u24lambda_u247.moveTo(sector.getInnerArcStart());
        $this$buildSvgSector_u24lambda_u247.lineTo(sector.getOuterArcStart());
        this.svgOuterArc($this$buildSvgSector_u24lambda_u247, sector);
        $this$buildSvgSector_u24lambda_u247.lineTo(sector.getInnerArcEnd());
        this.svgInnerArc($this$buildSvgSector_u24lambda_u247, sector);
        SvgPathDataBuilder svgPathDataBuilder = object;
        Object $this$buildSvgSector_u24lambda_u248 = object = new LinePath(svgPathDataBuilder);
        boolean bl2 = false;
        Color color = sector.getP().fill();
        Intrinsics.checkNotNull((Object)color);
        Color fill = color;
        double fillAlpha = AestheticsUtil.INSTANCE.alpha(fill, sector.getP());
        ((LinePath)$this$buildSvgSector_u24lambda_u248).fill().set((Object)Colors.INSTANCE.withOpacity(fill, fillAlpha));
        return object;
    }

    private final LinePath buildSvgArcs(Sector sector) {
        Object object = new SvgPathDataBuilder(false, 1, null);
        SvgPathDataBuilder $this$buildSvgArcs_u24lambda_u249 = object;
        boolean bl = false;
        if (this.strokeSide.getHasOuter()) {
            $this$buildSvgArcs_u24lambda_u249.moveTo(sector.getOuterArcStart());
            this.svgOuterArc($this$buildSvgArcs_u24lambda_u249, sector);
        }
        if (this.strokeSide.getHasInner()) {
            $this$buildSvgArcs_u24lambda_u249.moveTo(sector.getInnerArcEnd());
            this.svgInnerArc($this$buildSvgArcs_u24lambda_u249, sector);
        }
        SvgPathDataBuilder svgPathDataBuilder = object;
        Object $this$buildSvgArcs_u24lambda_u2410 = object = new LinePath(svgPathDataBuilder);
        boolean bl2 = false;
        ((LinePath)$this$buildSvgArcs_u24lambda_u2410).width().set((Object)sector.getStrokeWidth());
        ((LinePath)$this$buildSvgArcs_u24lambda_u2410).color().set((Object)sector.getP().color());
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final List<LinePath> buildSvgSpacerLines(List<Sector> pieSectors, double width2, Color color) {
        void $this$mapIndexedTo$iv$iv;
        int n;
        Iterable $this$mapIndexedNotNullTo$iv$iv;
        Iterable $this$mapIndexedNotNull$iv = pieSectors;
        boolean $i$f$mapIndexedNotNull = false;
        Iterable iterable = $this$mapIndexedNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapIndexedNotNullTo = false;
        void $this$forEachIndexed$iv$iv$iv = $this$mapIndexedNotNullTo$iv$iv;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv$iv = 0;
        for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
            Integer it$iv$iv;
            void sector;
            void element$iv$iv;
            if ((n = index$iv$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv$iv$iv;
            int index$iv$iv = n;
            boolean bl = false;
            Sector sector2 = (Sector)element$iv$iv;
            int index = index$iv$iv;
            boolean bl2 = false;
            Integer n2 = index;
            int it = ((Number)n2).intValue();
            boolean bl3 = false;
            if ((!Intrinsics.areEqual((Object)sector.getPosition(), (Object)sector.getPieCenter()) ? n2 : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List explodedSectors = (List)destination$iv$iv;
        Iterable $this$mapIndexed$iv = pieSectors;
        boolean $i$f$mapIndexed = false;
        $this$mapIndexedNotNullTo$iv$iv = $this$mapIndexed$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index;
            void sector;
            int n3;
            Object item$iv$iv$iv;
            if ((n3 = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            item$iv$iv$iv = (Sector)item$iv$iv;
            n = n3;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(PieGeom.buildSvgSpacerLines$svgSpacerLines(width2, color, (Sector)sector, PieGeom.buildSvgSpacerLines$needAddAtStart(explodedSectors, pieSectors, (int)index), PieGeom.buildSvgSpacerLines$needAddAtEnd(explodedSectors, pieSectors, (int)index)));
        }
        return (List)destination$iv$iv;
    }

    private final void buildHint(Sector sector, GeomTargetCollector targetCollector) {
        List list2 = CollectionsKt.plus((Collection)PieGeom.buildHint$resampleArc(sector, true), (Iterable)CollectionsKt.reversed((Iterable)PieGeom.buildHint$resampleArc(sector, false)));
        int n = sector.getP().index();
        Color color = sector.getP().fill();
        Intrinsics.checkNotNull((Object)color);
        Double d = sector.getP().alpha();
        Intrinsics.checkNotNull((Object)d);
        GeomTargetCollector.DefaultImpls.addPolygon$default(targetCollector, list2, n, new GeomTargetCollector.TooltipParams(null, null, null, CollectionsKt.listOf((Object)HintColorUtil.INSTANCE.applyAlpha(color, d)), 7, null), null, 8, null);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Sector> computeSectors(List<? extends DataPointAesthetics> dataPoints2, Function1<? super DataPointAesthetics, DoubleVector> toLocation2, double sizeUnitRatio) {
        void $this$mapNotNullTo$iv$iv;
        Iterable iterable = dataPoints2;
        double d = 0.0;
        for (Object t : iterable) {
            void it;
            DataPointAesthetics dataPointAesthetics = (DataPointAesthetics)t;
            double d2 = d;
            boolean bl = false;
            Double d3 = it.slice();
            Intrinsics.checkNotNull((Object)d3);
            double d4 = Math.abs(d3);
            d = d2 + d4;
        }
        double sum = d;
        double currentAngle = 0.0;
        currentAngle = -1.5707963267948966;
        currentAngle -= PieGeom.computeSectors$angle(sum, dataPoints2, (DataPointAesthetics)CollectionsKt.first(dataPoints2));
        Iterable $this$mapNotNull$iv = dataPoints2;
        boolean $i$f$mapNotNull = false;
        Iterable iterable2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Sector sector;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            DataPointAesthetics p = (DataPointAesthetics)element$iv$iv;
            boolean bl2 = false;
            if ((DoubleVector)toLocation2.invoke((Object)p) == null) {
                sector = null;
            } else {
                DoubleVector pieCenter;
                Sector sector2;
                double d5 = currentAngle;
                double d6 = currentAngle + PieGeom.computeSectors$angle(sum, dataPoints2, p);
                Sector sector3 = sector2 = new Sector(this, pieCenter, p, d5, d6, sizeUnitRatio);
                boolean bl3 = false;
                currentAngle = sector3.getEndAngle();
                sector = sector2;
            }
            if (sector == null) continue;
            Sector it$iv$iv = sector;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final void buildAnnotations(SvgRoot root, List<Sector> sectors, GeomContext ctx) {
        void $this$forEach$iv;
        void $this$mapTo$iv$iv;
        Object t;
        Object t2;
        List<Sector> list2;
        void $this$filterTo$iv$iv;
        List<Sector> $this$filter$iv;
        List<Sector> list3;
        Sector it;
        void $this$filterTo$iv$iv2;
        List<Sector> $this$filter$iv2;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Annotations annotations = ctx.getAnnotations();
        if (annotations == null) {
            return;
        }
        Annotations annotations2 = annotations;
        if (sectors.isEmpty()) {
            return;
        }
        Iterable $this$map$iv = sectors;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void p0;
            Sector sector = (Sector)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getPieCenter());
        }
        DoubleVector doubleVector = (DoubleVector)CollectionsKt.singleOrNull((List)CollectionsKt.distinct((Iterable)((List)destination$iv$iv)));
        if (doubleVector == null) {
            return;
        }
        DoubleVector pieCenter = doubleVector;
        $this$map$iv = sectors;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv2 = $this$filter$iv2;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            it = (Sector)element$iv$iv;
            boolean bl = false;
            if (!(it.getOuterArcStart().getX() < pieCenter.getX() || it.getOuterArcEnd().getX() < pieCenter.getX() || it.getSectorCenter().getX() < pieCenter.getX())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv2 = (List)destination$iv$iv;
        if ($this$filter$iv2.isEmpty()) {
            boolean bl = false;
            list3 = sectors;
        } else {
            list3 = $this$filter$iv2;
        }
        List leftSectors = list3;
        Iterable bl = sectors;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Sector it2 = (Sector)element$iv$iv;
            boolean bl2 = false;
            if (!(it2.getOuterArcStart().getX() > pieCenter.getX() || it2.getOuterArcEnd().getX() > pieCenter.getX() || it2.getSectorCenter().getX() > pieCenter.getX())) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        if ($this$filter$iv.isEmpty()) {
            boolean bl3 = false;
            list2 = sectors;
        } else {
            list2 = $this$filter$iv;
        }
        List rightSectors = list2;
        double expand = 20.0;
        Iterator iterator = ((Iterable)leftSectors).iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        it = (Sector)iterator.next();
        boolean bl4 = false;
        double bl2 = it.getPieCenter().getX() - it.getRadius();
        while (iterator.hasNext()) {
            Sector it3 = (Sector)iterator.next();
            $i$a$-minOf-PieGeom$buildAnnotations$leftBorder$1 = false;
            double d = it3.getPieCenter().getX() - it3.getRadius();
            bl2 = Math.min(bl2, d);
        }
        double leftBorder = bl2 - expand;
        Iterator iterator2 = ((Iterable)rightSectors).iterator();
        if (!iterator2.hasNext()) {
            throw new NoSuchElementException();
        }
        Sector it4 = (Sector)iterator2.next();
        boolean bl5 = false;
        double it3 = it4.getPieCenter().getX() + it4.getRadius();
        while (iterator2.hasNext()) {
            Sector it5 = (Sector)iterator2.next();
            $i$a$-maxOf-PieGeom$buildAnnotations$rightBorder$1 = false;
            double d = it5.getPieCenter().getX() + it5.getRadius();
            it3 = Math.max(it3, d);
        }
        double rightBorder = it3 + expand;
        Iterable $this$maxBy$iv = leftSectors;
        boolean $i$f$maxByOrThrow = false;
        Iterator iterator$iv = $this$maxBy$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new NoSuchElementException();
        }
        Object maxElem$iv = iterator$iv.next();
        if (!iterator$iv.hasNext()) {
            t2 = maxElem$iv;
        } else {
            Sector p0 = (Sector)maxElem$iv;
            boolean bl6 = false;
            double maxValue$iv = p0.getRadius();
            do {
                Object e$iv = iterator$iv.next();
                Sector p02 = (Sector)e$iv;
                $i$a$-maxByOrThrow-PieGeom$buildAnnotations$leftMaxOffsetForOuter$1 = false;
                double v$iv = p02.getRadius();
                if (Double.compare(maxValue$iv, v$iv) >= 0) continue;
                maxElem$iv = e$iv;
                maxValue$iv = v$iv;
            } while (iterator$iv.hasNext());
            t2 = maxElem$iv;
        }
        Sector it6 = (Sector)t2;
        boolean bl7 = false;
        double leftMaxOffsetForOuter = it6.getHoleRadius() + 1.2 * (it6.getRadius() - it6.getHoleRadius());
        Iterable $this$maxBy$iv2 = rightSectors;
        boolean $i$f$maxByOrThrow2 = false;
        Iterator iterator$iv2 = $this$maxBy$iv2.iterator();
        if (!iterator$iv2.hasNext()) {
            throw new NoSuchElementException();
        }
        Object maxElem$iv2 = iterator$iv2.next();
        if (!iterator$iv2.hasNext()) {
            t = maxElem$iv2;
        } else {
            Sector p0 = (Sector)maxElem$iv2;
            boolean bl8 = false;
            double maxValue$iv = p0.getRadius();
            do {
                Object e$iv = iterator$iv2.next();
                Sector p03 = (Sector)e$iv;
                $i$a$-maxByOrThrow-PieGeom$buildAnnotations$rightMaxOffsetForOuter$1 = false;
                double v$iv = p03.getRadius();
                if (Double.compare(maxValue$iv, v$iv) >= 0) continue;
                maxElem$iv2 = e$iv;
                maxValue$iv = v$iv;
            } while (iterator$iv2.hasNext());
            t = maxElem$iv2;
        }
        Sector it7 = (Sector)t;
        boolean bl9 = false;
        double rightMaxOffsetForOuter = it7.getHoleRadius() + 1.2 * (it7.getRadius() - it7.getHoleRadius());
        Iterable $this$map$iv2 = sectors;
        boolean $i$f$map2 = false;
        maxElem$iv2 = $this$map$iv2;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void sector;
            Sector sector2 = (Sector)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl10 = false;
            double offsetForPointer = leftSectors.contains(sector) && rightSectors.contains(sector) ? Math.max(leftMaxOffsetForOuter, rightMaxOffsetForOuter) : (leftSectors.contains(sector) ? leftMaxOffsetForOuter : rightMaxOffsetForOuter);
            collection.add(this.getAnnotationLabel((Sector)sector, annotations2, AnnotationsUtil.INSTANCE.textSizeGetter(annotations2.getTextStyle(), ctx), offsetForPointer, ctx.getPlotContext()));
        }
        List annotationLabels = (List)destination$iv$iv3;
        $this$map$iv2 = PieGeom.Companion.createAnnotationElements(pieCenter, annotationLabels, annotations2.getTextStyle(), new DoubleSpan(leftBorder, rightBorder), ctx);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SvgNode p0 = (SvgNode)element$iv;
            boolean bl11 = false;
            root.add(p0);
        }
    }

    private final Companion.AnnotationLabel getAnnotationLabel(Sector sector, Annotations annotations, Function2<? super String, ? super DataPointAesthetics, DoubleVector> textSizeGetter2, double offsetForPointer, PlotContext plotContext) {
        Color color;
        DoubleVector doubleVector;
        boolean canBePlacedInside;
        DoubleVector textSize;
        String text;
        block8: {
            boolean bl;
            Iterator $this$flatMapTo$iv$iv;
            text = annotations.getAnnotationText(sector.getP().index(), plotContext);
            textSize = (DoubleVector)textSizeGetter2.invoke((Object)text, (Object)sector.getP());
            DoubleRectangle textRect = new DoubleRectangle(sector.getSectorCenter().subtract(textSize.mul(0.5)), textSize);
            Iterable $this$flatMap$iv = textRect.getParts();
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            Iterator iterator = $this$flatMapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv$iv = iterator.next();
                DoubleSegment it = (DoubleSegment)element$iv$iv;
                boolean bl2 = false;
                Object[] objectArray = new DoubleVector[]{it.getStart(), it.getEnd()};
                Iterable list$iv$iv = CollectionsKt.listOf((Object[])objectArray);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Iterable $this$all$iv = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    DoubleVector p0 = (DoubleVector)element$iv;
                    boolean bl3 = false;
                    if (PieGeom.getAnnotationLabel$isPointInsideSector(sector, p0)) continue;
                    bl = false;
                    break block8;
                }
                bl = canBePlacedInside = true;
            }
        }
        if (canBePlacedInside) {
            doubleVector = sector.getSectorCenter();
        } else {
            double offset = sector.getHoleRadius() + 0.8 * (sector.getRadius() - sector.getHoleRadius());
            doubleVector = sector.getPosition().add(new DoubleVector(offset * Math.cos(sector.getDirection()), offset * Math.sin(sector.getDirection())));
        }
        DoubleVector pointerLocation = doubleVector;
        Companion.Side side = canBePlacedInside ? Companion.Side.INSIDE : (pointerLocation.getX() < sector.getPieCenter().getX() ? Companion.Side.LEFT : Companion.Side.RIGHT);
        DoubleVector outerPointerCoord = canBePlacedInside ? null : sector.getPosition().add(new DoubleVector(offsetForPointer * Math.cos(sector.getDirection()), offsetForPointer * Math.sin(sector.getDirection())));
        if (side != Companion.Side.INSIDE) {
            color = annotations.getTextStyle().getColor();
        } else {
            Color color2 = sector.getP().fill();
            Intrinsics.checkNotNull((Object)color2);
            color = Colors.INSTANCE.luminance(color2) < 0.5 ? Color.Companion.getWHITE() : Color.Companion.getBLACK();
        }
        Color textColor2 = color;
        return new Companion.AnnotationLabel(text, textSize, pointerLocation, outerPointerCoord, textColor2, side);
    }

    private final DoubleSpan dimensionSpan(DataPointAesthetics p, Aes<Double> coordAes) {
        DoubleSpan doubleSpan;
        Double size;
        Double loc = p.get(coordAes);
        if (SeriesUtil.INSTANCE.allFinite(loc, size = p.get(Aes.Companion.getSIZE()))) {
            Intrinsics.checkNotNull((Object)loc);
            Double d = size;
            Intrinsics.checkNotNull((Object)d);
            double expand = d / 2.0;
            doubleSpan = new DoubleSpan(loc - expand, loc + expand);
        } else {
            doubleSpan = null;
        }
        return doubleSpan;
    }

    @Override
    @Nullable
    public DoubleSpan widthSpan(@NotNull DataPointAesthetics p, @NotNull Aes<Double> coordAes, double resolution, boolean isDiscrete) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter(coordAes, (String)"coordAes");
        if (!isDiscrete) {
            return null;
        }
        return this.dimensionSpan(p, coordAes);
    }

    @Override
    @Nullable
    public DoubleSpan heightSpan(@NotNull DataPointAesthetics p, @NotNull Aes<Double> coordAes, double resolution, boolean isDiscrete) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter(coordAes, (String)"coordAes");
        if (!isDiscrete) {
            return null;
        }
        return this.dimensionSpan(p, coordAes);
    }

    private static final LinePath buildSvgSpacerLines$svgSpacerLines(double $width, Color $color, Sector sector, boolean atStart, boolean atEnd) {
        Object object = new SvgPathDataBuilder(false, 1, null);
        SvgPathDataBuilder $this$buildSvgSpacerLines_u24svgSpacerLines_u24lambda_u2411 = object;
        boolean bl = false;
        if (atStart) {
            $this$buildSvgSpacerLines_u24svgSpacerLines_u24lambda_u2411.moveTo(sector.getInnerStrokeStartPoint());
            $this$buildSvgSpacerLines_u24svgSpacerLines_u24lambda_u2411.lineTo(sector.getOuterStrokeStartPoint());
        }
        if (atEnd) {
            $this$buildSvgSpacerLines_u24svgSpacerLines_u24lambda_u2411.moveTo(sector.getInnerStrokeEndPoint());
            $this$buildSvgSpacerLines_u24svgSpacerLines_u24lambda_u2411.lineTo(sector.getOuterStrokeEndPoint());
        }
        SvgPathDataBuilder svgPathDataBuilder = object;
        Object $this$buildSvgSpacerLines_u24svgSpacerLines_u24lambda_u2412 = object = new LinePath(svgPathDataBuilder);
        boolean bl2 = false;
        ((LinePath)$this$buildSvgSpacerLines_u24svgSpacerLines_u24lambda_u2412).width().set((Object)$width);
        ((LinePath)$this$buildSvgSpacerLines_u24svgSpacerLines_u24lambda_u2412).color().set((Object)$color);
        return object;
    }

    private static final boolean buildSvgSpacerLines$needAddAtStart(List<Integer> explodedSectors, List<Sector> $pieSectors, int index) {
        int n = index;
        return explodedSectors.contains(n) ? false : (n == 0 ? !explodedSectors.contains(CollectionsKt.getLastIndex($pieSectors)) : !explodedSectors.contains(index - 1));
    }

    private static final boolean buildSvgSpacerLines$needAddAtEnd(List<Integer> explodedSectors, List<Sector> $pieSectors, int index) {
        int n = index;
        return explodedSectors.contains(n) ? false : (n == CollectionsKt.getLastIndex($pieSectors) ? !explodedSectors.contains(0) : !explodedSectors.contains(index + 1));
    }

    private static final List<DoubleVector> buildHint$resampleArc(Sector $sector, boolean outerArc) {
        DoubleVector doubleVector;
        DoubleVector doubleVector2;
        Function1 function1;
        boolean bl = outerArc;
        if (bl) {
            function1 = (Function1)new Function1<Double, DoubleVector>($sector){
                final /* synthetic */ Sector $sector;
                {
                    this.$sector = $sector;
                    super(1);
                }

                @NotNull
                public final DoubleVector invoke(double angle) {
                    return this.$sector.outerArcPointWithStroke(angle);
                }
            };
        } else if (!bl) {
            function1 = (Function1)new Function1<Double, DoubleVector>($sector){
                final /* synthetic */ Sector $sector;
                {
                    this.$sector = $sector;
                    super(1);
                }

                @NotNull
                public final DoubleVector invoke(double angle) {
                    return this.$sector.innerArcPointWithStroke(angle);
                }
            };
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Function1 arcPoint2 = function1;
        boolean bl2 = outerArc;
        if (bl2) {
            doubleVector2 = $sector.getOuterStrokeStartPoint();
        } else if (!bl2) {
            doubleVector2 = $sector.getInnerStrokeStartPoint();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        DoubleVector startPoint = doubleVector2;
        boolean bl3 = outerArc;
        if (bl3) {
            doubleVector = $sector.getOuterStrokeEndPoint();
        } else if (!bl3) {
            doubleVector = $sector.getInnerStrokeEndPoint();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        DoubleVector endPoint = doubleVector;
        double segmentLength = startPoint.subtract(endPoint).length();
        return AdaptiveResampler.Companion.resample(startPoint, endPoint, 2.0, (Function1)new Function1<DoubleVector, DoubleVector>(startPoint, segmentLength, (Function1<? super Double, DoubleVector>)arcPoint2, $sector){
            final /* synthetic */ DoubleVector $startPoint;
            final /* synthetic */ double $segmentLength;
            final /* synthetic */ Function1<Double, DoubleVector> $arcPoint;
            final /* synthetic */ Sector $sector;
            {
                this.$startPoint = $startPoint;
                this.$segmentLength = $segmentLength;
                this.$arcPoint = $arcPoint;
                this.$sector = $sector;
                super(1);
            }

            @Nullable
            public final DoubleVector invoke(@NotNull DoubleVector p) {
                double ratio;
                Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                double d = ratio = p.subtract(this.$startPoint).length() / this.$segmentLength;
                return !Double.isInfinite(d) && !Double.isNaN(d) ? (DoubleVector)this.$arcPoint.invoke((Object)(this.$sector.getStartAngle() + this.$sector.getAngle() * ratio)) : p;
            }
        });
    }

    private static final double computeSectors$angle(double sum, List<? extends DataPointAesthetics> $dataPoints, DataPointAesthetics p) {
        double d;
        if (sum == 0.0) {
            d = 1.0 / (double)$dataPoints.size();
        } else {
            Double d2 = p.slice();
            Intrinsics.checkNotNull((Object)d2);
            d = Math.abs(d2) / sum;
        }
        double it = d;
        boolean bl = false;
        return Math.PI * 2 * it;
    }

    private static final boolean getAnnotationLabel$isPointInsideSector(Sector $sector, DoubleVector pnt) {
        DoubleVector v = pnt.subtract($sector.getPosition());
        double d = $sector.getHoleRadius();
        double d2 = $sector.getRadius();
        double d3 = v.length();
        if (!(d <= d3 ? d3 <= d2 : false)) {
            return false;
        }
        double it = Math.atan2(v.getY(), v.getX());
        boolean bl = false;
        double angle = (-1.5707963267948966 <= it ? it <= Math.PI : false) && Math.abs($sector.getStartAngle()) > Math.PI ? it - Math.PI * 2 : ((-Math.PI <= it ? it <= -1.5707963267948966 : false) && Math.abs($sector.getEndAngle()) > Math.PI ? it + Math.PI * 2 : it);
        return $sector.getStartAngle() <= angle && angle < $sector.getEndAngle();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0002\u001d\u001eB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J<\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u00122\u0006\u0010\u0013\u001a\u00020\f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/PieGeom$Companion;", "", "()V", "HANDLES_GROUPS", "", "INTERVAL_BETWEEN_ANNOTATIONS", "", "createAnnotationElement", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgGElement;", "label", "Lorg/jetbrains/letsPlot/core/plot/base/geom/PieGeom$Companion$AnnotationLabel;", "textLocation", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "textStyle", "Lorg/jetbrains/letsPlot/datamodel/svg/style/TextStyle;", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;", "createAnnotationElements", "", "pieCenter", "annotationLabels", "xRange", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "getSizeUnitRatio", "p", "coord", "Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "axis", "", "AnnotationLabel", "Side", "plot-base"})
    @SourceDebugExtension(value={"SMAP\nPieGeom.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PieGeom.kt\norg/jetbrains/letsPlot/core/plot/base/geom/PieGeom$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,641:1\n9972#2:642\n10394#2,5:643\n1855#3,2:648\n766#3:650\n857#3,2:651\n1549#3:653\n1620#3,3:654\n766#3:657\n857#3,2:658\n1045#3:661\n1054#3:662\n1549#3:663\n1620#3,3:664\n1#4:660\n*S KotlinDebug\n*F\n+ 1 PieGeom.kt\norg/jetbrains/letsPlot/core/plot/base/geom/PieGeom$Companion\n*L\n548#1:642\n548#1:643,5\n591#1:648,2\n511#1:650\n511#1:651,2\n512#1:653\n512#1:654,3\n516#1:657\n516#1:658,2\n520#1:661\n522#1:662\n536#1:663\n536#1:664,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final double getSizeUnitRatio(DoubleVector p, CoordinateSystem coord, String axis) {
            double d;
            DoubleVector unitSquareSize = coord.unitSize(p);
            String string = axis.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            String string2 = string;
            if (Intrinsics.areEqual((Object)string2, (Object)"x")) {
                d = unitSquareSize.getX();
            } else if (Intrinsics.areEqual((Object)string2, (Object)"y")) {
                d = unitSquareSize.getY();
            } else {
                throw new IllegalStateException(("Size unit value must be either 'x' or 'y', but was " + axis + '.').toString());
            }
            double unitSize = d;
            return unitSize / 10.0;
        }

        /*
         * WARNING - void declaration
         */
        private final List<SvgGElement> createAnnotationElements(DoubleVector pieCenter, List<AnnotationLabel> annotationLabels, TextStyle textStyle, DoubleSpan xRange, GeomContext ctx) {
            void $this$flatMapTo$iv$iv;
            Side[] $this$flatMap$iv = Side.values();
            boolean $i$f$flatMap = false;
            Side[] sideArray = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            int n = ((void)$this$flatMapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void p0 = element$iv$iv = $this$flatMapTo$iv$iv[i];
                boolean bl = false;
                Iterable list$iv$iv = org.jetbrains.letsPlot.core.plot.base.geom.PieGeom$Companion.createAnnotationElements$createForSide(annotationLabels, xRange, textStyle, ctx, pieCenter, (Side)p0);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        private final SvgGElement createAnnotationElement(AnnotationLabel label, DoubleVector textLocation, TextStyle textStyle, GeomContext ctx) {
            void $this$createAnnotationElement_u24lambda_u2410;
            void $this$forEach$iv;
            SvgGElement g = AnnotationsUtil.INSTANCE.createTextElement(label.getText(), textLocation, new AnnotationsUtil.TextParams(textStyle, label.getTextColor(), label.getSide().getHJust(), null, null, null, null, 120, null), ctx);
            if (label.getOuterPointerCoord() == null) {
                return g;
            }
            double startXPos = label.getSide() == Side.LEFT ? textLocation.getX() + 5.0 : textLocation.getX() - 5.0;
            double midXPos = label.getSide() == Side.RIGHT && label.getOuterPointerCoord().getX() > startXPos || label.getSide() == Side.LEFT && label.getOuterPointerCoord().getX() < startXPos ? startXPos : label.getOuterPointerCoord().getX();
            DoubleVector middlePoint = new DoubleVector(midXPos, textLocation.getY());
            SvgLineElement[] svgLineElementArray = new SvgLineElement[]{new SvgLineElement(startXPos, textLocation.getY(), middlePoint.getX(), middlePoint.getY()), new SvgLineElement(middlePoint.getX(), middlePoint.getY(), label.getLocation().getX(), label.getLocation().getY())};
            svgLineElementArray = CollectionsKt.listOf((Object[])svgLineElementArray);
            boolean $i$f$forEach22 = false;
            for (Object element$iv : $this$forEach$iv) {
                SvgLineElement line = (SvgLineElement)element$iv;
                boolean bl = false;
                line.strokeColor().set((Object)label.getTextColor());
                line.strokeWidth().set((Object)0.7);
                g.children().add((Object)line);
            }
            SvgLineElement[] $i$f$forEach22 = svgLineElementArray = new SvgCircleElement(label.getLocation().getX(), label.getLocation().getY(), 1.5);
            ObservableList observableList = g.children();
            boolean bl = false;
            $this$createAnnotationElement_u24lambda_u2410.fillColor().set((Object)label.getTextColor());
            observableList.add((Object)svgLineElementArray);
            return g;
        }

        /*
         * WARNING - void declaration
         */
        private static final List<SvgGElement> createAnnotationElements$createForSide(List<AnnotationLabel> $annotationLabels, DoubleSpan $xRange, TextStyle $textStyle, GeomContext $ctx, DoubleVector $pieCenter, Side side) {
            void $this$mapTo$iv$iv;
            List outsideLabels;
            List list2;
            boolean bl;
            Double d;
            void $this$filterTo$iv$iv;
            if (side == Side.INSIDE) {
                void $this$mapTo$iv$iv2;
                void $this$map$iv;
                AnnotationLabel it;
                void $this$filterTo$iv$iv2;
                Iterable $this$filter$iv;
                Iterable iterable = $annotationLabels;
                boolean $i$f$filter = false;
                void var8_10 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                    it = (AnnotationLabel)element$iv$iv;
                    boolean bl2 = false;
                    if (!(it.getSide() == side)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv2 = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    it = (AnnotationLabel)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(Companion.createAnnotationElement(it, it.getLocation(), $textStyle, $ctx));
                }
                return (List)destination$iv$iv;
            }
            Ref.BooleanRef startFromTheTop = new Ref.BooleanRef();
            Iterable $this$filter$iv = $annotationLabels;
            boolean $i$f$filter = false;
            Iterable $i$f$mapTo = $this$filter$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo22 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                AnnotationLabel it = (AnnotationLabel)element$iv$iv;
                boolean bl4 = false;
                if (!(it.getSide() == side)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List l = (List)destination$iv$iv;
            boolean bl5 = false;
            destination$iv$iv = l;
            Object $i$f$filterTo22 = startFromTheTop;
            Iterator<Object> it = destination$iv$iv.iterator();
            if (!it.hasNext()) {
                d = null;
            } else {
                AnnotationLabel it2 = (AnnotationLabel)it.next();
                boolean bl6 = false;
                double bl4 = it2.getLocation().getY();
                while (it.hasNext()) {
                    AnnotationLabel it3 = (AnnotationLabel)it.next();
                    $i$a$-minOfOrNull-PieGeom$Companion$createAnnotationElements$createForSide$outsideLabels$2$1 = false;
                    double d2 = it3.getLocation().getY();
                    bl4 = Math.min(bl4, d2);
                }
                d = bl4;
            }
            Ref.BooleanRef booleanRef = $i$f$filterTo22;
            if (d != null) {
                void it4;
                double d3 = ((Number)d).doubleValue();
                $i$f$filterTo22 = booleanRef;
                boolean bl7 = false;
                booleanRef = $i$f$filterTo22;
                bl = it4 < $pieCenter.getY();
            } else {
                bl = booleanRef.element = false;
            }
            if (startFromTheTop.element) {
                Iterable $this$sortedBy$iv = l;
                boolean $i$f$sortedBy = false;
                list2 = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a2, T b2) {
                        AnnotationLabel it = (AnnotationLabel)a2;
                        boolean bl = false;
                        Comparable comparable = Double.valueOf(it.getLocation().getY());
                        it = (AnnotationLabel)b2;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Double.valueOf(it.getLocation().getY()));
                    }
                });
            } else {
                Iterable $this$sortedByDescending$iv = l;
                boolean $i$f$sortedByDescending = false;
                list2 = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                    public final int compare(T a2, T b2) {
                        AnnotationLabel it = (AnnotationLabel)b2;
                        boolean bl = false;
                        Comparable comparable = Double.valueOf(it.getLocation().getY());
                        it = (AnnotationLabel)a2;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Double.valueOf(it.getLocation().getY()));
                    }
                });
            }
            if ((outsideLabels = list2).isEmpty()) {
                return CollectionsKt.emptyList();
            }
            double d4 = side == Side.LEFT ? $xRange.getLowerEnd().doubleValue() : $xRange.getUpperEnd().doubleValue();
            DoubleVector doubleVector = ((AnnotationLabel)CollectionsKt.first((List)outsideLabels)).getOuterPointerCoord();
            Intrinsics.checkNotNull((Object)doubleVector);
            DoubleVector startPosition = new DoubleVector(d4, doubleVector.getY());
            double yOffset = 0.0;
            Iterable $this$map$iv = outsideLabels;
            boolean $i$f$map = false;
            $i$f$filterTo22 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void label;
                AnnotationLabel annotationLabel = (AnnotationLabel)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl8 = false;
                DoubleVector loc = startFromTheTop.element ? new DoubleVector(startPosition.getX(), startPosition.getY() + yOffset) : new DoubleVector(startPosition.getX(), startPosition.getY() - yOffset);
                yOffset += label.getTextSize().getY() + 4.0;
                collection.add(Companion.createAnnotationElement((AnnotationLabel)label, loc, $textStyle, $ctx));
            }
            return (List)destination$iv$iv2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u001a\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\tH\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u000bH\u00c6\u0003JG\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010!\u001a\u00020\"H\u00d6\u0001J\t\u0010#\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000e\u00a8\u0006$"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/PieGeom$Companion$AnnotationLabel;", "", "text", "", "textSize", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "location", "outerPointerCoord", "textColor", "Lorg/jetbrains/letsPlot/commons/values/Color;", "side", "Lorg/jetbrains/letsPlot/core/plot/base/geom/PieGeom$Companion$Side;", "(Ljava/lang/String;Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;Lorg/jetbrains/letsPlot/commons/values/Color;Lorg/jetbrains/letsPlot/core/plot/base/geom/PieGeom$Companion$Side;)V", "getLocation", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "getOuterPointerCoord", "getSide", "()Lorg/jetbrains/letsPlot/core/plot/base/geom/PieGeom$Companion$Side;", "getText", "()Ljava/lang/String;", "getTextColor", "()Lorg/jetbrains/letsPlot/commons/values/Color;", "getTextSize", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "", "toString", "plot-base"})
        private static final class AnnotationLabel {
            @NotNull
            private final String text;
            @NotNull
            private final DoubleVector textSize;
            @NotNull
            private final DoubleVector location;
            @Nullable
            private final DoubleVector outerPointerCoord;
            @NotNull
            private final Color textColor;
            @NotNull
            private final Side side;

            public AnnotationLabel(@NotNull String text, @NotNull DoubleVector textSize, @NotNull DoubleVector location2, @Nullable DoubleVector outerPointerCoord, @NotNull Color textColor2, @NotNull Side side) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                Intrinsics.checkNotNullParameter((Object)textSize, (String)"textSize");
                Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
                Intrinsics.checkNotNullParameter((Object)textColor2, (String)"textColor");
                Intrinsics.checkNotNullParameter((Object)((Object)side), (String)"side");
                this.text = text;
                this.textSize = textSize;
                this.location = location2;
                this.outerPointerCoord = outerPointerCoord;
                this.textColor = textColor2;
                this.side = side;
            }

            @NotNull
            public final String getText() {
                return this.text;
            }

            @NotNull
            public final DoubleVector getTextSize() {
                return this.textSize;
            }

            @NotNull
            public final DoubleVector getLocation() {
                return this.location;
            }

            @Nullable
            public final DoubleVector getOuterPointerCoord() {
                return this.outerPointerCoord;
            }

            @NotNull
            public final Color getTextColor() {
                return this.textColor;
            }

            @NotNull
            public final Side getSide() {
                return this.side;
            }

            @NotNull
            public final String component1() {
                return this.text;
            }

            @NotNull
            public final DoubleVector component2() {
                return this.textSize;
            }

            @NotNull
            public final DoubleVector component3() {
                return this.location;
            }

            @Nullable
            public final DoubleVector component4() {
                return this.outerPointerCoord;
            }

            @NotNull
            public final Color component5() {
                return this.textColor;
            }

            @NotNull
            public final Side component6() {
                return this.side;
            }

            @NotNull
            public final AnnotationLabel copy(@NotNull String text, @NotNull DoubleVector textSize, @NotNull DoubleVector location2, @Nullable DoubleVector outerPointerCoord, @NotNull Color textColor2, @NotNull Side side) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                Intrinsics.checkNotNullParameter((Object)textSize, (String)"textSize");
                Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
                Intrinsics.checkNotNullParameter((Object)textColor2, (String)"textColor");
                Intrinsics.checkNotNullParameter((Object)((Object)side), (String)"side");
                return new AnnotationLabel(text, textSize, location2, outerPointerCoord, textColor2, side);
            }

            public static /* synthetic */ AnnotationLabel copy$default(AnnotationLabel annotationLabel, String string, DoubleVector doubleVector, DoubleVector doubleVector2, DoubleVector doubleVector3, Color color, Side side, int n, Object object) {
                if ((n & 1) != 0) {
                    string = annotationLabel.text;
                }
                if ((n & 2) != 0) {
                    doubleVector = annotationLabel.textSize;
                }
                if ((n & 4) != 0) {
                    doubleVector2 = annotationLabel.location;
                }
                if ((n & 8) != 0) {
                    doubleVector3 = annotationLabel.outerPointerCoord;
                }
                if ((n & 0x10) != 0) {
                    color = annotationLabel.textColor;
                }
                if ((n & 0x20) != 0) {
                    side = annotationLabel.side;
                }
                return annotationLabel.copy(string, doubleVector, doubleVector2, doubleVector3, color, side);
            }

            @NotNull
            public String toString() {
                return "AnnotationLabel(text=" + this.text + ", textSize=" + this.textSize + ", location=" + this.location + ", outerPointerCoord=" + this.outerPointerCoord + ", textColor=" + this.textColor + ", side=" + (Object)((Object)this.side) + ')';
            }

            public int hashCode() {
                int result = this.text.hashCode();
                result = result * 31 + this.textSize.hashCode();
                result = result * 31 + this.location.hashCode();
                result = result * 31 + (this.outerPointerCoord == null ? 0 : this.outerPointerCoord.hashCode());
                result = result * 31 + this.textColor.hashCode();
                result = result * 31 + this.side.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof AnnotationLabel)) {
                    return false;
                }
                AnnotationLabel annotationLabel = (AnnotationLabel)other;
                if (!Intrinsics.areEqual((Object)this.text, (Object)annotationLabel.text)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.textSize, (Object)annotationLabel.textSize)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.location, (Object)annotationLabel.location)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.outerPointerCoord, (Object)annotationLabel.outerPointerCoord)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.textColor, (Object)annotationLabel.textColor)) {
                    return false;
                }
                return this.side == annotationLabel.side;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H&j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/PieGeom$Companion$Side;", "", "(Ljava/lang/String;I)V", "getHJust", "", "INSIDE", "LEFT", "RIGHT", "plot-base"})
        private static final abstract class Side
        extends Enum<Side> {
            public static final /* enum */ Side INSIDE = new INSIDE("INSIDE", 0);
            public static final /* enum */ Side LEFT = new LEFT("LEFT", 1);
            public static final /* enum */ Side RIGHT = new RIGHT("RIGHT", 2);
            private static final /* synthetic */ Side[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            private Side() {
            }

            @NotNull
            public abstract String getHJust();

            public static Side[] values() {
                return (Side[])$VALUES.clone();
            }

            public static Side valueOf(String value) {
                return Enum.valueOf(Side.class, value);
            }

            @NotNull
            public static EnumEntries<Side> getEntries() {
                return $ENTRIES;
            }

            public /* synthetic */ Side(String $enum$name, int $enum$ordinal, DefaultConstructorMarker $constructor_marker) {
                this();
            }

            static {
                $VALUES = sideArray = new Side[]{Side.INSIDE, Side.LEFT, Side.RIGHT};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }

            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0016\u00a8\u0006\u0004"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/PieGeom$Companion$Side$INSIDE;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/PieGeom$Companion$Side;", "getHJust", "", "plot-base"})
            static final class INSIDE
            extends Side {
                /*
                 * WARNING - void declaration
                 */
                INSIDE() {
                    void var1_1;
                }

                @Override
                @NotNull
                public String getHJust() {
                    return "middle";
                }
            }

            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0016\u00a8\u0006\u0004"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/PieGeom$Companion$Side$LEFT;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/PieGeom$Companion$Side;", "getHJust", "", "plot-base"})
            static final class LEFT
            extends Side {
                /*
                 * WARNING - void declaration
                 */
                LEFT() {
                    void var1_1;
                }

                @Override
                @NotNull
                public String getHJust() {
                    return "right";
                }
            }

            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0016\u00a8\u0006\u0004"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/PieGeom$Companion$Side$RIGHT;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/PieGeom$Companion$Side;", "getHJust", "", "plot-base"})
            static final class RIGHT
            extends Side {
                /*
                 * WARNING - void declaration
                 */
                RIGHT() {
                    void var1_1;
                }

                @Override
                @NotNull
                public String getHJust() {
                    return "left";
                }
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\f"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/PieGeom$PieLegendKeyElementFactory;", "Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "(Lorg/jetbrains/letsPlot/core/plot/base/geom/PieGeom;)V", "createKeyElement", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgGElement;", "p", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "size", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "minimumKeySize", "shapeSize", "", "plot-base"})
    private final class PieLegendKeyElementFactory
    implements LegendKeyElementFactory {
        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public SvgGElement createKeyElement(@NotNull DataPointAesthetics p, @NotNull DoubleVector size) {
            void $this$createKeyElement_u24lambda_u241_u24lambda_u240;
            SvgCircleElement svgCircleElement;
            SvgGElement svgGElement;
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            Intrinsics.checkNotNullParameter((Object)size, (String)"size");
            SvgGElement $this$createKeyElement_u24lambda_u241 = svgGElement = new SvgGElement();
            boolean bl = false;
            SvgCircleElement svgCircleElement2 = svgCircleElement = new SvgCircleElement(size.getX() / (double)2, size.getY() / (double)2, this.shapeSize(p) / (double)2);
            ObservableList observableList = $this$createKeyElement_u24lambda_u241.children();
            boolean bl2 = false;
            $this$createKeyElement_u24lambda_u241_u24lambda_u240.fillColor().set((Object)p.fill());
            $this$createKeyElement_u24lambda_u241_u24lambda_u240.strokeColor().set((Object)p.color());
            $this$createKeyElement_u24lambda_u241_u24lambda_u240.strokeWidth().set((Object)p.stroke());
            observableList.add((Object)svgCircleElement);
            return svgGElement;
        }

        @Override
        @NotNull
        public DoubleVector minimumKeySize(@NotNull DataPointAesthetics p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            double shapeSize = this.shapeSize(p);
            double size = shapeSize + 4.0;
            return new DoubleVector(size, size);
        }

        private final double shapeSize(DataPointAesthetics p) {
            return AesScaling.INSTANCE.pieDiameter(p);
        }
    }

    /*
     * Exception performing whole class analysis.
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b#\b\u0082\u0004\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\nJ\u0018\u00104\u001a\u00020\u00032\u0006\u0010-\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007H\u0002J\u000e\u00105\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0007J\u000e\u00106\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0007R\u0011\u0010\u000b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u000e\u0010\u0011\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\rR\u0011\u0010\u0017\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0019R\u0011\u0010\u001c\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0019R\u0011\u0010\u001e\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0019R\u0011\u0010 \u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0019R\u0011\u0010\"\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0019R\u0011\u0010$\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0019R\u0011\u0010&\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u0019R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\u0019R\u0011\u0010+\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\u0019R\u0011\u0010-\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\rR\u0011\u0010/\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b0\u0010\u0019R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010\rR\u0011\u00102\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010\r\u00a8\u00067"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/PieGeom$Sector;", "", "pieCenter", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "p", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "startAngle", "", "endAngle", "sizeUnitRatio", "(Lorg/jetbrains/letsPlot/core/plot/base/geom/PieGeom;Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;DDD)V", "angle", "getAngle", "()D", "direction", "getDirection", "getEndAngle", "explode", "fullCircleDrawingFix", "hasVisibleStroke", "", "holeRadius", "getHoleRadius", "innerArcEnd", "getInnerArcEnd", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "innerArcStart", "getInnerArcStart", "innerStrokeEndPoint", "getInnerStrokeEndPoint", "innerStrokeStartPoint", "getInnerStrokeStartPoint", "outerArcEnd", "getOuterArcEnd", "outerArcStart", "getOuterArcStart", "outerStrokeEndPoint", "getOuterStrokeEndPoint", "outerStrokeStartPoint", "getOuterStrokeStartPoint", "getP", "()Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "getPieCenter", "position", "getPosition", "radius", "getRadius", "sectorCenter", "getSectorCenter", "getStartAngle", "strokeWidth", "getStrokeWidth", "arcPoint", "innerArcPointWithStroke", "outerArcPointWithStroke", "plot-base"})
    @SourceDebugExtension(value={"SMAP\nPieGeom.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PieGeom.kt\norg/jetbrains/letsPlot/core/plot/base/geom/PieGeom$Sector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,641:1\n1#2:642\n*E\n"})
    private final class Sector {
        @NotNull
        private final DoubleVector pieCenter;
        @NotNull
        private final DataPointAesthetics p;
        private final double startAngle;
        private final double endAngle;
        private final double angle;
        private final double strokeWidth;
        private final boolean hasVisibleStroke;
        private final double radius;
        private final double holeRadius;
        private final double direction;
        private final double explode;
        @NotNull
        private final DoubleVector position;
        private final double fullCircleDrawingFix;
        @NotNull
        private final DoubleVector outerArcStart;
        @NotNull
        private final DoubleVector outerArcEnd;
        @NotNull
        private final DoubleVector innerArcStart;
        @NotNull
        private final DoubleVector innerArcEnd;
        @NotNull
        private final DoubleVector outerStrokeStartPoint;
        @NotNull
        private final DoubleVector outerStrokeEndPoint;
        @NotNull
        private final DoubleVector innerStrokeStartPoint;
        @NotNull
        private final DoubleVector innerStrokeEndPoint;
        final /* synthetic */ PieGeom this$0;

        /*
         * Unable to fully structure code
         */
        public Sector(@NotNull PieGeom this$0, @NotNull DoubleVector pieCenter, DataPointAesthetics p, double startAngle, double endAngle, double sizeUnitRatio) {
            Intrinsics.checkNotNullParameter((Object)pieCenter, (String)"pieCenter");
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            this.this$0 = this$0;
            super();
            this.pieCenter = pieCenter;
            this.p = p;
            this.startAngle = startAngle;
            this.endAngle = endAngle;
            this.angle = this.endAngle - this.startAngle;
            v0 = this;
            v1 = this.p.stroke();
            if (v1 == null) ** GOTO lbl-1000
            var10_7 = v1;
            var11_8 = ((Number)var10_7).doubleValue();
            var15_9 = v0;
            $i$a$-takeIf-PieGeom$Sector$strokeWidth$1 = false;
            v2 = this.p.color();
            var16_11 = (v2 != null ? v2.getAlpha() == 0 : false) == false;
            v0 = var15_9;
            v1 = var16_11 != false ? var10_7 : null;
            if (v1 != null) {
                v3 = v1;
            } else lbl-1000:
            // 2 sources

            {
                v3 = 0.0;
            }
            v0.strokeWidth = v3;
            this.hasVisibleStroke = this.strokeWidth > 0.0;
            this.radius = sizeUnitRatio * AesScaling.INSTANCE.pieDiameter(this.p) / (double)2;
            this.holeRadius = this.radius * this.this$0.getHoleSize();
            this.direction = this.startAngle + this.angle / (double)2;
            v4 = this;
            v5 = this.p.explode();
            if (v5 != null) {
                var12_13 = ((Number)v5).doubleValue();
                var15_9 = v4;
                $i$a$-let-PieGeom$Sector$explode$1 = false;
                var16_12 = this.radius * it;
                v4 = var15_9;
                v6 = var16_12;
            } else {
                v6 = 0.0;
            }
            v4.explode = v6;
            this.position = this.pieCenter.add(new DoubleVector(this.explode * Math.cos(this.direction), this.explode * Math.sin(this.direction)));
            this.fullCircleDrawingFix = this.angle % 6.283185307179586 == 0.0 != false ? 1.0E-4 : 0.0;
            this.outerArcStart = this.arcPoint(this.radius, this.startAngle);
            this.outerArcEnd = this.arcPoint(this.radius, this.endAngle - this.fullCircleDrawingFix);
            this.innerArcStart = this.arcPoint(this.holeRadius, this.startAngle);
            this.innerArcEnd = this.arcPoint(this.holeRadius, this.endAngle - this.fullCircleDrawingFix);
            this.outerStrokeStartPoint = this.outerArcPointWithStroke(this.startAngle);
            this.outerStrokeEndPoint = this.outerArcPointWithStroke(this.endAngle - this.fullCircleDrawingFix);
            this.innerStrokeStartPoint = this.innerArcPointWithStroke(this.startAngle);
            this.innerStrokeEndPoint = this.innerArcPointWithStroke(this.endAngle - this.fullCircleDrawingFix);
        }

        @NotNull
        public final DoubleVector getPieCenter() {
            return this.pieCenter;
        }

        @NotNull
        public final DataPointAesthetics getP() {
            return this.p;
        }

        public final double getStartAngle() {
            return this.startAngle;
        }

        public final double getEndAngle() {
            return this.endAngle;
        }

        public final double getAngle() {
            return this.angle;
        }

        public final double getStrokeWidth() {
            return this.strokeWidth;
        }

        public final double getRadius() {
            return this.radius;
        }

        public final double getHoleRadius() {
            return this.holeRadius;
        }

        public final double getDirection() {
            return this.direction;
        }

        @NotNull
        public final DoubleVector getPosition() {
            return this.position;
        }

        @NotNull
        public final DoubleVector getOuterArcStart() {
            return this.outerArcStart;
        }

        @NotNull
        public final DoubleVector getOuterArcEnd() {
            return this.outerArcEnd;
        }

        @NotNull
        public final DoubleVector getInnerArcStart() {
            return this.innerArcStart;
        }

        @NotNull
        public final DoubleVector getInnerArcEnd() {
            return this.innerArcEnd;
        }

        @NotNull
        public final DoubleVector getOuterStrokeStartPoint() {
            return this.outerStrokeStartPoint;
        }

        @NotNull
        public final DoubleVector getOuterStrokeEndPoint() {
            return this.outerStrokeEndPoint;
        }

        @NotNull
        public final DoubleVector getInnerStrokeStartPoint() {
            return this.innerStrokeStartPoint;
        }

        @NotNull
        public final DoubleVector getInnerStrokeEndPoint() {
            return this.innerStrokeEndPoint;
        }

        @NotNull
        public final DoubleVector outerArcPointWithStroke(double angle) {
            double d;
            boolean bl;
            boolean bl2 = bl = this.this$0.getStrokeSide().getHasOuter() && this.hasVisibleStroke;
            if (bl) {
                d = this.radius + this.strokeWidth / (double)2;
            } else if (!bl) {
                d = this.radius;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return this.arcPoint(d, angle);
        }

        @NotNull
        public final DoubleVector innerArcPointWithStroke(double angle) {
            double d;
            boolean bl;
            boolean bl2 = bl = this.this$0.getStrokeSide().getHasInner() && this.hasVisibleStroke && this.this$0.getHoleSize() > 0.0;
            if (bl) {
                d = this.holeRadius - this.strokeWidth / (double)2;
            } else if (!bl) {
                d = this.holeRadius;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return this.arcPoint(d, angle);
        }

        private final DoubleVector arcPoint(double radius, double angle) {
            return this.position.add(new DoubleVector(radius * Math.cos(angle), radius * Math.sin(angle)));
        }

        @NotNull
        public final DoubleVector getSectorCenter() {
            double offset = this.holeRadius + 0.5 * (this.radius - this.holeRadius);
            return this.arcPoint(offset, this.direction);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006j\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/PieGeom$StrokeSide;", "", "(Ljava/lang/String;I)V", "hasInner", "", "getHasInner", "()Z", "hasOuter", "getHasOuter", "OUTER", "INNER", "BOTH", "plot-base"})
    public static final class StrokeSide
    extends Enum<StrokeSide> {
        public static final /* enum */ StrokeSide OUTER = new StrokeSide();
        public static final /* enum */ StrokeSide INNER = new StrokeSide();
        public static final /* enum */ StrokeSide BOTH = new StrokeSide();
        private static final /* synthetic */ StrokeSide[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public final boolean getHasOuter() {
            return this == OUTER || this == BOTH;
        }

        public final boolean getHasInner() {
            return this == INNER || this == BOTH;
        }

        public static StrokeSide[] values() {
            return (StrokeSide[])$VALUES.clone();
        }

        public static StrokeSide valueOf(String value) {
            return Enum.valueOf(StrokeSide.class, value);
        }

        @NotNull
        public static EnumEntries<StrokeSide> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = strokeSideArray = new StrokeSide[]{StrokeSide.OUTER, StrokeSide.INNER, StrokeSide.BOTH};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

