/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.java.control.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Arrays;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.apache.jmeter.gui.FilePanelEntryBinding;
import org.apache.jmeter.gui.JBooleanPropertyEditor;
import org.apache.jmeter.gui.JSyntaxTextAreaBinding;
import org.apache.jmeter.gui.JTextComponentBinding;
import org.apache.jmeter.gui.TestElementMetadata;
import org.apache.jmeter.gui.util.FilePanelEntry;
import org.apache.jmeter.gui.util.JSyntaxTextArea;
import org.apache.jmeter.gui.util.JTextScrollPane;
import org.apache.jmeter.protocol.java.sampler.BeanShellSampler;
import org.apache.jmeter.protocol.java.sampler.BeanShellSamplerSchema;
import org.apache.jmeter.samplers.gui.AbstractSamplerGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;

@TestElementMetadata(labelResource="bsh_sampler_title")
public class BeanShellSamplerGui
extends AbstractSamplerGui {
    private static final long serialVersionUID = 240L;
    private final JBooleanPropertyEditor resetInterpreter = new JBooleanPropertyEditor(BeanShellSamplerSchema.INSTANCE.getResetInterpreter(), JMeterUtils.getResString((String)"bsh_script_reset_interpreter"));
    private final FilePanelEntry filename = new FilePanelEntry(JMeterUtils.getResString((String)"bsh_script_file"), new String[]{".bsh"});
    private JTextField parameters;
    private JSyntaxTextArea scriptField;

    public BeanShellSamplerGui() {
        this.init();
        this.bindingGroup.addAll(Arrays.asList(new JSyntaxTextAreaBinding(this.scriptField, BeanShellSamplerSchema.INSTANCE.getScript()), new FilePanelEntryBinding(this.filename, BeanShellSamplerSchema.INSTANCE.getFilename()), new JTextComponentBinding((JTextComponent)this.parameters, BeanShellSamplerSchema.INSTANCE.getParameters()), this.resetInterpreter));
    }

    public TestElement makeTestElement() {
        return new BeanShellSampler();
    }

    public String getLabelResource() {
        return "bsh_sampler_title";
    }

    private JPanel createFilenamePanel() {
        JPanel filenamePanel = new JPanel(new BorderLayout());
        filenamePanel.add((Component)this.filename, "Center");
        return filenamePanel;
    }

    private JPanel createParameterPanel() {
        JLabel label = new JLabel(JMeterUtils.getResString((String)"bsh_script_parameters"));
        this.parameters = new JTextField(10);
        this.parameters.setName(BeanShellSamplerSchema.INSTANCE.getParameters().getName());
        label.setLabelFor(this.parameters);
        JPanel parameterPanel = new JPanel(new BorderLayout(5, 0));
        parameterPanel.add((Component)label, "West");
        parameterPanel.add((Component)this.parameters, "Center");
        return parameterPanel;
    }

    private JPanel createResetPanel() {
        JPanel resetInterpreterPanel = new JPanel(new BorderLayout());
        resetInterpreterPanel.add((Component)this.resetInterpreter, "West");
        return resetInterpreterPanel;
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(this.makeBorder());
        Box box = Box.createVerticalBox();
        box.add(this.makeTitlePanel());
        box.add(this.createResetPanel());
        box.add(this.createParameterPanel());
        box.add(this.createFilenamePanel());
        this.add(box, "North");
        JPanel panel = this.createScriptPanel();
        this.add(panel, "Center");
        this.add(Box.createVerticalStrut(panel.getPreferredSize().height), "West");
    }

    private JPanel createScriptPanel() {
        this.scriptField = JSyntaxTextArea.getInstance((int)20, (int)20);
        JLabel label = new JLabel(JMeterUtils.getResString((String)"bsh_script"));
        label.setLabelFor((Component)this.scriptField);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)label, "North");
        panel.add((Component)JTextScrollPane.getInstance((JSyntaxTextArea)this.scriptField), "Center");
        JTextArea explain = new JTextArea(JMeterUtils.getResString((String)"bsh_script_variables"));
        explain.setLineWrap(true);
        explain.setEditable(false);
        explain.setBackground(this.getBackground());
        panel.add((Component)explain, "South");
        return panel;
    }
}

