/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.htmltowiki.syntax;

import java.io.PrintWriter;
import java.util.Map;
import org.apache.wiki.htmltowiki.XHtmlToWikiConfig;
import org.apache.wiki.htmltowiki.syntax.MarkupHelper;
import org.jdom2.Element;

public abstract class ImageDecorator {
    protected final PrintWriter out;
    protected final XHtmlToWikiConfig config;

    protected ImageDecorator(PrintWriter out, XHtmlToWikiConfig config) {
        this.out = out;
        this.config = config;
    }

    public void decorate(String src, Map<String, Object> imageAttrs) {
        if (imageAttrs.isEmpty()) {
            this.out.print(this.markupImageSimpleOpen() + src + this.markupImageSimpleClose());
        } else {
            this.markupImageWithAttributes(src, imageAttrs);
        }
    }

    public void decorate(Element e) {
        if (this.config.isNotIgnorableWikiMarkupLink(e)) {
            this.out.print(this.markupImageSimpleOpen());
            MarkupHelper.printUnescaped(this.out, this.config.trimLink(e.getAttributeValue("src")));
            this.out.print(this.markupImageSimpleClose());
        }
    }

    protected abstract String markupImageSimpleOpen();

    protected abstract String markupImageSimpleClose();

    protected abstract void markupImageWithAttributes(String var1, Map<String, Object> var2);
}

