/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.util;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wiki.util.URIScheme;

public final class HttpUtil {
    private static final Logger LOG = LogManager.getLogger(HttpUtil.class);
    private static final int ONE = 48;
    private static final int NINE = 57;
    private static final int DOT = 46;

    private HttpUtil() {
    }

    public static String getRemoteAddress(HttpServletRequest req) {
        return StringUtils.isNotEmpty((CharSequence)req.getHeader("X-Forwarded-For")) ? req.getHeader("X-Forwarded-For") : req.getRemoteAddr();
    }

    public static String retrieveCookieValue(HttpServletRequest request, String cookieName) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(cookieName)) continue;
                String value = cookie.getValue();
                if (value == null || value.isEmpty()) {
                    return null;
                }
                if (value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"') {
                    value = value.substring(1, value.length() - 1);
                }
                return value;
            }
        }
        return null;
    }

    public static String createETag(String pageName, Date lastModified) {
        return Long.toString((long)pageName.hashCode() ^ lastModified.getTime());
    }

    public static boolean checkFor304(HttpServletRequest req, String pageName, Date lastModified) {
        block9: {
            if (!"no-cache".equalsIgnoreCase(req.getHeader("Pragma")) && !"no-cache".equalsIgnoreCase(req.getHeader("cache-control"))) {
                String thisTag = HttpUtil.createETag(pageName, lastModified);
                String eTag = req.getHeader("If-None-Match");
                if (eTag != null && eTag.equals(thisTag)) {
                    return true;
                }
                SimpleDateFormat rfcDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
                try {
                    long ifModifiedSince = req.getDateHeader("If-Modified-Since");
                    if (ifModifiedSince != -1L) {
                        long lastModifiedTime = lastModified.getTime();
                        if (lastModifiedTime <= ifModifiedSince) {
                            return true;
                        }
                        break block9;
                    }
                    try {
                        Date ifModifiedSinceDate;
                        String s = req.getHeader("If-Modified-Since");
                        if (s != null && lastModified.before(ifModifiedSinceDate = rfcDateFormat.parse(s))) {
                            return true;
                        }
                    }
                    catch (ParseException e) {
                        LOG.warn(e.getLocalizedMessage(), (Throwable)e);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    public static String guessValidURI(String uri) {
        if (((String)uri).indexOf(64) != -1) {
            if (!((String)uri).startsWith("mailto:")) {
                uri = "mailto:" + (String)uri;
            }
        } else if (HttpUtil.notBeginningWithHttpOrHttps((String)uri)) {
            uri = "http://" + (String)uri;
        }
        return uri;
    }

    static boolean notBeginningWithHttpOrHttps(String uri) {
        return !uri.isEmpty() && !uri.startsWith("http://") && !uri.startsWith("https://");
    }

    public static String safeGetQueryString(HttpServletRequest request, Charset contentEncoding) {
        int pos1;
        if (request == null) {
            return "";
        }
        String res = request.getQueryString();
        if (res != null && (pos1 = (res = new String(res.getBytes(StandardCharsets.ISO_8859_1), contentEncoding)).indexOf("page=")) >= 0) {
            Object tmpRes = res.substring(0, pos1);
            int pos2 = res.indexOf(38, pos1) + 1;
            if (pos2 > 0 && pos2 < res.length()) {
                tmpRes = (String)tmpRes + res.substring(pos2);
            }
            res = tmpRes;
        }
        return res;
    }

    public static boolean isIPV4Address(String name) {
        if (StringUtils.isEmpty((CharSequence)name) || name.charAt(0) == '.' || name.charAt(name.length() - 1) == '.') {
            return false;
        }
        int[] addr = new int[]{0, 0, 0, 0};
        int currentOctet = 0;
        for (int i = 0; i < name.length(); ++i) {
            boolean isDot;
            if (currentOctet > 3) {
                return false;
            }
            char ch = name.charAt(i);
            boolean isDigit = ch >= '0' && ch <= '9';
            boolean bl = isDot = ch == '.';
            if (!isDigit && !isDot) {
                return false;
            }
            if (isDigit) {
                addr[currentOctet] = 10 * addr[currentOctet] + (ch - 48);
                if (addr[currentOctet] <= 255) continue;
                return false;
            }
            if (name.charAt(i - 1) == '.') {
                return false;
            }
            ++currentOctet;
        }
        return currentOctet == 3;
    }

    public static void clearCookie(HttpServletResponse response, String cookieName) {
        Cookie cookie = new Cookie(cookieName, "");
        cookie.setMaxAge(0);
        response.addCookie(cookie);
    }

    public static String getAbsoluteUrl(HttpServletRequest request, String relativeUrl) {
        StringBuilder baseUrl = new StringBuilder();
        String forwardedHost = request.getHeader("X-Forwarded-Host");
        String forwardedProto = request.getHeader("X-Forwarded-Proto");
        String forwardedServer = request.getHeader("X-Forwarded-Server");
        if (forwardedHost != null && forwardedProto != null) {
            baseUrl.append(forwardedProto).append("://").append(forwardedHost);
        } else if (forwardedServer != null && forwardedProto != null) {
            baseUrl.append(forwardedProto).append("://").append(forwardedServer);
        } else {
            String scheme = request.getScheme();
            String serverName = request.getServerName();
            int port = request.getServerPort();
            baseUrl.append(scheme).append("://").append(serverName);
            if (URIScheme.HTTP.same(scheme) && port != 80 || URIScheme.HTTPS.same(scheme) && port != 443) {
                baseUrl.append(':');
                baseUrl.append(port);
            }
        }
        if (relativeUrl != null) {
            baseUrl.append(relativeUrl);
        }
        return baseUrl.toString();
    }

    public static String getAbsoluteUrl(HttpServletRequest request) {
        return HttpUtil.getAbsoluteUrl(request, null);
    }
}

