/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.vars;

import org.apache.juneau.commons.utils.FileUtils;
import org.apache.juneau.http.response.InternalServerError;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.svl.DefaultingVar;
import org.apache.juneau.svl.VarResolverSession;

public class FileVar
extends DefaultingVar {
    public static final String NAME = "F";

    public FileVar() {
        super(NAME);
    }

    public boolean canResolve(VarResolverSession session) {
        return session.getBean(RestRequest.class).isPresent();
    }

    public String resolve(VarResolverSession session, String key) throws Exception {
        RestRequest req = (RestRequest)((Object)session.getBean(RestRequest.class).orElseThrow(InternalServerError::new));
        String s = req.getStaticFiles().getString(key, null).orElse(null);
        if (s == null) {
            return null;
        }
        String subType = FileUtils.getFileExtension((String)key);
        if ("html".equals(subType) || "xhtml".equals(subType) || "xml".equals(subType)) {
            s = s.replaceAll("(?s)<!--(.*?)-->\\s*", "");
        } else if ("json".equals(subType) || "javascript".equals(subType) || "css".equals(subType)) {
            s = s.replaceAll("(?s)\\/\\*(.*?)\\*\\/\\s*", "");
        }
        return s;
    }
}

