/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.assertions;

import java.io.PrintStream;
import java.util.Collection;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.juneau.assertions.Assertion;
import org.apache.juneau.assertions.FluentIntegerAssertion;
import org.apache.juneau.assertions.FluentObjectAssertion;
import org.apache.juneau.assertions.FluentStringListAssertion;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.cp.Messages;

public class FluentCollectionAssertion<E, R>
extends FluentObjectAssertion<Collection<E>, R> {
    private static final Messages MESSAGES = Messages.of(FluentCollectionAssertion.class, "Messages");
    private static final String MSG_collectionWasNotEmpty = MESSAGES.getString("collectionWasNotEmpty");
    private static final String MSG_collectionDidNotContainExpectedValue = MESSAGES.getString("collectionDidNotContainExpectedValue");
    private static final String MSG_collectionDidNotContainTestedValue = MESSAGES.getString("collectionDidNotContainTestedValue");
    private static final String MSG_collectionContainedUnexpectedValue = MESSAGES.getString("collectionContainedUnexpectedValue");
    private static final String MSG_collectionWasEmpty = MESSAGES.getString("collectionWasEmpty");
    private static final String MSG_collectionDidNotHaveExpectedSize = MESSAGES.getString("collectionDidNotHaveExpectedSize");

    public FluentCollectionAssertion(Assertion creator, Collection<E> value, R returns) {
        super(creator, value, returns);
    }

    public FluentCollectionAssertion(Collection<E> value, R returns) {
        this((Assertion)null, value, returns);
    }

    public FluentIntegerAssertion<R> asSize() {
        return new FluentIntegerAssertion((Assertion)this, this.valueIsNull() ? null : Integer.valueOf(((Collection)this.value()).size()), this.returns());
    }

    public FluentStringListAssertion<R> asStrings() {
        return new FluentStringListAssertion((Assertion)this, this.valueIsNull() ? null : ((Collection)this.value()).stream().map((? super T o) -> Utils.s(o)).toList(), this.returns());
    }

    @Override
    public FluentCollectionAssertion<E, R> asTransformed(Function<Collection<E>, Collection<E>> function) {
        return new FluentCollectionAssertion((Assertion)this, function.apply(this.orElse(null)), this.returns());
    }

    public R isAll(Predicate<E> test) throws AssertionError {
        if (test == null) {
            return this.returns();
        }
        ((Collection)this.value()).forEach(x -> {
            if (!test.test(x)) {
                throw this.error(MSG_collectionDidNotContainTestedValue, Utils.r(this.value()));
            }
        });
        return this.returns();
    }

    public R isAny(Predicate<E> test) throws AssertionError {
        if (test == null) {
            return this.returns();
        }
        for (Object v : (Collection)this.value()) {
            if (!test.test(v)) continue;
            return this.returns();
        }
        throw this.error(MSG_collectionDidNotContainTestedValue, Utils.r(this.value()));
    }

    public R isContains(E entry) throws AssertionError {
        for (Object v : (Collection)this.value()) {
            if (!Utils.eq(v, entry)) continue;
            return this.returns();
        }
        throw this.error(MSG_collectionDidNotContainExpectedValue, Utils.r(entry), Utils.r(this.value()));
    }

    public R isEmpty() throws AssertionError {
        if (!((Collection)this.value()).isEmpty()) {
            throw this.error(MSG_collectionWasNotEmpty, new Object[0]);
        }
        return this.returns();
    }

    public R isNotContains(E entry) throws AssertionError {
        ((Collection)this.value()).forEach(x -> {
            if (Utils.eq(x, entry)) {
                throw this.error(MSG_collectionContainedUnexpectedValue, Utils.r(entry), Utils.r(this.value()));
            }
        });
        return this.returns();
    }

    public R isNotEmpty() throws AssertionError {
        if (((Collection)this.value()).isEmpty()) {
            throw this.error(MSG_collectionWasEmpty, new Object[0]);
        }
        return this.returns();
    }

    public R isSize(int size) throws AssertionError {
        if (this.getSize() != size) {
            throw this.error(MSG_collectionDidNotHaveExpectedSize, size, this.getSize());
        }
        return this.returns();
    }

    @Override
    public FluentCollectionAssertion<E, R> setMsg(String msg, Object ... args) {
        super.setMsg(msg, args);
        return this;
    }

    @Override
    public FluentCollectionAssertion<E, R> setOut(PrintStream value) {
        super.setOut(value);
        return this;
    }

    @Override
    public FluentCollectionAssertion<E, R> setSilent() {
        super.setSilent();
        return this;
    }

    @Override
    public FluentCollectionAssertion<E, R> setStdOut() {
        super.setStdOut();
        return this;
    }

    @Override
    public FluentCollectionAssertion<E, R> setThrowable(Class<? extends RuntimeException> value) {
        super.setThrowable((Class)value);
        return this;
    }

    protected int getSize() throws AssertionError {
        return ((Collection)this.value()).size();
    }
}

