/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.command;

import java.net.URI;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.features.Repository;
import org.apache.karaf.features.command.FeaturesCommandSupport;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;

@Command(scope="feature", name="repo-remove", description="Removes the specified repository features service.")
public class RepoRemoveCommand
extends FeaturesCommandSupport {
    @Argument(index=0, name="repository", description="Name or url of the repository to remove.", required=true, multiValued=false)
    private String repository;
    @Option(name="-u", aliases={"--uninstall-all"}, description="Uninstall all features from the repository", required=false, multiValued=false)
    private boolean uninstall;

    @Override
    protected void doExecute(FeaturesService featuresService) throws Exception {
        URI uri = null;
        for (Repository r : featuresService.listRepositories()) {
            if (r.getName() == null || !r.getName().equals(this.repository)) continue;
            uri = r.getURI();
            break;
        }
        if (uri == null) {
            uri = new URI(this.repository);
        }
        featuresService.removeRepository(uri, this.uninstall);
    }
}

