/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.file.virtualfs;

import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.sshd.common.file.FileSystemFactory;
import org.apache.sshd.common.file.root.RootedFileSystemProvider;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.ValidateUtils;

public class VirtualFileSystemFactory
implements FileSystemFactory {
    private Path defaultHomeDir;
    private final Map<String, Path> homeDirs = new ConcurrentHashMap<String, Path>();

    public VirtualFileSystemFactory() {
    }

    public VirtualFileSystemFactory(Path defaultHomeDir) {
        this.defaultHomeDir = defaultHomeDir;
    }

    public void setDefaultHomeDir(Path defaultHomeDir) {
        this.defaultHomeDir = defaultHomeDir;
    }

    public Path getDefaultHomeDir() {
        return this.defaultHomeDir;
    }

    public void setUserHomeDir(String userName, Path userHomeDir) {
        this.homeDirs.put(ValidateUtils.checkNotNullAndNotEmpty(userName, "No username"), Objects.requireNonNull(userHomeDir, "No home dir"));
    }

    public Path getUserHomeDir(String userName) {
        return this.homeDirs.get(ValidateUtils.checkNotNullAndNotEmpty(userName, "No username"));
    }

    @Override
    public Path getUserHomeDir(SessionContext session) throws IOException {
        String username = session.getUsername();
        Path homeDir = this.getUserHomeDir(username);
        if (homeDir == null) {
            homeDir = this.getDefaultHomeDir();
        }
        return homeDir;
    }

    @Override
    public FileSystem createFileSystem(SessionContext session) throws IOException {
        Path dir = this.getUserHomeDir(session);
        if (dir == null) {
            throw new InvalidPathException(session.getUsername(), "Cannot resolve home directory");
        }
        return new RootedFileSystemProvider().newFileSystem(dir, Collections.emptyMap());
    }
}

