/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.crypto;

import java.util.ArrayList;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.opensaml.saml.criterion.RoleDescriptorCriterion;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml.saml2.metadata.SSODescriptor;
import org.opensaml.saml.security.impl.SAMLMetadataSignatureSigningParametersResolver;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.SignatureSigningConfiguration;
import org.opensaml.xmlsec.SignatureSigningParameters;
import org.opensaml.xmlsec.config.DefaultSecurityConfigurationBootstrap;
import org.opensaml.xmlsec.criterion.SignatureSigningConfigurationCriterion;
import org.opensaml.xmlsec.impl.BasicSignatureSigningConfiguration;
import org.pac4j.saml.client.SAML2ClientConfiguration;
import org.pac4j.saml.crypto.CredentialProvider;
import org.pac4j.saml.crypto.SignatureSigningParametersProvider;
import org.pac4j.saml.exceptions.SAMLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSignatureSigningParametersProvider
implements SignatureSigningParametersProvider {
    private static final Logger logger = LoggerFactory.getLogger(DefaultSignatureSigningParametersProvider.class);
    private final CredentialProvider credentialProvider;
    private final SAML2ClientConfiguration configuration;

    public DefaultSignatureSigningParametersProvider(CredentialProvider credentialProvider, SAML2ClientConfiguration configuration) {
        this.credentialProvider = credentialProvider;
        this.configuration = configuration;
    }

    @Override
    public SignatureSigningParameters build(SSODescriptor descriptor) {
        try {
            CriteriaSet criteria = new CriteriaSet();
            criteria.add((Object)new SignatureSigningConfigurationCriterion(new SignatureSigningConfiguration[]{this.getSignatureSigningConfiguration()}));
            criteria.add((Object)new RoleDescriptorCriterion((RoleDescriptor)descriptor));
            SAMLMetadataSignatureSigningParametersResolver resolver = new SAMLMetadataSignatureSigningParametersResolver();
            SignatureSigningParameters params = resolver.resolveSingle(criteria);
            this.augmentSignatureSigningParameters(params);
            if (params == null) {
                throw new SAMLException("Could not determine the signature parameters");
            }
            logger.info("Created signature signing parameters.\nSignature algorithm: {}\nSignature canonicalization algorithm: {}\nSignature reference digest methods: {}", new Object[]{params.getSignatureAlgorithm(), params.getSignatureCanonicalizationAlgorithm(), params.getSignatureReferenceDigestMethod()});
            return params;
        }
        catch (Exception e) {
            throw new SAMLException(e);
        }
    }

    protected SignatureSigningConfiguration getSignatureSigningConfiguration() {
        BasicSignatureSigningConfiguration config = DefaultSecurityConfigurationBootstrap.buildDefaultSignatureSigningConfiguration();
        if (this.configuration.getBlackListedSignatureSigningAlgorithms() != null) {
            config.setBlacklistedAlgorithms(this.configuration.getBlackListedSignatureSigningAlgorithms());
        }
        if (this.configuration.getSignatureAlgorithms() != null) {
            config.setSignatureAlgorithms(this.configuration.getSignatureAlgorithms());
        }
        if (this.configuration.getSignatureCanonicalizationAlgorithm() != null) {
            config.setSignatureCanonicalizationAlgorithm(this.configuration.getSignatureCanonicalizationAlgorithm());
        }
        if (this.configuration.getSignatureReferenceDigestMethods() != null) {
            config.setSignatureReferenceDigestMethods(this.configuration.getSignatureReferenceDigestMethods());
        }
        ArrayList<Credential> creds = new ArrayList<Credential>();
        creds.add(this.credentialProvider.getCredential());
        config.setSigningCredentials(creds);
        return config;
    }

    protected SignatureSigningParameters augmentSignatureSigningParameters(SignatureSigningParameters params) {
        return params;
    }
}

