/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.exporter.zip;

import java.io.InputStream;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.impl.base.exporter.AbstractExporterDelegate;
import org.jboss.shrinkwrap.impl.base.exporter.zip.ZipOnDemandInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ZipExporterDelegate
extends AbstractExporterDelegate<InputStream> {
    private boolean compressed;

    protected ZipExporterDelegate(Archive<?> archive) {
        super(archive);
        this.compressed = true;
        if (archive.getContent().isEmpty()) {
            throw new IllegalArgumentException("[SHRINKWRAP-93] Cannot use this JDK-based implementation to export as ZIP an archive with no content: " + archive.toString());
        }
    }

    protected ZipExporterDelegate(Archive<?> archive, boolean compressed) {
        super(archive);
        this.compressed = compressed;
        if (archive.getContent().isEmpty()) {
            throw new IllegalArgumentException("[SHRINKWRAP-93] Cannot use this JDK-based implementation to export as ZIP an archive with no content: " + archive.toString());
        }
    }

    @Override
    protected void processNode(ArchivePath path, Node node) {
    }

    @Override
    protected InputStream getResult() {
        return new ZipOnDemandInputStream(this.getArchive(), this.compressed);
    }
}

