/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.sso.impl;

import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.apache.velocity.app.VelocityEngine;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.encoder.MessageEncoder;
import org.opensaml.messaging.encoder.MessageEncodingException;
import org.opensaml.saml.common.binding.impl.SAMLOutboundDestinationHandler;
import org.opensaml.saml.common.binding.security.impl.EndpointURLSchemeSecurityHandler;
import org.opensaml.saml.common.binding.security.impl.SAMLOutboundProtocolMessageSigningHandler;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml.saml2.metadata.SSODescriptor;
import org.opensaml.saml.saml2.metadata.SingleLogoutService;
import org.pac4j.saml.context.SAML2MessageContext;
import org.pac4j.saml.crypto.SignatureSigningParametersProvider;
import org.pac4j.saml.exceptions.SAMLException;
import org.pac4j.saml.sso.SAML2MessageSender;
import org.pac4j.saml.storage.SAMLMessageStorage;
import org.pac4j.saml.transport.Pac4jHTTPPostEncoder;
import org.pac4j.saml.transport.Pac4jHTTPRedirectDeflateEncoder;
import org.pac4j.saml.transport.Pac4jSAMLResponse;
import org.pac4j.saml.util.VelocityEngineFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAML2LogoutMessageSender
implements SAML2MessageSender<LogoutRequest> {
    private static final Logger logger = LoggerFactory.getLogger(SAML2LogoutMessageSender.class);
    private final SignatureSigningParametersProvider signatureSigningParametersProvider;
    private final String destinationBindingType;
    private final boolean signErrorResponses;
    private final boolean forceSignRedirectBindingLogoutRequest;

    public SAML2LogoutMessageSender(SignatureSigningParametersProvider signatureSigningParametersProvider, String destinationBindingType, boolean signErrorResponses, boolean forceSignRedirectBindingLogoutRequest) {
        this.signatureSigningParametersProvider = signatureSigningParametersProvider;
        this.destinationBindingType = destinationBindingType;
        this.signErrorResponses = signErrorResponses;
        this.forceSignRedirectBindingLogoutRequest = forceSignRedirectBindingLogoutRequest;
    }

    @Override
    public void sendMessage(SAML2MessageContext context, LogoutRequest logoutRequest, Object relayState) {
        SPSSODescriptor spDescriptor = context.getSPSSODescriptor();
        IDPSSODescriptor idpssoDescriptor = context.getIDPSSODescriptor();
        SingleLogoutService ssoLogoutService = context.getIDPSingleLogoutService(this.destinationBindingType);
        AssertionConsumerService acsService = context.getSPAssertionConsumerService();
        MessageEncoder encoder = this.getMessageEncoder(context);
        SAML2MessageContext outboundContext = new SAML2MessageContext(context);
        outboundContext.getProfileRequestContext().setProfileId(context.getProfileRequestContext().getProfileId());
        outboundContext.getProfileRequestContext().setInboundMessageContext(context.getProfileRequestContext().getInboundMessageContext());
        outboundContext.getProfileRequestContext().setOutboundMessageContext(context.getProfileRequestContext().getOutboundMessageContext());
        outboundContext.setMessage(logoutRequest);
        outboundContext.getSAMLEndpointContext().setEndpoint((Endpoint)acsService);
        outboundContext.getSAMLPeerEndpointContext().setEndpoint((Endpoint)ssoLogoutService);
        outboundContext.getSAMLPeerEntityContext().setRole(context.getSAMLPeerEntityContext().getRole());
        outboundContext.getSAMLPeerEntityContext().setEntityId(context.getSAMLPeerEntityContext().getEntityId());
        outboundContext.getSAMLProtocolContext().setProtocol(context.getSAMLProtocolContext().getProtocol());
        outboundContext.getSecurityParametersContext().setSignatureSigningParameters(this.signatureSigningParametersProvider.build((SSODescriptor)spDescriptor));
        if (relayState != null) {
            outboundContext.getSAMLBindingContext().setRelayState(relayState.toString());
        }
        this.invokeOutboundMessageHandlers(spDescriptor, idpssoDescriptor, outboundContext);
        try {
            encoder.setMessageContext((MessageContext)outboundContext);
            encoder.initialize();
            encoder.prepareContext();
            encoder.encode();
            SAMLMessageStorage messageStorage = context.getSAMLMessageStorage();
            if (messageStorage != null) {
                messageStorage.storeMessage(logoutRequest.getID(), (XMLObject)logoutRequest);
            }
        }
        catch (MessageEncodingException e) {
            throw new SAMLException("Error encoding saml message", e);
        }
        catch (ComponentInitializationException e) {
            throw new SAMLException("Error initializing saml encoder", e);
        }
    }

    protected final void invokeOutboundMessageHandlers(SPSSODescriptor spDescriptor, IDPSSODescriptor idpssoDescriptor, SAML2MessageContext outboundContext) {
        try {
            EndpointURLSchemeSecurityHandler handlerEnd = new EndpointURLSchemeSecurityHandler();
            handlerEnd.initialize();
            handlerEnd.invoke((MessageContext)outboundContext);
            SAMLOutboundDestinationHandler handlerDest = new SAMLOutboundDestinationHandler();
            handlerDest.initialize();
            handlerDest.invoke((MessageContext)outboundContext);
            if (spDescriptor.isAuthnRequestsSigned().booleanValue()) {
                SAMLOutboundProtocolMessageSigningHandler handler = new SAMLOutboundProtocolMessageSigningHandler();
                handler.setSignErrorResponses(this.signErrorResponses);
                handler.invoke((MessageContext)outboundContext);
            } else if (idpssoDescriptor.getWantAuthnRequestsSigned().booleanValue()) {
                logger.warn("IdP wants authn requests signed, it will perhaps reject your authn requests unless you provide a keystore");
            }
        }
        catch (Exception e) {
            throw new SAMLException(e);
        }
    }

    private MessageEncoder getMessageEncoder(SAML2MessageContext ctx) {
        Pac4jSAMLResponse adapter = ctx.getProfileRequestContextOutboundMessageTransportResponse();
        if ("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST".equals(this.destinationBindingType)) {
            VelocityEngine velocityEngine = VelocityEngineFactory.getEngine();
            Pac4jHTTPPostEncoder encoder = new Pac4jHTTPPostEncoder(adapter);
            encoder.setVelocityEngine(velocityEngine);
            return encoder;
        }
        if ("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect".equals(this.destinationBindingType)) {
            Pac4jHTTPRedirectDeflateEncoder encoder = new Pac4jHTTPRedirectDeflateEncoder(adapter, this.forceSignRedirectBindingLogoutRequest);
            return encoder;
        }
        throw new UnsupportedOperationException("Binding type - " + this.destinationBindingType + " is not supported");
    }
}

