/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.launcher;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.knox.gateway.launcher.Command;

class Invoker {
    private static final String[] STRING_ARRAY = new String[0];
    private static final Class STRING_ARRAY_CLASS = STRING_ARRAY.getClass();

    Invoker() {
    }

    static void invoke(Command command) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Invoker.setSysProps(command.props);
        ClassLoader mainLoader = Invoker.createClassLoader(command.classPath);
        Class mainClass = Invoker.loadMainClass(mainLoader, command.mainClass);
        Method mainMethod = Invoker.findMainMethod(mainClass, command.mainMethod);
        Invoker.invokeMainMethod(mainLoader, mainMethod, command.mainArgs);
    }

    private static void setSysProps(Properties properties) {
        for (String name : properties.stringPropertyNames()) {
            String value = System.getProperty(name, null);
            if (value != null) continue;
            value = Invoker.resolveValue(properties, name);
            System.setProperty(name, value);
        }
    }

    private static ClassLoader createClassLoader(List<URL> urls) {
        URL[] urlArray = new URL[urls.size()];
        urls.toArray(urlArray);
        return new URLClassLoader(urlArray);
    }

    private static Class loadMainClass(ClassLoader loader, String className) throws ClassNotFoundException {
        Class<?> mainClass = loader.loadClass(className);
        return mainClass;
    }

    private static Method findMainMethod(Class mainClass, String methodName) throws NoSuchMethodException {
        Method method = mainClass.getMethod(methodName, STRING_ARRAY_CLASS);
        return method;
    }

    private static void invokeMainMethod(ClassLoader loader, Method method, String[] args) throws InvocationTargetException, IllegalAccessException {
        Thread.currentThread().setContextClassLoader(loader);
        method.invoke(method.getClass(), new Object[]{args});
    }

    private static String resolveValue(Properties properties, String name) {
        String value = properties.getProperty(name);
        Pattern pattern = Pattern.compile(".*?(\\$\\{)(.*?)(\\}).*");
        Matcher matcher = pattern.matcher(value);
        while (matcher.matches()) {
            StringBuilder resolvedValue = new StringBuilder(value.length());
            resolvedValue.append(value.substring(0, matcher.start(1)));
            String varName = matcher.group(2);
            String varVal = properties.getProperty(varName);
            if (varVal != null) {
                resolvedValue.append(varVal);
            }
            resolvedValue.append(value.substring(matcher.end(3)));
            value = resolvedValue.toString();
            matcher = pattern.matcher(value);
        }
        return value;
    }
}

