/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.webappsec.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class StrictTransportFilter
implements Filter {
    private static final String STRICT_TRANSPORT = "Strict-Transport-Security";
    private static final String CUSTOM_HEADER_PARAM = "strict.transport";
    private String option = "max-age=31536000";

    public void destroy() {
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        ((HttpServletResponse)res).setHeader(STRICT_TRANSPORT, this.option);
        chain.doFilter(req, (ServletResponse)new StrictTransportResponseWrapper((HttpServletResponse)res));
    }

    public void init(FilterConfig config) throws ServletException {
        String customOption = config.getInitParameter(CUSTOM_HEADER_PARAM);
        if (customOption != null) {
            this.option = customOption;
        }
    }

    public class StrictTransportResponseWrapper
    extends HttpServletResponseWrapper {
        public void addHeader(String name, String value) {
            if (!name.equals(StrictTransportFilter.STRICT_TRANSPORT)) {
                super.addHeader(name, value);
            }
        }

        public void setHeader(String name, String value) {
            if (!name.equals(StrictTransportFilter.STRICT_TRANSPORT)) {
                super.setHeader(name, value);
            }
        }

        public StrictTransportResponseWrapper(HttpServletResponse response) {
            super(response);
        }

        public String getHeader(String name) {
            String headerValue = null;
            headerValue = name.equals(StrictTransportFilter.STRICT_TRANSPORT) ? StrictTransportFilter.this.option : super.getHeader(name);
            return headerValue;
        }

        public Collection<String> getHeaderNames() {
            ArrayList<String> names = (ArrayList<String>)super.getHeaderNames();
            if (names == null) {
                names = new ArrayList<String>();
            }
            names.add(StrictTransportFilter.STRICT_TRANSPORT);
            return names;
        }

        public Collection<String> getHeaders(String name) {
            ArrayList<String> values = (ArrayList<String>)super.getHeaders(name);
            if (name.equals(StrictTransportFilter.STRICT_TRANSPORT)) {
                if (values == null) {
                    values = new ArrayList<String>();
                }
                values.add(StrictTransportFilter.this.option);
            }
            return values;
        }
    }
}

