/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.querydef;

import java.io.Serializable;
import java.util.List;
import javax.persistence.Tuple;
import javax.persistence.TupleElement;
import javax.persistence.criteria.Selection;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.queries.ReportQueryResult;

public class TupleImpl
implements Tuple,
Serializable {
    protected List<? super Selection<?>> selections;
    protected ReportQueryResult rqr;

    public TupleImpl(List<? super Selection<?>> selections, ReportQueryResult rqr) {
        this.selections = selections;
        this.rqr = rqr;
    }

    @Override
    public <X> X get(TupleElement<X> tupleElement) {
        int index = this.selections.indexOf(tupleElement);
        if (index == -1) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("jpa_criteriaapi_no_corresponding_element_in_result", new Object[]{tupleElement}));
        }
        return (X)this.get(index);
    }

    @Override
    public <X> X get(String alias, Class<X> type) {
        Object result = this.get(alias);
        if (type == null || result != null && !type.isInstance(result)) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("jpa_criteriaapi_invalid_result_type", new Object[]{alias, type, result}));
        }
        return (X)result;
    }

    @Override
    public Object get(String alias) {
        int index = this.rqr.getNames().indexOf(alias);
        if (index == -1) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("jpa_criteriaapi_no_corresponding_element_in_result", new Object[]{alias}));
        }
        return this.get(index);
    }

    @Override
    public <X> X get(int i, Class<X> type) {
        Object result = this.get(i);
        if (type == null || result != null && !type.isInstance(result)) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("jpa_criteriaapi_invalid_result_type", new Object[]{i, type, result}));
        }
        return (X)result;
    }

    @Override
    public Object get(int i) {
        if (i < 0 || i >= this.rqr.getResults().size()) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("jpa_criteriaapi_invalid_result_index", new Object[]{i, this.rqr.getResults().size()}));
        }
        return this.rqr.getByIndex(i);
    }

    @Override
    public Object[] toArray() {
        return this.rqr.getResults().toArray();
    }

    @Override
    public List<TupleElement<?>> getElements() {
        return this.selections;
    }
}

