/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.cm.model.solr;

import com.cloudera.api.swagger.model.ApiConfigList;
import com.cloudera.api.swagger.model.ApiRole;
import com.cloudera.api.swagger.model.ApiService;
import com.cloudera.api.swagger.model.ApiServiceConfig;
import java.util.Locale;
import org.apache.knox.gateway.topology.discovery.cm.ServiceModel;
import org.apache.knox.gateway.topology.discovery.cm.model.AbstractServiceModelGenerator;

public class SolrServiceModelGenerator
extends AbstractServiceModelGenerator {
    private static final String SERVICE = "SOLR";
    private static final String SERVICE_TYPE = "SOLR";
    private static final String ROLE_TYPE = "SOLR_SERVER";

    @Override
    public boolean handles(ApiService service, ApiServiceConfig serviceConfig, ApiRole role, ApiConfigList roleConfig) {
        return "SOLR".equals(service.getType()) && ROLE_TYPE.equals(role.getType());
    }

    @Override
    public ServiceModel generateService(ApiService service, ApiServiceConfig serviceConfig, ApiRole role, ApiConfigList roleConfig) {
        String port;
        String scheme;
        String hostname = role.getHostRef().getHostname();
        boolean sslEnabled = Boolean.parseBoolean(this.getServiceConfigValue(serviceConfig, "solr_use_ssl"));
        if (sslEnabled) {
            scheme = "https";
            port = this.getRoleConfigValue(roleConfig, "solr_https_port");
        } else {
            scheme = "http";
            port = this.getRoleConfigValue(roleConfig, "solr_http_port");
        }
        return new ServiceModel(ServiceModel.Type.API, "SOLR", String.format(Locale.getDefault(), "%s://%s:%s/solr/", scheme, hostname, port));
    }
}

